/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.client.pvms;

import java.net.InetAddress;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.epics.pvaccess.client.pvms.PVMSSubscriber;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;

public class PVMSLoggerSubscriber {
    private static String lineSeparator = System.getProperty("line.separator");
    private static SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static Date date = new Date();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatNTLogRecord(PVStructure log) {
        StringBuffer sb = new StringBuffer(128);
        PVStructure time = (PVStructure)log.getSubField(PVStructure.class, "time");
        PVLong secsPastEpoch = (PVLong)time.getSubField(PVLong.class, "secsPastEpoch");
        PVInt nanoseconds = (PVInt)time.getSubField(PVInt.class, "nanoseconds");
        long millis = secsPastEpoch.get() * 1000L + (long)(nanoseconds.get() / 1000000);
        Date date = PVMSLoggerSubscriber.date;
        synchronized (date) {
            PVMSLoggerSubscriber.date.setTime(millis);
            sb.append(timeFormatter.format(PVMSLoggerSubscriber.date));
        }
        PVString loggerName = (PVString)log.getSubField(PVString.class, "loggerName");
        PVString host = (PVString)log.getSubField(PVString.class, "host");
        PVString process = (PVString)log.getSubField(PVString.class, "process");
        sb.append(' ');
        sb.append('[');
        sb.append(process.get());
        sb.append('@');
        sb.append(host.get());
        sb.append('/');
        sb.append(loggerName.get());
        sb.append(']');
        PVInt level = (PVInt)log.getSubField(PVInt.class, "level");
        Level javaLevel = Level.parse(String.valueOf(level.get()));
        sb.append(' ');
        sb.append('[');
        sb.append(javaLevel);
        sb.append(']');
        PVString message = (PVString)log.getSubField(PVString.class, "message");
        sb.append(' ');
        sb.append(message.get());
        sb.append(' ');
        PVString stackTrace = (PVString)log.getSubField(PVString.class, "stackTrace");
        String stack = stackTrace.get();
        if (stack != null && stack.length() > 0) {
            sb.append(lineSeparator);
            sb.append(stack);
        }
        return new String(sb);
    }

    public static void main(String[] args) throws Throwable {
        InetAddress address = InetAddress.getByName("224.0.0.1");
        int port = 5678;
        final PVMSSubscriber subscriber = new PVMSSubscriber(address, 5678);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String[] filterTags = new String[]{};
                    PVMSSubscriber.PVMSMessage message = new PVMSSubscriber.PVMSMessage("log", null, null);
                    while (true) {
                        subscriber.receive(message, filterTags);
                        System.out.println(PVMSLoggerSubscriber.formatNTLogRecord((PVStructure)message.data));
                    }
                }
                catch (SocketException filterTags) {
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        }, "receiver-thread").start();
    }
}

