/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.util.BooleanHolder;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Type;

public final class IntrospectionRegistry {
    protected Map<Short, Field> registry = new HashMap<Short, Field>();
    protected short pointer;
    private Short shortHolder = 0;
    public static final byte NULL_TYPE_CODE = -1;
    public static final byte ONLY_ID_TYPE_CODE = -2;
    public static final byte FULL_WITH_ID_TYPE_CODE = -3;
    static final FieldCreate fieldCreate = PVFactory.getFieldCreate();

    public IntrospectionRegistry() {
        this.reset();
    }

    public void reset() {
        this.pointer = 1;
        this.registry.clear();
    }

    public Field getIntrospectionInterface(short id) {
        return this.registry.get(id);
    }

    public void registerIntrospectionInterface(short id, Field field) {
        this.registry.put(id, field);
    }

    public short registerIntrospectionInterface(Field field, BooleanHolder existing) {
        Field potentiallyExistingField = this.registry.get(this.shortHolder);
        if (potentiallyExistingField != null && potentiallyExistingField.equals(field)) {
            existing.value = true;
            return this.shortHolder;
        }
        existing.value = false;
        short s = this.pointer;
        this.pointer = (short)(s + 1);
        short key = s;
        this.registry.put(key, field);
        return key;
    }

    public final void serialize(Field field, ByteBuffer buffer, SerializableControl control) {
        if (field == null) {
            SerializationHelper.serializeNullField(buffer, control);
        } else {
            if (field.getType() != Type.scalar && field.getType() != Type.scalarArray) {
                BooleanHolder existing = new BooleanHolder();
                short key = this.registerIntrospectionInterface(field, existing);
                if (existing.value) {
                    control.ensureBuffer(3);
                    buffer.put((byte)-2);
                    buffer.putShort(key);
                    return;
                }
                control.ensureBuffer(3);
                buffer.put((byte)-3);
                buffer.putShort(key);
            }
            field.serialize(buffer, control);
        }
    }

    public final Field deserialize(ByteBuffer buffer, DeserializableControl control) {
        control.ensureData(1);
        int pos = buffer.position();
        byte typeCode = buffer.get();
        if (typeCode == -1) {
            return null;
        }
        if (typeCode == -2) {
            control.ensureData(2);
            return this.getIntrospectionInterface(buffer.getShort());
        }
        if (typeCode == -3) {
            control.ensureData(2);
            short key = buffer.getShort();
            Field field = fieldCreate.deserialize(buffer, control);
            this.registerIntrospectionInterface(key, field);
            return field;
        }
        buffer.position(pos);
        return fieldCreate.deserialize(buffer, control);
    }
}

