/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote;

import java.nio.ByteBuffer;
import org.epics.pvaccess.PVFactory;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Structure;

public class SerializationHelper {
    private static final PVDataCreate pvDataCreate = PVFactory.getPVDataCreate();
    static Convert convert = ConvertFactory.getConvert();

    public static final PVStructure deserializePVRequest(ByteBuffer payloadBuffer, DeserializableControl control) {
        return SerializationHelper.deserializeStructureFull(payloadBuffer, control);
    }

    public static final PVStructure deserializeStructureAndCreatePVStructure(ByteBuffer payloadBuffer, DeserializableControl control) {
        return SerializationHelper.deserializeStructureAndCreatePVStructure(payloadBuffer, control, null);
    }

    public static final PVStructure deserializeStructureAndCreatePVStructure(ByteBuffer payloadBuffer, DeserializableControl control, PVStructure existingStructure) {
        Field field = control.cachedDeserialize(payloadBuffer);
        if (field == null) {
            return null;
        }
        if (existingStructure != null && field.equals(existingStructure.getField())) {
            return existingStructure;
        }
        return pvDataCreate.createPVStructure((Structure)field);
    }

    public static final PVStructure deserializeStructureFull(ByteBuffer payloadBuffer, DeserializableControl control) {
        return (PVStructure)SerializationHelper.deserializeFull(payloadBuffer, control);
    }

    public static final PVField deserializeFull(ByteBuffer payloadBuffer, DeserializableControl control) {
        PVField pvField = null;
        Field field = control.cachedDeserialize(payloadBuffer);
        if (field != null) {
            pvField = pvDataCreate.createPVField(field);
            pvField.deserialize(payloadBuffer, control);
        }
        return pvField;
    }

    public static final void serializeNullField(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        buffer.put((byte)-1);
    }

    public static final void serializePVRequest(ByteBuffer buffer, SerializableControl control, PVStructure pvRequest) {
        SerializationHelper.serializeStructureFull(buffer, control, pvRequest);
    }

    public static final void serializeStructureFull(ByteBuffer buffer, SerializableControl control, PVStructure pvStructure) {
        SerializationHelper.serializeFull(buffer, control, (PVField)pvStructure);
    }

    public static final void serializeFull(ByteBuffer buffer, SerializableControl control, PVField pvField) {
        if (pvField == null) {
            SerializationHelper.serializeNullField(buffer, control);
        } else {
            control.cachedSerialize(pvField.getField(), buffer);
            pvField.serialize(buffer, control);
        }
    }

    public static void copyUnchecked(PVField from, PVField to) {
        convert.copy(from, to);
    }

    public static void copyStructureUnchecked(PVStructure from, PVStructure to) {
        if (from == to) {
            return;
        }
        PVField[] fromPVFields = from.getPVFields();
        PVField[] toPVFields = to.getPVFields();
        for (int i = 0; i < fromPVFields.length; ++i) {
            PVField pvField = fromPVFields[i];
            int numberFields = pvField.getNumberFields();
            if (numberFields == 1) {
                SerializationHelper.copyUnchecked(pvField, toPVFields[i]);
                continue;
            }
            SerializationHelper.copyStructureUnchecked((PVStructure)pvField, (PVStructure)toPVFields[i]);
        }
    }

    public static void partialCopy(PVStructure from, PVStructure to, BitSet maskBitSet) {
        SerializationHelper.partialCopy(from, to, maskBitSet, false);
    }

    public static void partialCopy(PVStructure from, PVStructure to, BitSet maskBitSet, boolean inverse) {
        int next;
        if (from == to) {
            return;
        }
        int offset = from.getFieldOffset();
        int numberFields = from.getNumberFields();
        int n = next = inverse ? maskBitSet.nextClearBit(offset) : maskBitSet.nextSetBit(offset);
        if (next < 0 || next >= offset + numberFields) {
            return;
        }
        if (offset == next) {
            SerializationHelper.copyStructureUnchecked(from, to);
            return;
        }
        PVField[] fromPVFields = from.getPVFields();
        PVField[] toPVFields = to.getPVFields();
        for (int i = 0; i < fromPVFields.length; ++i) {
            PVField pvField = fromPVFields[i];
            offset = pvField.getFieldOffset();
            numberFields = pvField.getNumberFields();
            int n2 = next = inverse ? maskBitSet.nextClearBit(offset) : maskBitSet.nextSetBit(offset);
            if (next < 0) {
                return;
            }
            if (next >= offset + numberFields) continue;
            if (numberFields == 1) {
                SerializationHelper.copyUnchecked(pvField, toPVFields[i]);
                continue;
            }
            SerializationHelper.partialCopy((PVStructure)pvField, (PVStructure)toPVFields[i], maskBitSet, inverse);
        }
    }
}

