/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.codec.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvaccess.impl.remote.codec.AbstractCodec;
import org.epics.pvaccess.impl.remote.codec.ConnectionClosedException;

public abstract class BlockingAbstractCodec
extends AbstractCodec {
    private final boolean debug = Integer.getInteger("EPICS_PVA_DEBUG", 0) >= 3;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private volatile Thread readThread = null;
    private volatile Thread sendThread = null;

    public BlockingAbstractCodec(boolean serverFlag, ByteBuffer receiveBuffer, ByteBuffer sendBuffer, int socketSendBufferSize, Logger logger) {
        super(serverFlag, receiveBuffer, sendBuffer, socketSendBufferSize, true, logger);
    }

    @Override
    public void readPollOne() throws IOException {
        throw new IllegalStateException("should not be called for blocking IO");
    }

    @Override
    public void writePollOne() throws IOException {
        throw new IllegalStateException("should not be called for blocking IO");
    }

    @Override
    protected void sendBufferFull(int tries) throws IOException {
        try {
            Thread.sleep(Math.max(tries * 100, 1000));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void scheduleSend() {
    }

    @Override
    public void sendCompleted() {
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen.getAndSet(false)) {
            this.readThread.interrupt();
            this.sendQueue.wakeup();
        }
    }

    @Override
    public boolean terminated() {
        return !this.isOpen();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen.get();
    }

    public void start() {
        this.readThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BlockingAbstractCodec.this.receiveThread();
            }
        }, "receiveThread");
        this.readThread.start();
        this.sendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                BlockingAbstractCodec.this.sendThread();
            }
        }, "sendThread");
        this.sendThread.start();
    }

    public void receiveThread() {
        while (this.isOpen()) {
            try {
                this.processRead();
            }
            catch (ConnectionClosedException connectionClosedException) {
            }
            catch (IOException e) {
                if (!this.debug) continue;
                this.logger.log(Level.FINER, "IO exception caught in read thread.", e);
            }
        }
    }

    public void sendThread() {
        this.setSenderThread();
        while (this.isOpen()) {
            try {
                this.processWrite();
            }
            catch (ConnectionClosedException connectionClosedException) {
            }
            catch (IOException e) {
                if (!this.debug) continue;
                this.logger.log(Level.FINER, "IO exception caught in send thread.", e);
            }
        }
        try {
            this.readThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.internalDestroy();
    }

    abstract void internalDestroy();
}

