/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.codec.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.logging.Logger;
import org.epics.pvaccess.impl.remote.codec.AbstractCodec;
import org.epics.pvaccess.impl.remote.codec.impl.BlockingAbstractCodec;

public abstract class BlockingDatagramAbstractCodec
extends BlockingAbstractCodec {
    private final DatagramChannel channel;
    private final InetSocketAddress socketAddress;

    public BlockingDatagramAbstractCodec(boolean serverFlag, DatagramChannel channel, ByteBuffer receiveBuffer, ByteBuffer sendBuffer, Logger logger) throws SocketException {
        super(serverFlag, receiveBuffer, sendBuffer, channel.socket().getSendBufferSize(), logger);
        this.channel = channel;
        if (!channel.socket().isConnected()) {
            throw new IllegalArgumentException("only connected datagram sockets are allowed");
        }
        this.socketAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    void internalDestroy() {
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public InetSocketAddress getLastReadBufferSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public void invalidDataStreamHandler() {
        this.socketBuffer.clear();
        this.readMode = AbstractCodec.ReadMode.NORMAL;
    }
}

