/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.io.impl;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.epics.pvaccess.impl.remote.io.PollEvents;
import org.epics.pvaccess.impl.remote.io.Poller;

public class PollerImpl
implements Poller,
Runnable {
    final Selector selector;
    private int trottle = 0;
    ConcurrentLinkedQueue<RegistrationRequest> registrations = new ConcurrentLinkedQueue();

    public PollerImpl() throws IOException {
        this.selector = Selector.open();
    }

    public void start() {
        Thread t = new Thread((Runnable)this, "PollerImpl-");
        t.start();
    }

    @Override
    public void add(SelectableChannel channel, PollEvents handler, int ops) {
        this.registrations.add(new RegistrationRequest(channel, handler, ops));
        this.selector.wakeup();
    }

    @Override
    public void modify(SelectionKey key, int ops) {
        key.interestOps(ops);
        this.selector.wakeup();
    }

    @Override
    public void remove(SelectionKey key) {
        key.cancel();
    }

    @Override
    public void pollOne() throws IOException {
        int numSelectedKeys;
        RegistrationRequest rr;
        while ((rr = this.registrations.poll()) != null) {
            try {
                SelectionKey key = rr.channel.register(this.selector, rr.ops, rr.handler);
                rr.handler.registeredNotify(key, null);
            }
            catch (Throwable registrationException) {
                rr.handler.registeredNotify(null, registrationException);
            }
        }
        if (this.trottle == 0) {
            numSelectedKeys = this.selector.select();
        } else {
            numSelectedKeys = this.selector.selectNow();
            --this.trottle;
        }
        if (numSelectedKeys == 0) {
            return;
        }
        Iterator<SelectionKey> selectedKeysIterator = this.selector.selectedKeys().iterator();
        while (selectedKeysIterator.hasNext()) {
            SelectionKey key = selectedKeysIterator.next();
            selectedKeysIterator.remove();
            PollEvents pollEvents = (PollEvents)key.attachment();
            try {
                pollEvents.pollNotify(key);
            }
            catch (CancelledKeyException cancelledKeyException) {}
        }
        this.trottle = 5;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.pollOne();
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            return;
        }
    }

    static class RegistrationRequest {
        final SelectableChannel channel;
        final PollEvents handler;
        final int ops;

        public RegistrationRequest(SelectableChannel channel, PollEvents handler, int ops) {
            this.channel = channel;
            this.handler = handler;
            this.ops = ops;
        }
    }
}

