/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.impl.remote.udp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.UnresolvedAddressException;
import java.util.Set;
import java.util.logging.Level;
import org.epics.pvaccess.PVFactory;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.ProtocolType;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportClient;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.plugins.SecurityPlugin;
import org.epics.pvaccess.server.ServerContext;
import org.epics.pvaccess.util.InetAddressUtil;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FieldCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class BlockingUDPTransport
implements Transport,
TransportSendControl {
    private final Context context;
    private final DatagramChannel channel;
    private InetSocketAddress socketAddress;
    private InetSocketAddress bindAddress;
    private InetSocketAddress[] sendAddresses;
    private boolean[] isSendAddressUnicast;
    private InetSocketAddress[] ignoredAddresses = null;
    private final ByteBuffer receiveBuffer;
    private final ByteBuffer sendBuffer;
    protected final ResponseHandler responseHandler;
    protected volatile boolean closed = false;
    private int lastMessageStartPosition = 0;
    private final int clientServerWithBigEndianFlag;
    private InetSocketAddress sendTo = null;
    private static final FieldCreate fieldCreate = PVFactory.getFieldCreate();

    public BlockingUDPTransport(Context context, ResponseHandler responseHandler, DatagramChannel channel, InetSocketAddress bindAddress, InetSocketAddress[] sendAddresses, short remoteTransportRevision) {
        this.context = context;
        this.clientServerWithBigEndianFlag = context instanceof ServerContext ? 192 : 128;
        this.responseHandler = responseHandler;
        this.channel = channel;
        this.bindAddress = bindAddress;
        this.setSendAddresses(sendAddresses);
        try {
            this.socketAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
        }
        catch (Throwable th) {
            context.getLogger().log(Level.FINER, "Failed to obtain local socket address.", th);
        }
        this.receiveBuffer = ByteBuffer.allocate(65487);
        this.sendBuffer = ByteBuffer.allocate(1440);
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!BlockingUDPTransport.this.closed) {
                    try {
                        BlockingUDPTransport.this.processRead();
                    }
                    catch (Throwable th) {
                        BlockingUDPTransport.this.context.getLogger().log(Level.FINE, "Uncaught exception caught.", th);
                    }
                }
            }
        }, "UDP-receive " + this.socketAddress).start();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.bindAddress != null) {
            this.context.getLogger().finer("UDP connection to " + this.bindAddress + " closed.");
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean acquire(TransportClient client) {
        return false;
    }

    @Override
    public void release(TransportClient client) {
    }

    protected void processRead() {
        try {
            while (!this.closed) {
                this.receiveBuffer.clear();
                InetSocketAddress fromAddress = (InetSocketAddress)this.channel.receive(this.receiveBuffer);
                if (fromAddress != null) {
                    if (this.ignoredAddresses != null) {
                        boolean ignore = false;
                        InetAddress fromAddressOnly = fromAddress.getAddress();
                        for (int i = 0; i < this.ignoredAddresses.length; ++i) {
                            if (!this.ignoredAddresses[i].getAddress().equals(fromAddressOnly)) continue;
                            ignore = true;
                            break;
                        }
                        if (ignore) continue;
                    }
                    this.receiveBuffer.flip();
                    this.processBuffer(fromAddress, this.receiveBuffer);
                    continue;
                }
                break;
            }
        }
        catch (AsynchronousCloseException ace) {
            try {
                this.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (ClosedChannelException cce) {
            try {
                this.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    private final boolean processBuffer(InetSocketAddress fromAddress, ByteBuffer receiveBuffer) {
        while (receiveBuffer.remaining() >= 8) {
            byte magic = receiveBuffer.get();
            if (magic != -54) {
                return false;
            }
            byte version = receiveBuffer.get();
            byte flags = receiveBuffer.get();
            if ((flags & 0x80) != 0) {
                receiveBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                receiveBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            byte command = receiveBuffer.get();
            int payloadSize = receiveBuffer.getInt();
            if ((flags & 1) != 0) continue;
            int nextRequestPosition = receiveBuffer.position() + payloadSize;
            if (nextRequestPosition > receiveBuffer.limit()) {
                return false;
            }
            this.responseHandler.handleResponse(fromAddress, this, version, command, payloadSize, receiveBuffer);
            receiveBuffer.position(nextRequestPosition);
        }
        return true;
    }

    protected void processWrite() {
    }

    public boolean send(ByteBuffer buffer, InetAddressType target) {
        if (this.sendAddresses == null) {
            return false;
        }
        for (int i = 0; i < this.sendAddresses.length; ++i) {
            if (target != InetAddressType.ALL && (target == InetAddressType.UNICAST && !this.isSendAddressUnicast[i] || target == InetAddressType.BROADCAST_MULTICAST && this.isSendAddressUnicast[i])) continue;
            try {
                buffer.flip();
                this.channel.send(buffer, this.sendAddresses[i]);
                continue;
            }
            catch (NoRouteToHostException nrthe) {
                this.context.getLogger().log(Level.FINER, "No route to host exception caught when sending to: " + this.sendAddresses[i] + ".", nrthe);
                continue;
            }
            catch (UnresolvedAddressException uae) {
                this.context.getLogger().log(Level.FINER, "Unresolved address exception caught when sending to: " + this.sendAddresses[i] + ".", uae);
                continue;
            }
            catch (Throwable th) {
                this.context.getLogger().log(Level.FINER, "Exception caught when sending to: " + this.sendAddresses[i] + ".", th);
            }
        }
        return true;
    }

    public boolean send(ByteBuffer buffer) {
        return this.send(buffer, InetAddressType.ALL);
    }

    public void send(ByteBuffer buffer, InetSocketAddress address) {
        try {
            buffer.flip();
            this.channel.send(buffer, address);
        }
        catch (NoRouteToHostException nrthe) {
            this.context.getLogger().log(Level.FINER, "No route to host exception caught when sending to: " + address + ".", nrthe);
        }
        catch (UnresolvedAddressException uae) {
            this.context.getLogger().log(Level.FINER, "Unresolved address exception caught when sending to: " + address + ".", uae);
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.FINER, "Exception caught when sending to: " + address + ".", th);
        }
    }

    public MembershipKey join(InetAddress group, NetworkInterface nif) throws IOException {
        return this.channel.join(group, nif);
    }

    public void setMutlicastNIF(NetworkInterface nif, boolean loopback) throws IOException {
        this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)true);
        this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, nif);
    }

    @Override
    public byte getRevision() {
        return 1;
    }

    @Override
    public String getType() {
        return ProtocolType.udp.name();
    }

    @Override
    public void changedTransport() {
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public short getPriority() {
        return 0;
    }

    public boolean flush() {
        return true;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.socketAddress;
    }

    public InetSocketAddress[] getSendAddresses() {
        return this.sendAddresses;
    }

    public InetSocketAddress[] getIgnoredAddresses() {
        return this.ignoredAddresses;
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setSendAddresses(InetSocketAddress[] addresses) {
        this.sendAddresses = addresses;
        this.isSendAddressUnicast = new boolean[this.sendAddresses.length];
        Set<InetAddress> broadcastAddresses = InetAddressUtil.getBroadcastAddresses();
        for (int i = 0; i < this.sendAddresses.length; ++i) {
            InetAddress address = this.sendAddresses[i].getAddress();
            this.isSendAddressUnicast[i] = address == null || !broadcastAddresses.contains(address) && !address.isMulticastAddress();
        }
    }

    public void setIgnoredAddresses(InetSocketAddress[] addresses) {
        this.ignoredAddresses = addresses;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBuffer.capacity();
    }

    @Override
    public void setRemoteRevision(byte minor) {
    }

    @Override
    public void setRemoteTransportReceiveBufferSize(int receiveBufferSize) {
    }

    @Override
    public void setRemoteTransportSocketReceiveBufferSize(int socketReceiveBufferSize) {
    }

    @Override
    public int getSocketReceiveBufferSize() {
        try {
            return this.channel.socket().getReceiveBufferSize();
        }
        catch (SocketException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enqueueSendRequest(TransportSender sender) {
        BlockingUDPTransport blockingUDPTransport = this;
        synchronized (blockingUDPTransport) {
            this.sendTo = null;
            this.sendBuffer.clear();
            sender.lock();
            try {
                sender.send(this.sendBuffer, this);
                sender.unlock();
                this.endMessage();
                if (this.sendTo != null) {
                    this.send(this.sendBuffer, this.sendTo);
                } else {
                    this.send(this.sendBuffer);
                }
            }
            catch (Throwable th) {
                sender.unlock();
                th.printStackTrace();
            }
        }
    }

    public void ensureBuffer(int size) {
    }

    public void alignBuffer(int alignment) {
        int k = alignment - 1;
        int pos = this.sendBuffer.position();
        int newpos = pos + k & ~k;
        this.sendBuffer.position(newpos);
    }

    public void flushSerializeBuffer() {
    }

    @Override
    public void flush(boolean lastMessageCompleted) {
    }

    @Override
    public final void startMessage(byte command, int ensureCapacity) {
        this.lastMessageStartPosition = this.sendBuffer.position();
        this.sendBuffer.put((byte)-54);
        this.sendBuffer.put((byte)1);
        this.sendBuffer.put((byte)this.clientServerWithBigEndianFlag);
        this.sendBuffer.put(command);
        this.sendBuffer.putInt(0);
    }

    @Override
    public final void endMessage() {
        this.sendBuffer.putInt(this.lastMessageStartPosition + 4, this.sendBuffer.position() - this.lastMessageStartPosition - 8);
    }

    @Override
    public final void setRecipient(InetSocketAddress sendTo) {
        this.sendTo = sendTo;
    }

    public void ensureData(int size) {
        if (this.receiveBuffer.remaining() < size) {
            throw new BufferUnderflowException();
        }
    }

    public void cachedSerialize(Field field, ByteBuffer buffer) {
        field.serialize(buffer, (SerializableControl)this);
    }

    public Field cachedDeserialize(ByteBuffer buffer) {
        return fieldCreate.deserialize(buffer, (DeserializableControl)this);
    }

    public void alignData(int alignment) {
        int k = alignment - 1;
        int pos = this.receiveBuffer.position();
        int newpos = pos + k & ~k;
        this.receiveBuffer.position(newpos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByteOrder(ByteOrder byteOrder) {
        this.receiveBuffer.order(byteOrder);
        BlockingUDPTransport blockingUDPTransport = this;
        synchronized (blockingUDPTransport) {
            this.sendBuffer.order(byteOrder);
        }
    }

    @Override
    public boolean verify(long timeoutMs) {
        return true;
    }

    @Override
    public void verified(Status status) {
    }

    @Override
    public void aliveNotification() {
    }

    @Override
    public void authNZMessage(PVField data) {
    }

    @Override
    public void authNZInitialize(Object data) {
    }

    @Override
    public SecurityPlugin.SecuritySession getSecuritySession() {
        return null;
    }

    public static enum InetAddressType {
        ALL,
        UNICAST,
        BROADCAST_MULTICAST;

    }
}

