/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.handlers;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.epics.pvaccess.impl.remote.PipelineMonitor;
import org.epics.pvaccess.impl.remote.QoS;
import org.epics.pvaccess.impl.remote.SerializationHelper;
import org.epics.pvaccess.impl.remote.Transport;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.server.impl.remote.ServerChannelImpl;
import org.epics.pvaccess.server.impl.remote.ServerContextImpl;
import org.epics.pvaccess.server.impl.remote.handlers.AbstractServerResponseHandler;
import org.epics.pvaccess.server.impl.remote.handlers.BaseChannelRequester;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.monitor.Monitor;
import org.epics.pvdata.monitor.MonitorElement;
import org.epics.pvdata.monitor.MonitorRequester;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.Structure;

public class MonitorHandler
extends AbstractServerResponseHandler {
    public MonitorHandler(ServerContextImpl context) {
        super(context, "Monitor request");
    }

    @Override
    public void handleResponse(InetSocketAddress responseFrom, Transport transport, byte version, byte command, int payloadSize, ByteBuffer payloadBuffer) {
        super.handleResponse(responseFrom, transport, version, command, payloadSize, payloadBuffer);
        ChannelHostingTransport casTransport = (ChannelHostingTransport)((Object)transport);
        transport.ensureData(9);
        int sid = payloadBuffer.getInt();
        int ioid = payloadBuffer.getInt();
        byte qosCode = payloadBuffer.get();
        ServerChannelImpl channel = (ServerChannelImpl)casTransport.getChannel(sid);
        if (channel == null) {
            BaseChannelRequester.sendFailureMessage((byte)13, transport, ioid, qosCode, BaseChannelRequester.badCIDStatus);
            return;
        }
        boolean init = QoS.INIT.isSet(qosCode);
        if (init) {
            PVStructure pvRequest = SerializationHelper.deserializePVRequest(payloadBuffer, transport);
            Status asStatus = channel.getChannelSecuritySession().authorizeCreateMonitor(ioid, pvRequest);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)13, transport, ioid, (byte)QoS.INIT.getMaskValue(), asStatus);
                return;
            }
            new MonitorRequesterImpl(this.context, channel, ioid, transport, pvRequest);
            boolean ack = QoS.GET_PUT.isSet(qosCode);
            if (ack) {
                transport.ensureData(4);
                int nfree = payloadBuffer.getInt();
                MonitorRequesterImpl request = (MonitorRequesterImpl)channel.getRequest(ioid);
                Monitor channelMonitor = request.getChannelMonitor();
                if (channelMonitor instanceof PipelineMonitor) {
                    ((PipelineMonitor)channelMonitor).reportRemoteQueueStatus(nfree);
                }
            }
        } else {
            boolean lastRequest = QoS.DESTROY.isSet(qosCode);
            boolean get = QoS.GET.isSet(qosCode);
            boolean process = QoS.PROCESS.isSet(qosCode);
            boolean ack = QoS.GET_PUT.isSet(qosCode);
            MonitorRequesterImpl request = (MonitorRequesterImpl)channel.getRequest(ioid);
            if (request == null) {
                BaseChannelRequester.sendFailureMessage((byte)13, transport, ioid, qosCode, BaseChannelRequester.badIOIDStatus);
                return;
            }
            if (ack) {
                transport.ensureData(4);
                int nfree = payloadBuffer.getInt();
                Monitor channelMonitor = request.getChannelMonitor();
                if (channelMonitor instanceof PipelineMonitor) {
                    ((PipelineMonitor)channelMonitor).reportRemoteQueueStatus(nfree);
                }
                return;
            }
            Status asStatus = channel.getChannelSecuritySession().authorizeGet(ioid);
            if (!asStatus.isSuccess()) {
                BaseChannelRequester.sendFailureMessage((byte)13, transport, ioid, qosCode, asStatus);
                if (lastRequest) {
                    request.destroy();
                }
                return;
            }
            if (process) {
                if (get) {
                    request.getChannelMonitor().start();
                } else {
                    request.getChannelMonitor().stop();
                }
            } else if (get) {
                // empty if block
            }
            if (lastRequest) {
                request.destroy();
            }
        }
    }

    private static class MonitorRequesterImpl
    extends BaseChannelRequester
    implements MonitorRequester,
    TransportSender {
        private volatile Monitor channelMonitor;
        private Status status;
        private volatile Structure structure;
        private volatile Monitor monitor;
        private volatile boolean unlisten = false;

        public MonitorRequesterImpl(ServerContextImpl context, ServerChannelImpl channel, int ioid, Transport transport, PVStructure pvRequest) {
            super(context, channel, ioid, transport);
            this.startRequest(QoS.INIT.getMaskValue());
            channel.registerRequest(ioid, this);
            try {
                this.channelMonitor = channel.getChannel().createMonitor(this, pvRequest);
            }
            catch (Throwable th) {
                BaseChannelRequester.sendFailureMessage((byte)13, transport, ioid, (byte)QoS.INIT.getMaskValue(), statusCreate.createStatus(Status.StatusType.FATAL, "Unexpected exception caught: " + th.getMessage(), th));
                this.destroy();
            }
        }

        public void unlisten(Monitor monitor) {
            this.unlisten = true;
            this.transport.enqueueSendRequest(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorConnect(Status status, Monitor monitor, Structure structure) {
            MonitorRequesterImpl monitorRequesterImpl = this;
            synchronized (monitorRequesterImpl) {
                this.status = status;
                this.monitor = monitor;
                this.structure = structure;
                this.monitor = monitor;
            }
            this.transport.enqueueSendRequest(this);
            if (!status.isSuccess()) {
                this.destroy();
            }
        }

        public void monitorEvent(Monitor monitor) {
            this.transport.enqueueSendRequest(this);
        }

        public void destroy() {
            this.channel.unregisterRequest(this.ioid);
            this.channel.getChannelSecuritySession().release(this.ioid);
            if (this.channelMonitor != null) {
                this.channelMonitor.destroy();
            }
        }

        public Monitor getChannelMonitor() {
            return this.channelMonitor;
        }

        @Override
        public void lock() {
        }

        @Override
        public void unlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(ByteBuffer buffer, TransportSendControl control) {
            int request = this.getPendingRequest();
            if (QoS.INIT.isSet(request)) {
                control.startMessage((byte)13, 5);
                buffer.putInt(this.ioid);
                buffer.put((byte)request);
                MonitorRequesterImpl monitorRequesterImpl = this;
                synchronized (monitorRequesterImpl) {
                    this.status.serialize(buffer, (SerializableControl)control);
                }
                if (this.status.isSuccess()) {
                    control.cachedSerialize((Field)this.structure, buffer);
                }
                this.stopRequest();
                this.startRequest(QoS.DEFAULT.getMaskValue());
            } else {
                Monitor monitor = this.monitor;
                MonitorElement element = monitor.poll();
                if (element != null) {
                    control.startMessage((byte)13, 5);
                    buffer.putInt(this.ioid);
                    buffer.put((byte)request);
                    BitSet changedBitSet = element.getChangedBitSet();
                    if (changedBitSet != null) {
                        changedBitSet.serialize(buffer, (SerializableControl)control);
                        element.getPVStructure().serialize(buffer, (SerializableControl)control, changedBitSet);
                        element.getOverrunBitSet().serialize(buffer, (SerializableControl)control);
                    }
                    monitor.release(element);
                } else if (this.unlisten) {
                    control.startMessage((byte)13, 5);
                    buffer.putInt(this.ioid);
                    buffer.put((byte)QoS.DESTROY.getMaskValue());
                    StatusFactory.getStatusCreate().getStatusOK().serialize(buffer, (SerializableControl)control);
                }
            }
        }
    }
}

