/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.impl.remote.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.epics.pvaccess.impl.remote.Context;
import org.epics.pvaccess.impl.remote.TransportClient;
import org.epics.pvaccess.impl.remote.TransportSendControl;
import org.epics.pvaccess.impl.remote.TransportSender;
import org.epics.pvaccess.impl.remote.request.ResponseHandler;
import org.epics.pvaccess.impl.remote.server.ChannelHostingTransport;
import org.epics.pvaccess.impl.remote.server.ServerChannel;
import org.epics.pvaccess.impl.remote.tcp.BlockingTCPTransport;
import org.epics.pvaccess.impl.security.NoSecurityPlugin;
import org.epics.pvaccess.impl.security.SecurityPluginMessageTransportSender;
import org.epics.pvaccess.plugins.SecurityPlugin;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;

public class BlockingServerTCPTransport
extends BlockingTCPTransport
implements ChannelHostingTransport,
TransportSender,
SecurityPlugin.SecurityPluginControl {
    private AtomicInteger lastChannelSID = new AtomicInteger(0);
    private Map<Integer, ServerChannel> channels;
    private boolean verifyOrVerified = false;
    private static Status validationTimeoutStatus = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "server-side validation timeout", null);
    private volatile Status verificationStatus = validationTimeoutStatus;
    private static Status invalidSecurityPluginNameStatus = StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "invalid security plug-in name", null);
    private volatile SecurityPlugin.SecuritySession securitySession = null;
    private volatile boolean securityRequired = true;

    public BlockingServerTCPTransport(Context context, SocketChannel channel, ResponseHandler responseHandler, int receiveBufferSize) throws SocketException {
        super(context, channel, responseHandler, receiveBufferSize, (short)0);
        int INITIAL_SIZE = 64;
        this.channels = Collections.synchronizedMap(new HashMap(64));
        this.start();
    }

    @Override
    protected void internalClose() {
        super.internalClose();
        this.destroyAllChannels();
    }

    private void destroyAllChannels() {
        this.context.getLogger().fine("Transport to " + this.socketAddress + " still has " + this.channels.size() + " channel(s) active and closing...");
        for (ServerChannel serverChannel : this.channels.values()) {
            serverChannel.destroy();
        }
        this.channels.clear();
    }

    @Override
    public int preallocateChannelSID() {
        int sid = this.lastChannelSID.incrementAndGet();
        while (this.channels.containsKey(sid)) {
            sid = this.lastChannelSID.incrementAndGet();
        }
        return sid;
    }

    @Override
    public void depreallocateChannelSID(int sid) {
    }

    @Override
    public void registerChannel(int sid, ServerChannel channel) {
        this.channels.put(sid, channel);
    }

    @Override
    public void unregisterChannel(int sid) {
        this.channels.remove(sid);
    }

    @Override
    public ServerChannel getChannel(int sid) {
        return this.channels.get(sid);
    }

    @Override
    public ServerChannel[] getChannels() {
        ServerChannel[] sca = new ServerChannel[this.channels.size()];
        this.channels.values().toArray(sca);
        return sca;
    }

    @Override
    public int getChannelCount() {
        return this.channels.size();
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    public void send(ByteBuffer buffer, TransportSendControl control) {
        if (!this.verifyOrVerified) {
            this.verifyOrVerified = true;
            this.ensureBuffer(8);
            this.sendBuffer.put((byte)-54);
            this.sendBuffer.put((byte)1);
            this.sendBuffer.put((byte)-63);
            this.sendBuffer.put((byte)2);
            this.sendBuffer.putInt(0);
            control.startMessage((byte)1, 6);
            buffer.putInt(this.getReceiveBufferSize());
            buffer.putShort((short)Short.MAX_VALUE);
            Map<String, SecurityPlugin> securityPlugins = this.context.getSecurityPlugins();
            ArrayList<String> validSPNames = new ArrayList<String>(securityPlugins.size());
            InetSocketAddress remoteAddress = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
            for (SecurityPlugin securityPlugin : securityPlugins.values()) {
                try {
                    if (!securityPlugin.isValidFor(remoteAddress)) continue;
                    validSPNames.add(securityPlugin.getId());
                }
                catch (Throwable th) {
                    this.context.getLogger().log(Level.SEVERE, "Unexpected exception caught while calling SecurityPluin.isValidFor(InetAddress)/getId() methods.", th);
                }
            }
            int validSPCount = validSPNames.size();
            SerializeHelper.writeSize((int)validSPCount, (ByteBuffer)buffer, (SerializableControl)this);
            for (String spName : validSPNames) {
                SerializeHelper.serializeString((String)spName, (ByteBuffer)buffer, (SerializableControl)this);
            }
            this.securityRequired = validSPCount > 0;
            control.flush(true);
        } else {
            control.startMessage((byte)9, 0);
            this.verificationStatus.serialize(buffer, (SerializableControl)control);
            control.flush(true);
        }
    }

    @Override
    public boolean acquire(TransportClient client) {
        return false;
    }

    @Override
    public void release(TransportClient client) {
    }

    @Override
    public void verified(Status status) {
        this.verificationStatus = status;
        super.verified(status);
    }

    @Override
    public boolean verify(long timeoutMs) {
        this.enqueueSendRequest(this);
        boolean verified = super.verify(timeoutMs);
        this.enqueueSendRequest(this);
        return verified;
    }

    @Override
    public void authNZInitialize(Object data) {
        Object[] dataArray = (Object[])data;
        String securityPluginName = (String)dataArray[0];
        PVField initializationData = (PVField)dataArray[1];
        InetSocketAddress remoteAddress = (InetSocketAddress)this.channel.socket().getRemoteSocketAddress();
        SecurityPlugin securityPlugin = this.context.getSecurityPlugins().get(securityPluginName);
        if (securityPlugin == null) {
            if (this.securityRequired) {
                this.verified(invalidSecurityPluginNameStatus);
                return;
            }
            securityPlugin = NoSecurityPlugin.INSTANCE;
            this.context.getLogger().finer("No security plug-in installed, selecting default plug-in '" + securityPlugin.getId() + "' for PVA client: " + remoteAddress);
        }
        try {
            if (!securityPlugin.isValidFor(remoteAddress)) {
                this.verified(invalidSecurityPluginNameStatus);
            }
        }
        catch (Throwable th) {
            this.context.getLogger().log(Level.SEVERE, "Unexpected exception caught while calling SecurityPluin.isValidFor(InetAddress) methods.", th);
            this.verified(StatusFactory.getStatusCreate().createStatus(Status.StatusType.ERROR, "disfunctional security plug-in", th));
            return;
        }
        this.context.getLogger().finer("Accepted security plug-in '" + securityPluginName + "' for PVA client: " + remoteAddress);
        this.securitySession = securityPlugin.createSession(remoteAddress, this, initializationData);
    }

    @Override
    public void authNZMessage(PVField data) {
        SecurityPlugin.SecuritySession ss = this.securitySession;
        if (ss != null) {
            ss.messageReceived(data);
        } else {
            this.context.getLogger().warning("authNZ message received but no security plug-in session active");
        }
    }

    @Override
    public void sendSecurityPluginMessage(PVField data) {
        this.enqueueSendRequest(new SecurityPluginMessageTransportSender(data));
    }

    @Override
    public void authenticationCompleted(Status status) {
        try {
            this.context.getLogger().finer("Authentication completed with status '" + status.getType() + "' for PVA client: " + this.channel.getRemoteAddress());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.verified) {
            this.verified(status);
        } else if (!status.isSuccess()) {
            String msg = "Re-authentication failed: " + status.getMessage();
            String stackDump = status.getStackDump();
            if (stackDump != null && !stackDump.isEmpty()) {
                msg = msg + "\n" + stackDump;
            }
            this.context.getLogger().info(msg);
            try {
                this.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void aliveNotification() {
    }

    @Override
    public void close() throws IOException {
        if (this.securitySession != null) {
            try {
                this.securitySession.close();
            }
            catch (Throwable th) {
                this.context.getLogger().log(Level.WARNING, "Unexpection exception caight while closing secutiry session.", th);
            }
            this.securitySession = null;
        }
        super.close();
    }

    @Override
    public SecurityPlugin.SecuritySession getSecuritySession() {
        return this.securitySession;
    }
}

