/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.server.rpc.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.epics.pvaccess.client.Channel;
import org.epics.pvaccess.client.ChannelFind;
import org.epics.pvaccess.client.ChannelFindRequester;
import org.epics.pvaccess.client.ChannelListRequester;
import org.epics.pvaccess.client.ChannelProvider;
import org.epics.pvaccess.client.ChannelRequester;
import org.epics.pvaccess.server.rpc.Service;
import org.epics.pvaccess.server.rpc.impl.RPCChannel;
import org.epics.pvaccess.util.WildcharMatcher;
import org.epics.pvdata.factory.StatusFactory;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public class RPCChannelProvider
implements ChannelProvider {
    public static final String PROVIDER_NAME = "rpcService";
    private static final StatusCreate statusCreate = StatusFactory.getStatusCreate();
    private static final Status okStatus = statusCreate.getStatusOK();
    private static final Status noSuchChannelStatus = statusCreate.createStatus(Status.StatusType.ERROR, "no such channel", null);
    private final HashMap<String, Service> services = new HashMap();
    private final LinkedHashMap<String, Service> wildServices = new LinkedHashMap();
    private final ThreadPoolExecutor threadPool;
    private ChannelFind channelFind = new ChannelFind(){

        @Override
        public ChannelProvider getChannelProvider() {
            return RPCChannelProvider.this;
        }

        @Override
        public void cancel() {
        }
    };

    public RPCChannelProvider(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public String getProviderName() {
        return PROVIDER_NAME;
    }

    private Service findWildService(String wildcard) {
        if (!this.wildServices.isEmpty()) {
            for (Map.Entry<String, Service> entry : this.wildServices.entrySet()) {
                if (!WildcharMatcher.match(entry.getKey(), wildcard)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean isWildcardPattern(String pattern) {
        return pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1 || pattern.indexOf(91) != -1 && pattern.indexOf(93) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFind channelFind(String channelName, ChannelFindRequester channelFindRequester) {
        boolean found;
        HashMap<String, Service> hashMap = this.services;
        synchronized (hashMap) {
            found = this.services.containsKey(channelName) || this.findWildService(channelName) != null;
        }
        channelFindRequester.channelFindResult(okStatus, this.channelFind, found);
        return this.channelFind;
    }

    @Override
    public ChannelFind channelList(ChannelListRequester channelListRequester) {
        channelListRequester.channelListResult(okStatus, this.channelFind, this.services.keySet(), false);
        return this.channelFind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String channelName, ChannelRequester channelRequester, short priority) {
        Service service;
        HashMap<String, Service> hashMap = this.services;
        synchronized (hashMap) {
            service = this.services.get(channelName);
            if (service == null) {
                service = this.findWildService(channelName);
            }
        }
        if (service == null) {
            channelRequester.channelCreated(noSuchChannelStatus, null);
            return null;
        }
        RPCChannel rpcChannel = new RPCChannel(this, channelName, channelRequester, service, this.threadPool);
        channelRequester.channelCreated(okStatus, rpcChannel);
        return rpcChannel;
    }

    @Override
    public Channel createChannel(String channelName, ChannelRequester channelRequester, short priority, String address) {
        throw new RuntimeException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(String serviceName, Service service) {
        HashMap<String, Service> hashMap = this.services;
        synchronized (hashMap) {
            this.services.put(serviceName, service);
            if (this.isWildcardPattern(serviceName)) {
                this.wildServices.put(serviceName, service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(String serviceName) {
        HashMap<String, Service> hashMap = this.services;
        synchronized (hashMap) {
            this.services.remove(serviceName);
            this.wildServices.remove(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        HashMap<String, Service> hashMap = this.services;
        synchronized (hashMap) {
            this.services.clear();
            this.wildServices.clear();
        }
    }
}

