/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvaccess.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Mailbox<E> {
    private final ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue();
    private final AtomicInteger elements = new AtomicInteger(0);
    private final AtomicBoolean wakeup = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(E msg) {
        this.queue.add(msg);
        if (this.elements.incrementAndGet() == 1) {
            AtomicInteger atomicInteger = this.elements;
            synchronized (atomicInteger) {
                this.elements.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take(long timeout) throws InterruptedException {
        E val;
        while ((val = this.queue.poll()) == null) {
            AtomicInteger atomicInteger = this.elements;
            synchronized (atomicInteger) {
                boolean isEmpty = this.queue.isEmpty();
                if (isEmpty && timeout < 0L) {
                    return null;
                }
                while (isEmpty) {
                    this.elements.wait(timeout);
                    isEmpty = this.queue.isEmpty();
                    if (!isEmpty) continue;
                    if (timeout > 0L) {
                        return null;
                    }
                    if (!this.wakeup.getAndSet(false)) continue;
                    return null;
                }
            }
        }
        this.elements.decrementAndGet();
        return val;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void clear() {
        this.queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        if (!this.wakeup.getAndSet(true)) {
            AtomicInteger atomicInteger = this.elements;
            synchronized (atomicInteger) {
                this.elements.notifyAll();
            }
        }
    }
}

