/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.accessSecurity;

import org.epics.pvdata.accessSecurity.AccessSecurityLevel;

public class AccessSecurityLevelFactory {
    private static final AccessSecurityLevel accessSecurityLevel = new AccessSecurityLevelImpl();
    private static final String[] names = new String[]{"internal", "configuration", "calibration", "runtime"};

    public static AccessSecurityLevel get() {
        return accessSecurityLevel;
    }

    private static class AccessSecurityLevelImpl
    implements AccessSecurityLevel {
        private AccessSecurityLevelImpl() {
        }

        @Override
        public int getLevel(String name) throws NoSuchFieldException {
            for (int index = 0; index < names.length; ++index) {
                if (!name.equals(names[index])) continue;
                return index;
            }
            throw new NoSuchFieldException(name);
        }

        @Override
        public String getName(int level) throws IndexOutOfBoundsException {
            if (level < 0 || level >= names.length) {
                throw new IndexOutOfBoundsException();
            }
            return names[level];
        }

        @Override
        public String[] getNames() {
            return names;
        }
    }
}

