/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PostHandler;
import org.epics.pvdata.pv.Type;

public abstract class AbstractPVField
implements PVField {
    private int fieldOffset = 0;
    private int nextFieldOffset = 0;
    private boolean isImmutable = false;
    private String fieldName = null;
    private Field field;
    private PVStructure pvParent = null;
    private PostHandler postHandler = null;
    protected static final Convert convert = ConvertFactory.getConvert();

    protected AbstractPVField(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("field is null");
        }
        this.field = field;
    }

    protected void setData(Field field, PVStructure parent, String fieldName) {
        this.field = field;
        this.pvParent = parent;
        this.fieldName = fieldName;
    }

    protected void changeField(Field field) {
        this.field = field;
    }

    @Override
    public String getFieldName() {
        if (this.fieldName != null) {
            return this.fieldName;
        }
        if (this.pvParent == null) {
            this.fieldName = "";
            return this.fieldName;
        }
        throw new IllegalStateException("logic error");
    }

    @Override
    public String getFullName() {
        String ret = this.fieldName;
        for (PVStructure fld = this.getParent(); fld != null && fld.getFieldName().length() != 0; fld = fld.getParent()) {
            ret = fld.getFieldName() + '.' + ret;
        }
        return ret;
    }

    @Override
    public void postPut() {
        if (this.postHandler != null) {
            this.postHandler.postPut();
        }
    }

    @Override
    public void setPostHandler(PostHandler postHandler) {
        if (this.postHandler != null) {
            if (postHandler == this.postHandler) {
                return;
            }
            throw new IllegalStateException("A postHandler is already registered");
        }
        this.postHandler = postHandler;
    }

    @Override
    public int getFieldOffset() {
        if (this.nextFieldOffset == 0) {
            this.computeOffset();
        }
        return this.fieldOffset;
    }

    @Override
    public int getNextFieldOffset() {
        if (this.nextFieldOffset == 0) {
            this.computeOffset();
        }
        return this.nextFieldOffset;
    }

    @Override
    public int getNumberFields() {
        if (this.nextFieldOffset == 0) {
            this.computeOffset();
        }
        return this.nextFieldOffset - this.fieldOffset;
    }

    @Override
    public boolean isImmutable() {
        return this.isImmutable;
    }

    @Override
    public void setImmutable() {
        this.isImmutable = true;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public PVStructure getParent() {
        return this.pvParent;
    }

    @Override
    public void toString(StringBuilder buf) {
        this.toString(buf, 0);
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        convert.getString(buf, this, indentLevel);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    private void computeOffset() {
        PVStructure pvTop = this.pvParent;
        if (pvTop == null) {
            if (this.getField().getType() != Type.structure) {
                this.fieldOffset = 0;
                this.nextFieldOffset = 1;
                return;
            }
            pvTop = (PVStructure)((Object)this);
        } else {
            while (pvTop.getParent() != null) {
                pvTop = pvTop.getParent();
            }
        }
        int offset = 0;
        int nextOffset = 1;
        PVField[] pvFields = pvTop.getPVFields();
        block5: for (int i = 0; i < pvFields.length; ++i) {
            offset = nextOffset++;
            AbstractPVField pvField = (AbstractPVField)pvFields[i];
            Field field = pvField.getField();
            switch (field.getType()) {
                case scalar: 
                case scalarArray: 
                case structureArray: 
                case union: 
                case unionArray: {
                    AbstractPVField pv = pvField;
                    pv.fieldOffset = offset;
                    pv.nextFieldOffset = nextOffset;
                    continue block5;
                }
                case structure: {
                    AbstractPVField pv = pvField;
                    pv.computeOffset(offset);
                    nextOffset = pv.getNextFieldOffset();
                }
            }
        }
        AbstractPVField top = (AbstractPVField)((Object)pvTop);
        top.fieldOffset = 0;
        top.nextFieldOffset = nextOffset;
    }

    private void computeOffset(int offset) {
        int beginOffset = offset;
        int nextOffset = offset + 1;
        PVStructure pvStructure = (PVStructure)((Object)this);
        PVField[] pvFields = pvStructure.getPVFields();
        block4: for (int i = 0; i < pvFields.length; ++i) {
            offset = nextOffset++;
            AbstractPVField pvField = (AbstractPVField)pvFields[i];
            Field field = pvField.getField();
            switch (field.getType()) {
                case scalar: 
                case scalarArray: 
                case structureArray: 
                case union: 
                case unionArray: {
                    AbstractPVField pv = pvField;
                    pv.fieldOffset = offset;
                    pv.nextFieldOffset = nextOffset;
                    continue block4;
                }
                case structure: {
                    AbstractPVField pv = pvField;
                    pv.computeOffset(offset);
                    nextOffset = pv.getNextFieldOffset();
                }
            }
        }
        this.fieldOffset = beginOffset;
        this.nextFieldOffset = nextOffset;
    }
}

