/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVScalar;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.SerializableControl;

public class BasePVDouble
extends AbstractPVScalar
implements PVDouble {
    protected double value = 0.0;

    public BasePVDouble(Scalar scalar) {
        super(scalar);
    }

    @Override
    public double get() {
        return this.value;
    }

    @Override
    public void put(double value) {
        if (super.isImmutable()) {
            throw new IllegalArgumentException("field is immutable");
        }
        this.value = value;
        super.postPut();
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher) {
        flusher.ensureBuffer(8);
        buffer.putDouble(this.value);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        control.ensureData(8);
        this.value = buffer.getDouble();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PVDouble) {
            PVDouble b = (PVDouble)obj;
            return b.get() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.value;
    }
}

