/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVShortArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.ShortArrayData;
import org.epics.util.array.ArrayShort;
import org.epics.util.array.CollectionNumbers;

public class BasePVShortArray
extends AbstractPVScalarArray
implements PVShortArray {
    protected short[] value;

    public BasePVShortArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new short[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (short[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        buffer.asShortBuffer().put(this.value, offset, length);
        buffer.position(buffer.position() + length * 2);
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        buffer.asShortBuffer().get(this.value, offset, length);
        buffer.position(buffer.position() + length * 2);
        return length;
    }

    @Override
    public int get(int offset, int len, ShortArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public ArrayShort get() {
        return CollectionNumbers.unmodifiableListShort((short[])this.value);
    }

    @Override
    public int put(int offset, int len, short[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(short[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVShortArray b = (PVShortArray)obj;
        ShortArrayData arrayData = new ShortArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((short[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

