/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVScalarArray;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.StringArrayData;

public class BasePVStringArray
extends AbstractPVScalarArray
implements PVStringArray {
    protected String[] value;

    public BasePVStringArray(ScalarArray array) {
        super(array);
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new String[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (String[])array;
    }

    @Override
    protected int putToBuffer(ByteBuffer buffer, SerializableControl control, int offset, int length) {
        int end = length + offset;
        for (int i = offset; i < end; ++i) {
            SerializeHelper.serializeString(this.value[i], buffer, control);
        }
        return length;
    }

    @Override
    protected int getFromBuffer(ByteBuffer buffer, DeserializableControl control, int offset, int length) {
        int end = length + offset;
        for (int i = offset; i < end; ++i) {
            this.value[i] = SerializeHelper.deserializeString(buffer, control);
        }
        return length;
    }

    @Override
    public int get(int offset, int len, StringArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public int put(int offset, int len, String[] from, int fromOffset) {
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(String[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVStringArray b = (PVStringArray)obj;
        StringArrayData arrayData = new StringArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((Object[])arrayData.data, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

