/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVField;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.misc.BitSet;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVBoolean;
import org.epics.pvdata.pv.PVByte;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVFloat;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVShort;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PVStructureArray;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.PVUnionArray;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.Type;

public class BasePVStructure
extends AbstractPVField
implements PVStructure {
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private PVField[] pvFields;

    private void setParentAndName() {
        String[] fieldNames = this.getStructure().getFieldNames();
        Field[] fields = this.getStructure().getFields();
        int length = this.pvFields.length;
        if (fieldNames.length != length) {
            throw new IllegalStateException("PVStructure Logic error");
        }
        for (int i = 0; i < length; ++i) {
            AbstractPVField xxx = (AbstractPVField)this.pvFields[i];
            xxx.setData(fields[i], this, fieldNames[i]);
            if (xxx.getField().getType() != Type.structure) continue;
            BasePVStructure yyy = (BasePVStructure)xxx;
            yyy.setParentAndName();
        }
    }

    public BasePVStructure(Structure structure) {
        super(structure);
        Field[] fields = structure.getFields();
        this.pvFields = new PVField[fields.length];
        for (int i = 0; i < this.pvFields.length; ++i) {
            this.pvFields[i] = pvDataCreate.createPVField(fields[i]);
        }
        this.setParentAndName();
    }

    public BasePVStructure(Structure structure, PVField[] pvFields) {
        super(structure);
        this.pvFields = pvFields;
        this.setParentAndName();
    }

    @Override
    public void setImmutable() {
        super.setImmutable();
        for (int i = 0; i < this.pvFields.length; ++i) {
            this.pvFields[i].setImmutable();
        }
        super.setImmutable();
    }

    @Override
    public PVField getSubField(String fieldName) {
        return this.findSubField(fieldName, this);
    }

    @Override
    public PVField getSubField(int fieldOffset) {
        if (fieldOffset <= this.getFieldOffset()) {
            return null;
        }
        if (fieldOffset > this.getNextFieldOffset()) {
            return null;
        }
        for (PVField pvField : this.pvFields) {
            if (pvField.getFieldOffset() == fieldOffset) {
                return pvField;
            }
            if (pvField.getNextFieldOffset() <= fieldOffset || pvField.getField().getType() != Type.structure) continue;
            return ((PVStructure)pvField).getSubField(fieldOffset);
        }
        throw new IllegalStateException("PVStructure.getSubField: Logic error");
    }

    @Override
    public Structure getStructure() {
        return (Structure)this.getField();
    }

    @Override
    public PVField[] getPVFields() {
        return this.pvFields;
    }

    @Override
    public PVBoolean getBooleanField(String fieldName) {
        return this.getSubField(PVBoolean.class, fieldName);
    }

    @Override
    public PVByte getByteField(String fieldName) {
        return this.getSubField(PVByte.class, fieldName);
    }

    @Override
    public PVShort getShortField(String fieldName) {
        return this.getSubField(PVShort.class, fieldName);
    }

    @Override
    public PVInt getIntField(String fieldName) {
        return this.getSubField(PVInt.class, fieldName);
    }

    @Override
    public <T extends PVField> T getSubField(Class<T> c, String fieldName) {
        PVField pv = this.findSubField(fieldName, this);
        if (c.isInstance(pv)) {
            return (T)((PVField)c.cast(pv));
        }
        return null;
    }

    @Override
    public <T extends PVField> T getSubField(Class<T> c, int fieldOffset) {
        PVField pv = this.getSubField(fieldOffset);
        if (c.isInstance(pv)) {
            return (T)((PVField)c.cast(pv));
        }
        return null;
    }

    @Override
    public PVLong getLongField(String fieldName) {
        return this.getSubField(PVLong.class, fieldName);
    }

    @Override
    public PVFloat getFloatField(String fieldName) {
        return this.getSubField(PVFloat.class, fieldName);
    }

    @Override
    public PVDouble getDoubleField(String fieldName) {
        return this.getSubField(PVDouble.class, fieldName);
    }

    @Override
    public PVString getStringField(String fieldName) {
        return this.getSubField(PVString.class, fieldName);
    }

    @Override
    public PVStructure getStructureField(String fieldName) {
        return this.getSubField(PVStructure.class, fieldName);
    }

    @Override
    public PVUnion getUnionField(String fieldName) {
        return this.getSubField(PVUnion.class, fieldName);
    }

    @Override
    public PVScalarArray getScalarArrayField(String fieldName, ScalarType elementType) {
        PVField pvField = this.findSubField(fieldName, this);
        if (pvField == null) {
            return null;
        }
        Field field = pvField.getField();
        Type type = field.getType();
        if (type != Type.scalarArray) {
            return null;
        }
        ScalarArray array = (ScalarArray)field;
        if (array.getElementType() != elementType) {
            return null;
        }
        return (PVScalarArray)pvField;
    }

    @Override
    public PVStructureArray getStructureArrayField(String fieldName) {
        return this.getSubField(PVStructureArray.class, fieldName);
    }

    @Override
    public PVUnionArray getUnionArrayField(String fieldName) {
        return this.getSubField(PVUnionArray.class, fieldName);
    }

    private static boolean checkValid(PVStructure pvStructure, String fullName) {
        boolean result = true;
        PVField[] pvFields = pvStructure.getPVFields();
        Structure structure = pvStructure.getStructure();
        Field[] fields = structure.getFields();
        int length = pvFields.length;
        String[] fieldNames = structure.getFieldNames();
        if (length != fieldNames.length) {
            result = false;
            System.err.printf("checkValid pvFields.length %d fieldNames.length %d%n", length, fieldNames.length);
            if (length > fieldNames.length) {
                length = fieldNames.length;
            }
        }
        if (length != fields.length) {
            result = false;
            System.err.printf("checkValid pvFields.length %d fields.length %d%n", length, fields.length);
            if (length > fields.length) {
                length = fields.length;
            }
        }
        String name = fullName;
        if (fullName.length() > 0) {
            name = name + ".";
        }
        for (int i = 0; i < length; ++i) {
            PVField pvField = pvFields[i];
            String nnn = name + fieldNames[i];
            if (pvField.getParent() != pvStructure) {
                result = false;
                System.err.printf("%s pvParent %s bad%n", nnn, pvField.getParent());
            }
            if (pvField.getField() != fields[i]) {
                result = false;
                System.err.printf("%s pvField.getField()!=fields[%d]%n", nnn, i);
                System.err.printf("pvField.getField()%n%s%n", pvField.getField());
                System.err.printf("fields[i]%n%s%n", fields[i]);
            }
            if (pvField.getFieldName() != fieldNames[i]) {
                result = false;
                System.err.printf("%s pvField.getFieldName()!=fieldNames[%d]%n", nnn, i);
                System.err.printf("pvField.getFieldName() %s%n", pvField.getFieldName());
                System.err.printf("fieldNames[i] %s%n", fieldNames[i]);
            }
            if (pvField.getField().getType() != Type.structure) continue;
            boolean yyy = BasePVStructure.checkValid((PVStructure)pvField, nnn);
            if (!result) continue;
            result = yyy;
        }
        return result;
    }

    @Override
    public boolean checkValid() {
        PVStructure xxx = this;
        while (xxx.getParent() != null) {
            xxx = xxx.getParent();
        }
        return BasePVStructure.checkValid(xxx, "");
    }

    private PVField findSubField(String fieldName, PVStructure pvStructure) {
        if (fieldName == null || fieldName.length() < 1) {
            return null;
        }
        int index = fieldName.indexOf(46);
        String name = fieldName;
        String restOfName = null;
        if (index > 0) {
            name = fieldName.substring(0, index);
            if (fieldName.length() > index) {
                restOfName = fieldName.substring(index + 1);
            }
        }
        PVField[] pvFields = pvStructure.getPVFields();
        String[] fieldNames = pvStructure.getStructure().getFieldNames();
        PVField pvField = null;
        for (int i = 0; i < pvFields.length; ++i) {
            if (!fieldNames[i].equals(name)) continue;
            pvField = pvFields[i];
            break;
        }
        if (pvField == null) {
            return null;
        }
        if (restOfName == null) {
            return pvField;
        }
        if (pvField.getField().getType() != Type.structure) {
            return null;
        }
        return this.findSubField(restOfName, (PVStructure)pvField);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher) {
        for (int i = 0; i < this.pvFields.length; ++i) {
            this.pvFields[i].serialize(buffer, flusher);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        for (int i = 0; i < this.pvFields.length; ++i) {
            this.pvFields[i].deserialize(buffer, control);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control, BitSet bitSet) {
        int offset = this.getFieldOffset();
        int numberFields = this.getNumberFields();
        int next = bitSet.nextSetBit(offset);
        if (next < 0 || next >= offset + numberFields) {
            return;
        }
        if (offset == next) {
            this.deserialize(buffer, control);
            return;
        }
        for (int i = 0; i < this.pvFields.length; ++i) {
            PVField pvField = this.pvFields[i];
            offset = pvField.getFieldOffset();
            numberFields = pvField.getNumberFields();
            next = bitSet.nextSetBit(offset);
            if (next < 0) {
                return;
            }
            if (next >= offset + numberFields) continue;
            if (numberFields == 1) {
                pvField.deserialize(buffer, control);
                continue;
            }
            ((PVStructure)pvField).deserialize(buffer, control, bitSet);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher, BitSet bitSet) {
        int offset = this.getFieldOffset();
        int numberFields = this.getNumberFields();
        int next = bitSet.nextSetBit(offset);
        if (next < 0 || next >= offset + numberFields) {
            return;
        }
        if (offset == next) {
            this.serialize(buffer, flusher);
            return;
        }
        for (int i = 0; i < this.pvFields.length; ++i) {
            PVField pvField = this.pvFields[i];
            offset = pvField.getFieldOffset();
            numberFields = pvField.getNumberFields();
            next = bitSet.nextSetBit(offset);
            if (next < 0) {
                return;
            }
            if (next >= offset + numberFields) continue;
            if (numberFields == 1) {
                pvField.serialize(buffer, flusher);
                continue;
            }
            ((PVStructure)pvField).serialize(buffer, flusher, bitSet);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PVStructure) {
            PVStructure b = (PVStructure)obj;
            if (!this.getStructure().equals(b.getStructure())) {
                return false;
            }
            PVField[] bfields = b.getPVFields();
            if (bfields.length == this.pvFields.length) {
                for (int i = 0; i < this.pvFields.length; ++i) {
                    if (this.pvFields[i].equals(bfields[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        result = 31 * result + Arrays.hashCode(this.pvFields);
        return result;
    }
}

