/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.util.Arrays;
import org.epics.pvdata.factory.AbstractPVComplexArray;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PVStructureArray;
import org.epics.pvdata.pv.Serializable;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArray;
import org.epics.pvdata.pv.StructureArrayData;

public class BasePVStructureArray
extends AbstractPVComplexArray
implements PVStructureArray {
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    protected PVStructure[] value;
    protected StructureArray structureArray;

    public BasePVStructureArray(StructureArray structureArray) {
        super(structureArray);
        this.structureArray = structureArray;
    }

    @Override
    public StructureArray getStructureArray() {
        return this.structureArray;
    }

    @Override
    protected void allocate(int newCapacity) {
        this.value = new PVStructure[newCapacity];
        this.capacity = newCapacity;
    }

    @Override
    protected Object getValue() {
        return this.value;
    }

    @Override
    protected void setValue(Object array) {
        this.value = (PVStructure[])array;
    }

    @Override
    public int get(int offset, int len, StructureArrayData data) {
        return this.internalGet(offset, len, data);
    }

    @Override
    public int put(int offset, int len, PVStructure[] from, int fromOffset) {
        Structure elementField = this.structureArray.getStructure();
        for (int i = 0; i < len; ++i) {
            PVStructure pvs = from[i];
            if (pvs == null || pvs.getStructure().equals(elementField)) continue;
            throw new IllegalStateException("element is not a compatible structure");
        }
        return this.internalPut(offset, len, from, fromOffset);
    }

    @Override
    public void shareData(PVStructure[] from) {
        this.internalShareData(from);
    }

    @Override
    protected boolean valueEquals(Object obj) {
        PVStructureArray b = (PVStructureArray)obj;
        StructureArrayData arrayData = new StructureArrayData();
        b.get(0, b.getLength(), arrayData);
        return Arrays.equals((Object[])arrayData.data, this.value);
    }

    @Override
    protected Serializable getAt(int index) {
        return this.value[index];
    }

    @Override
    protected void setAt(int index, Serializable obj) {
        this.value[index] = (PVStructure)obj;
    }

    @Override
    protected Serializable createNewInstance() {
        return pvDataCreate.createPVStructure(this.structureArray.getStructure());
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

