/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.AbstractPVField;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Union;

public class BasePVUnion
extends AbstractPVField
implements PVUnion {
    private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private final Union union;
    private int selector = -1;
    private PVField value = null;
    private final boolean variant;

    public BasePVUnion(Union union) {
        super(union);
        this.union = union;
        this.variant = union.isVariant();
    }

    @Override
    public Union getUnion() {
        return this.union;
    }

    @Override
    public PVField get() {
        return this.value;
    }

    @Override
    public <T extends PVField> T get(Class<T> c) {
        if (c.isInstance(this.value)) {
            return (T)((PVField)c.cast(this.value));
        }
        return null;
    }

    @Override
    public int getSelectedIndex() {
        return this.selector;
    }

    @Override
    public String getSelectedFieldName() {
        if (this.selector == -1) {
            return null;
        }
        return this.union.getFieldName(this.selector);
    }

    @Override
    public PVField select(int index) {
        if (this.selector == index) {
            return this.value;
        }
        if (index == -1) {
            this.selector = -1;
            this.value = null;
            return null;
        }
        if (this.variant) {
            throw new IllegalArgumentException("index out of bounds");
        }
        if (index < 0 || index > this.union.getFields().length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Field field = this.union.getField(index);
        this.selector = index;
        this.value = pvDataCreate.createPVField(field);
        return this.value;
    }

    @Override
    public PVField select(String fieldName) {
        int index;
        int n = index = this.variant ? -1 : this.union.getFieldIndex(fieldName);
        if (index == -1) {
            throw new IllegalArgumentException("no such fieldName");
        }
        return this.select(index);
    }

    @Override
    public <T extends PVField> T select(Class<T> c, int index) {
        PVField pv = this.select(index);
        if (c.isInstance(pv)) {
            return (T)((PVField)c.cast(pv));
        }
        return null;
    }

    @Override
    public <T extends PVField> T select(Class<T> c, String fieldName) {
        PVField pv = this.select(fieldName);
        if (c.isInstance(pv)) {
            return (T)((PVField)c.cast(pv));
        }
        return null;
    }

    @Override
    public void set(PVField value) {
        this.set(this.selector, value);
    }

    @Override
    public void set(int index, PVField value) {
        if (this.variant && index != -1) {
            throw new IllegalArgumentException("index out of bounds");
        }
        if (!this.variant) {
            if (index == -1) {
                if (value != null) {
                    throw new IllegalArgumentException("non-null value for index == UNDEFINED_INDEX");
                }
            } else if (index < 0 || index > this.union.getFields().length) {
                throw new IllegalArgumentException("index out of bounds");
            }
            if (!value.getField().equals(this.union.getField(index))) {
                throw new IllegalArgumentException("selected field and its introspection data do not match");
            }
        }
        this.selector = index;
        this.value = value;
        super.postPut();
    }

    @Override
    public void set(String fieldName, PVField value) {
        int index;
        int n = index = this.variant ? -1 : this.union.getFieldIndex(fieldName);
        if (index == -1) {
            throw new IllegalArgumentException("no such fieldName");
        }
        this.set(index, value);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl flusher) {
        if (this.variant) {
            if (this.value == null) {
                flusher.ensureBuffer(1);
                buffer.put((byte)-1);
            } else {
                flusher.cachedSerialize(this.value.getField(), buffer);
                this.value.serialize(buffer, flusher);
            }
        } else {
            SerializeHelper.writeSize(this.selector, buffer, flusher);
            if (this.selector != -1) {
                this.value.serialize(buffer, flusher);
            }
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        if (this.variant) {
            Field field = control.cachedDeserialize(buffer);
            if (field != null) {
                if (this.value == null || !field.equals(this.value.getField())) {
                    this.value = pvDataCreate.createPVField(field);
                }
                this.value.deserialize(buffer, control);
            } else {
                this.value = null;
            }
        } else {
            int previousSelector = this.selector;
            this.selector = SerializeHelper.readSize(buffer, control);
            if (this.selector != -1) {
                if (this.selector != previousSelector) {
                    Field field = this.union.getField(this.selector);
                    if (this.value == null || !field.equals(this.value.getField())) {
                        this.value = pvDataCreate.createPVField(field);
                    }
                }
                this.value.deserialize(buffer, control);
            } else {
                this.value = null;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PVUnion) {
            PVUnion b = (PVUnion)obj;
            if (this.union.equals(b.getUnion())) {
                if (this.union.isVariant()) {
                    if (this.value == null) {
                        return b.get() == null;
                    }
                    return this.value.equals(b.get());
                }
                if (this.selector == b.getSelectedIndex()) {
                    return this.selector == -1 || this.value.equals(b.get());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 31;
        return this.selector + 31 * this.value.hashCode();
    }
}

