/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.factory.BaseField;
import org.epics.pvdata.factory.BaseScalar;
import org.epics.pvdata.pv.Array;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Type;

public class BaseScalarArray
extends BaseField
implements ScalarArray {
    private final ScalarType elementType;
    private static final String[] idLUT = new String[]{"boolean[]", "byte[]", "short[]", "int[]", "long[]", "ubyte[]", "ushort[]", "uint[]", "ulong[]", "float[]", "double[]", "string[]"};

    public BaseScalarArray(ScalarType elementType) {
        super(Type.scalarArray);
        if (elementType == null) {
            throw new NullPointerException("elementType is null");
        }
        this.elementType = elementType;
    }

    @Override
    public String getID() {
        return idLUT[this.elementType.ordinal()];
    }

    @Override
    public ScalarType getElementType() {
        return this.elementType;
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        buf.append(this.getID());
    }

    public int hashCode() {
        return 8 | this.elementType.ordinal();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseScalarArray other = (BaseScalarArray)obj;
        return this.elementType.equals((Object)other.elementType);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        buffer.put((byte)(8 | BaseScalar.typeCodeLUT[this.elementType.ordinal()]));
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        throw new RuntimeException("not valid operation, use FieldCreate.deserialize instead");
    }

    @Override
    public Array.ArraySizeType getArraySizeType() {
        return Array.ArraySizeType.variable;
    }

    @Override
    public int getMaximumCapacity() {
        return 0;
    }
}

