/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.epics.pvdata.factory.BaseField;
import org.epics.pvdata.factory.BaseStructure;
import org.epics.pvdata.factory.ConvertFactory;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Type;
import org.epics.pvdata.pv.Union;

public class BaseUnion
extends BaseField
implements Union {
    private static Convert convert = ConvertFactory.getConvert();
    private final String id;
    private final Field[] fields;
    private String[] fieldNames;
    private static final String[] ANY_FIELD_NAMES = new String[0];
    private static final Field[] ANY_FIELDS = new Field[0];
    private static final String EMPTY_ID = "";

    public BaseUnion() {
        this("any", ANY_FIELD_NAMES, ANY_FIELDS);
    }

    public BaseUnion(String[] fieldNames, Field[] fields) {
        this(fieldNames.length > 0 ? "union" : "any", fieldNames, fields);
    }

    public BaseUnion(String id, String[] fieldNames, Field[] fields) {
        super(Type.union);
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        if (id.isEmpty()) {
            throw new IllegalArgumentException("id is empty");
        }
        if (fieldNames.length != fields.length) {
            throw new IllegalArgumentException("fieldNames has different length than fields");
        }
        if (fields.length == 0 && id != "any") {
            throw new IllegalArgumentException("no fields but id is different than any");
        }
        this.id = id;
        this.fields = fields;
        this.fieldNames = fieldNames;
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fieldNames[i];
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName " + i + " is null");
            }
            if (fieldName.length() < 1) {
                throw new IllegalArgumentException("fieldName " + i + " has length 0");
            }
            for (int j = i + 1; j < fields.length; ++j) {
                if (!fieldName.equals(fieldNames[j])) continue;
                throw new IllegalArgumentException("fieldName " + fieldName + " appears more than once");
            }
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Field getField(String name) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!name.equals(this.fieldNames[i])) continue;
            return this.fields[i];
        }
        return null;
    }

    @Override
    public int getFieldIndex(String name) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!name.equals(this.fieldNames[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Field getField(int fieldIndex) {
        return this.fields[fieldIndex];
    }

    @Override
    public <T extends Field> T getField(Class<T> c, String fieldName) {
        Field pv = this.getField(fieldName);
        if (c.isInstance(pv)) {
            return (T)((Field)c.cast(pv));
        }
        return null;
    }

    @Override
    public <T extends Field> T getField(Class<T> c, int fieldOffset) {
        Field pv = this.getField(fieldOffset);
        if (c.isInstance(pv)) {
            return (T)((Field)c.cast(pv));
        }
        return null;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public String getFieldName(int fieldIndex) {
        return this.fieldNames[fieldIndex];
    }

    @Override
    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public boolean isVariant() {
        return this.fields.length == 0;
    }

    @Override
    public void toString(StringBuilder buf, int indentLevel) {
        buf.append(this.getID());
        this.toStringCommon(buf, indentLevel + 1);
    }

    void toStringCommon(StringBuilder buf, int indentLevel) {
        int length = this.fields.length;
        if (length == 0) {
            return;
        }
        convert.newLine(buf, indentLevel);
        for (int i = 0; i < length; ++i) {
            Field field = this.fields[i];
            buf.append(field.getID() + " " + this.fieldNames[i]);
            Type type = field.getType();
            switch (type) {
                case scalar: 
                case scalarArray: {
                    break;
                }
                case structure: {
                    BaseStructure struct = (BaseStructure)field;
                    struct.toStringCommon(buf, indentLevel + 1);
                    break;
                }
                case structureArray: {
                    convert.newLine(buf, indentLevel + 1);
                    field.toString(buf, indentLevel + 1);
                    break;
                }
                case union: {
                    BaseUnion union = (BaseUnion)field;
                    union.toStringCommon(buf, indentLevel + 1);
                    break;
                }
                case unionArray: {
                    convert.newLine(buf, indentLevel + 1);
                    field.toString(buf, indentLevel + 1);
                }
            }
            if (i >= length - 1) continue;
            convert.newLine(buf, indentLevel);
        }
    }

    public int hashCode() {
        int PRIME = 37;
        return this.id.hashCode() + 37 * (37 * Arrays.hashCode(this.fieldNames) + Arrays.hashCode(this.fields));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseUnion other = (BaseUnion)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (!Arrays.equals(this.fieldNames, other.fieldNames)) {
            return false;
        }
        return Arrays.equals(this.fields, other.fields);
    }

    @Override
    public void serialize(ByteBuffer buffer, SerializableControl control) {
        control.ensureBuffer(1);
        if (this.fields.length == 0) {
            buffer.put((byte)-126);
        } else {
            buffer.put((byte)-127);
            BaseUnion.serializeUnionField(this, buffer, control);
        }
    }

    static void serializeUnionField(Union union, ByteBuffer buffer, SerializableControl control) {
        String id = union.getID();
        String idToSerialize = id == "union" ? EMPTY_ID : id;
        SerializeHelper.serializeString(idToSerialize, buffer, control);
        Field[] fields = union.getFields();
        String[] fieldNames = union.getFieldNames();
        SerializeHelper.writeSize(fields.length, buffer, control);
        for (int i = 0; i < fields.length; ++i) {
            SerializeHelper.serializeString(fieldNames[i], buffer, control);
            control.cachedSerialize(fields[i], buffer);
        }
    }

    static final Union deserializeUnionField(ByteBuffer buffer, DeserializableControl control) {
        String id = SerializeHelper.deserializeString(buffer, control);
        int size = SerializeHelper.readSize(buffer, control);
        Field[] fields = new Field[size];
        String[] fieldNames = new String[size];
        for (int i = 0; i < size; ++i) {
            fieldNames[i] = SerializeHelper.deserializeString(buffer, control);
            fields[i] = control.cachedDeserialize(buffer);
        }
        if (id == null || id.isEmpty()) {
            return new BaseUnion(fieldNames, fields);
        }
        return new BaseUnion(id, fieldNames, fields);
    }

    @Override
    public void deserialize(ByteBuffer buffer, DeserializableControl control) {
        throw new RuntimeException("not valid operation, use FieldCreate.deserialize instead");
    }
}

