/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.pv.BooleanArrayData;
import org.epics.pvdata.pv.ByteArrayData;
import org.epics.pvdata.pv.Convert;
import org.epics.pvdata.pv.DoubleArrayData;
import org.epics.pvdata.pv.Field;
import org.epics.pvdata.pv.FloatArrayData;
import org.epics.pvdata.pv.IntArrayData;
import org.epics.pvdata.pv.LongArrayData;
import org.epics.pvdata.pv.PVArray;
import org.epics.pvdata.pv.PVBoolean;
import org.epics.pvdata.pv.PVBooleanArray;
import org.epics.pvdata.pv.PVByte;
import org.epics.pvdata.pv.PVByteArray;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVDoubleArray;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVFloat;
import org.epics.pvdata.pv.PVFloatArray;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVIntArray;
import org.epics.pvdata.pv.PVLong;
import org.epics.pvdata.pv.PVLongArray;
import org.epics.pvdata.pv.PVScalar;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVShort;
import org.epics.pvdata.pv.PVShortArray;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.PVStructureArray;
import org.epics.pvdata.pv.PVUByte;
import org.epics.pvdata.pv.PVUByteArray;
import org.epics.pvdata.pv.PVUInt;
import org.epics.pvdata.pv.PVUIntArray;
import org.epics.pvdata.pv.PVULong;
import org.epics.pvdata.pv.PVULongArray;
import org.epics.pvdata.pv.PVUShort;
import org.epics.pvdata.pv.PVUShortArray;
import org.epics.pvdata.pv.PVUnion;
import org.epics.pvdata.pv.PVUnionArray;
import org.epics.pvdata.pv.Scalar;
import org.epics.pvdata.pv.ScalarArray;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.ShortArrayData;
import org.epics.pvdata.pv.StringArrayData;
import org.epics.pvdata.pv.Structure;
import org.epics.pvdata.pv.StructureArray;
import org.epics.pvdata.pv.StructureArrayData;
import org.epics.pvdata.pv.Type;
import org.epics.pvdata.pv.Union;
import org.epics.pvdata.pv.UnionArray;
import org.epics.pvdata.pv.UnionArrayData;

public final class ConvertFactory {
    public static Convert getConvert() {
        return ImplementConvert.getConvert();
    }

    private static final class ImplementConvert
    implements Convert {
        private static final Pattern separatorPattern = Pattern.compile("[,]");
        private static ImplementConvert singleImplementation = null;
        private static final PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
        private static final BooleanArrayData booleanArrayData = new BooleanArrayData();
        private static final ByteArrayData byteArrayData = new ByteArrayData();
        private static final ShortArrayData shortArrayData = new ShortArrayData();
        private static final IntArrayData intArrayData = new IntArrayData();
        private static final LongArrayData longArrayData = new LongArrayData();
        private static final FloatArrayData floatArrayData = new FloatArrayData();
        private static final DoubleArrayData doubleArrayData = new DoubleArrayData();
        private static final StringArrayData stringArrayData = new StringArrayData();
        private static final StructureArrayData structureArrayData = new StructureArrayData();
        private static final UnionArrayData unionArrayData = new UnionArrayData();
        private static String indentString = "    ";
        private static final BigInteger twoToTheSixtyFour = new BigInteger("10000000000000000", 16);
        private static final double twoToTheSixtyFourReal = Math.pow(2.0, 64.0);
        private static final double twoToTheThirtyTwoReal = Math.pow(2.0, 32.0);

        private static synchronized ImplementConvert getConvert() {
            if (singleImplementation == null) {
                singleImplementation = new ImplementConvert();
            }
            return singleImplementation;
        }

        private ImplementConvert() {
        }

        @Override
        public void getFullFieldName(StringBuilder buf, PVField pvField) {
            buf.setLength(0);
            PVStructure parent = pvField.getParent();
            PVField pvNow = pvField;
            while (parent != null) {
                PVField[] pvFields = parent.getPVFields();
                for (int i = 0; i < pvFields.length; ++i) {
                    if (pvFields[i] != pvNow) continue;
                    if (buf.length() > 0) {
                        buf.insert(0, '.');
                    }
                    buf.insert(0, parent.getStructure().getFieldName(i));
                    pvNow = parent;
                    parent = parent.getParent();
                }
            }
        }

        @Override
        public void getString(StringBuilder buf, PVField pv, int indentLevel) {
            this.convertToString(buf, pv, indentLevel);
        }

        @Override
        public void getString(StringBuilder buf, PVField pv) {
            this.convertToString(buf, pv, 0);
        }

        @Override
        public void fromString(PVScalar pv, String from) {
            Scalar scalar = pv.getScalar();
            ScalarType scalarType = scalar.getScalarType();
            switch (scalarType) {
                case pvBoolean: {
                    PVBoolean value = (PVBoolean)pv;
                    value.put(Boolean.parseBoolean(from));
                    break;
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put(ImplementConvert.stringToByte(from));
                    break;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put(ImplementConvert.stringToShort(from));
                    break;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put(ImplementConvert.stringToInt(from));
                    break;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(ImplementConvert.stringToLong(from));
                    break;
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    value.put(ImplementConvert.stringToUByte(from));
                    break;
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    value.put(ImplementConvert.stringToUShort(from));
                    break;
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    value.put(ImplementConvert.stringToUInt(from));
                    break;
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    value.put(ImplementConvert.stringToULong(from));
                    break;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(ImplementConvert.stringToFloat(from));
                    break;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(ImplementConvert.stringToDouble(from));
                    break;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(from);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown scalarType  " + scalarType.toString());
                }
            }
        }

        @Override
        public int fromString(PVScalarArray pv, String from) {
            int length;
            String[] values;
            int num;
            if (from.charAt(0) == '[' && from.endsWith("]")) {
                int offset = from.lastIndexOf(93);
                from = from.substring(1, offset);
            }
            if ((num = this.fromStringArray(pv, 0, (values = separatorPattern.split(from)).length, values, 0)) < (length = values.length)) {
                length = num;
            }
            pv.setLength(length);
            return length;
        }

        @Override
        public int fromStringArray(PVScalarArray pv, int offset, int len, String[] from, int fromOffset) {
            return this.convertFromStringArray(pv, offset, len, from, fromOffset);
        }

        @Override
        public int toStringArray(PVScalarArray pv, int offset, int len, String[] to, int toOffset) {
            return this.convertToStringArray(pv, offset, len, to, toOffset);
        }

        @Override
        public boolean isCopyCompatible(Field from, Field to) {
            if (from.getType() != to.getType()) {
                return false;
            }
            switch (from.getType()) {
                case scalar: {
                    return this.isCopyScalarCompatible((Scalar)from, (Scalar)to);
                }
                case scalarArray: {
                    return this.isCopyScalarArrayCompatible((ScalarArray)from, (ScalarArray)to);
                }
                case structure: {
                    return this.isCopyStructureCompatible((Structure)from, (Structure)to);
                }
                case structureArray: {
                    return this.isCopyStructureArrayCompatible((StructureArray)from, (StructureArray)to);
                }
                case union: {
                    return this.isCopyUnionCompatible((Union)from, (Union)to);
                }
                case unionArray: {
                    return this.isCopyUnionArrayCompatible((UnionArray)from, (UnionArray)to);
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void copy(PVField from, PVField to) {
            switch (from.getField().getType()) {
                case scalar: {
                    this.copyScalar((PVScalar)from, (PVScalar)to);
                    return;
                }
                case scalarArray: {
                    PVScalarArray fromArray = (PVScalarArray)from;
                    PVScalarArray toArray = (PVScalarArray)to;
                    int length = this.copyScalarArray(fromArray, 0, toArray, 0, fromArray.getLength());
                    if (toArray.getLength() != length) {
                        toArray.setLength(length);
                    }
                    return;
                }
                case structure: {
                    this.copyStructure((PVStructure)from, (PVStructure)to);
                    return;
                }
                case structureArray: {
                    PVStructureArray fromArray = (PVStructureArray)from;
                    PVStructureArray toArray = (PVStructureArray)to;
                    int length = this.copyStructureArray(fromArray, 0, toArray, 0, fromArray.getLength());
                    if (toArray.getLength() != length) {
                        toArray.setLength(length);
                    }
                    return;
                }
                case union: {
                    this.copyUnion((PVUnion)from, (PVUnion)to);
                    return;
                }
                case unionArray: {
                    PVUnionArray fromArray = (PVUnionArray)from;
                    PVUnionArray toArray = (PVUnionArray)to;
                    int length = this.copyUnionArray(fromArray, 0, toArray, 0, fromArray.getLength());
                    if (toArray.getLength() != length) {
                        toArray.setLength(length);
                    }
                    return;
                }
            }
        }

        @Override
        public boolean isCopyScalarCompatible(Scalar fromField, Scalar toField) {
            ScalarType toScalarType;
            ScalarType fromScalarType = fromField.getScalarType();
            if (fromScalarType == (toScalarType = toField.getScalarType())) {
                return true;
            }
            if (fromScalarType.isNumeric() && toScalarType.isNumeric()) {
                return true;
            }
            if (fromScalarType == ScalarType.pvString) {
                return true;
            }
            return toScalarType == ScalarType.pvString;
        }

        @Override
        public void copyScalar(PVScalar from, PVScalar to) {
            if (to.isImmutable()) {
                if (from.equals(to)) {
                    return;
                }
                throw new IllegalArgumentException("Convert.copyScalar destination is immutable");
            }
            ScalarType fromType = from.getScalar().getScalarType();
            ScalarType toType = to.getScalar().getScalarType();
            switch (fromType) {
                case pvBoolean: {
                    if (toType != ScalarType.pvBoolean && toType != ScalarType.pvString) {
                        throw new IllegalArgumentException("Convert.copyScalar arguments are not compatible");
                    }
                    PVBoolean data = (PVBoolean)from;
                    boolean value = data.get();
                    if (toType == ScalarType.pvString) {
                        PVString dataTo = (PVString)to;
                        dataTo.put(Boolean.valueOf(value).toString());
                        break;
                    }
                    PVBoolean dataTo = (PVBoolean)to;
                    dataTo.put(value);
                    break;
                }
                case pvByte: {
                    PVByte data = (PVByte)from;
                    byte value = data.get();
                    this.fromByte(to, value);
                    break;
                }
                case pvShort: {
                    PVShort data = (PVShort)from;
                    short value = data.get();
                    this.fromShort(to, value);
                    break;
                }
                case pvInt: {
                    PVInt data = (PVInt)from;
                    int value = data.get();
                    this.fromInt(to, value);
                    break;
                }
                case pvLong: {
                    PVLong data = (PVLong)from;
                    long value = data.get();
                    this.fromLong(to, value);
                    break;
                }
                case pvUByte: {
                    PVUByte data = (PVUByte)from;
                    byte value = data.get();
                    this.fromUByte(to, value);
                    break;
                }
                case pvUShort: {
                    PVUShort data = (PVUShort)from;
                    short value = data.get();
                    this.fromUShort(to, value);
                    break;
                }
                case pvUInt: {
                    PVUInt data = (PVUInt)from;
                    int value = data.get();
                    this.fromUInt(to, value);
                    break;
                }
                case pvULong: {
                    PVULong data = (PVULong)from;
                    long value = data.get();
                    this.fromULong(to, value);
                    break;
                }
                case pvFloat: {
                    PVFloat data = (PVFloat)from;
                    float value = data.get();
                    this.fromFloat(to, value);
                    break;
                }
                case pvDouble: {
                    PVDouble data = (PVDouble)from;
                    double value = data.get();
                    this.fromDouble(to, value);
                    break;
                }
                case pvString: {
                    PVString data = (PVString)from;
                    String value = data.get();
                    this.fromString(to, value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Convert.copyScalar arguments are not compatible");
                }
            }
        }

        @Override
        public boolean isCopyScalarArrayCompatible(ScalarArray fromArray, ScalarArray toArray) {
            ScalarType toType;
            ScalarType fromType = fromArray.getElementType();
            if (fromType == (toType = toArray.getElementType())) {
                return true;
            }
            if (fromType.isNumeric() && toType.isNumeric()) {
                return true;
            }
            if (toType == ScalarType.pvString) {
                return true;
            }
            return fromType == ScalarType.pvString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int copyScalarArray(PVScalarArray from, int offset, PVScalarArray to, int toOffset, int count) {
            int ncopy;
            block38: {
                int toCapacity;
                if (to.isImmutable()) {
                    if (from.equals(to)) {
                        return from.getLength();
                    }
                    throw new IllegalArgumentException("Convert.copyArray destination is immutable");
                }
                if (offset + count > from.getLength()) {
                    throw new IllegalArgumentException("Convert.copyUnionArray fromOffset+count > from.getLength()");
                }
                if (!to.isCapacityMutable() && (toCapacity = to.getCapacity()) < count + toOffset && (count = toCapacity - toOffset) <= 0) {
                    return 0;
                }
                if (to.getCapacity() < count + toOffset) {
                    to.setCapacity(count + toOffset);
                }
                ScalarType fromElementType = from.getScalarArray().getElementType();
                ScalarType toElementType = to.getScalarArray().getElementType();
                if (from.isImmutable() && fromElementType == toElementType && offset == 0 && toOffset == 0 && count == from.getLength()) {
                    return this.copyArrayDataReference(from, to);
                }
                ncopy = 0;
                if (toElementType.isNumeric() && fromElementType.isNumeric()) {
                    ncopy = this.copyNumericArray(from, offset, to, toOffset, count);
                } else if (toElementType == ScalarType.pvBoolean && fromElementType == ScalarType.pvBoolean) {
                    PVBooleanArray pvfrom = (PVBooleanArray)from;
                    PVBooleanArray pvto = (PVBooleanArray)to;
                    while (count > 0) {
                        int num = 0;
                        boolean[] data = null;
                        int fromOffset = 0;
                        BooleanArrayData booleanArrayData = ImplementConvert.booleanArrayData;
                        synchronized (booleanArrayData) {
                            num = pvfrom.get(offset, count, ImplementConvert.booleanArrayData);
                            data = (boolean[])ImplementConvert.booleanArrayData.data;
                            fromOffset = ImplementConvert.booleanArrayData.offset;
                        }
                        if (num <= 0) break;
                        while (num > 0) {
                            int n = pvto.put(toOffset, num, data, fromOffset);
                            if (n > 0) {
                                count -= n;
                                num -= n;
                                ncopy += n;
                                offset += n;
                                toOffset += n;
                                continue;
                            }
                            break block38;
                        }
                    }
                } else if (toElementType == ScalarType.pvString && fromElementType == ScalarType.pvString) {
                    PVStringArray pvfrom = (PVStringArray)from;
                    PVStringArray pvto = (PVStringArray)to;
                    while (count > 0) {
                        int num = 0;
                        String[] data = null;
                        int fromOffset2 = 0;
                        StringArrayData n = stringArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, count, stringArrayData);
                            data = (String[])ImplementConvert.stringArrayData.data;
                            fromOffset2 = ImplementConvert.stringArrayData.offset;
                        }
                        if (num <= 0) break;
                        while (num > 0) {
                            int n2 = pvto.put(toOffset, num, data, fromOffset2);
                            if (n2 > 0) {
                                count -= n2;
                                num -= n2;
                                ncopy += n2;
                                offset += n2;
                                toOffset += n2;
                                continue;
                            }
                            break block38;
                        }
                    }
                } else if (toElementType == ScalarType.pvString) {
                    PVStringArray pvto = (PVStringArray)to;
                    ncopy = from.getLength();
                    if (ncopy > count) {
                        ncopy = count;
                    }
                    int num = ncopy;
                    String[] toData = new String[1];
                    while (num > 0) {
                        this.toStringArray(from, offset, 1, toData, 0);
                        if (pvto.put(toOffset, 1, toData, 0) > 0) {
                            --num;
                            ++offset;
                            ++toOffset;
                            continue;
                        }
                        break;
                    }
                } else if (fromElementType == ScalarType.pvString) {
                    PVStringArray pvfrom = (PVStringArray)from;
                    while (count > 0) {
                        int num = 0;
                        String[] data = null;
                        int fromOffset = 0;
                        StringArrayData fromOffset2 = stringArrayData;
                        synchronized (fromOffset2) {
                            num = pvfrom.get(offset, count, stringArrayData);
                            data = (String[])ImplementConvert.stringArrayData.data;
                            fromOffset = ImplementConvert.stringArrayData.offset;
                        }
                        if (num <= 0) break;
                        while (num > 0) {
                            int n = this.fromStringArray(to, toOffset, num, data, fromOffset);
                            if (n > 0) {
                                count -= n;
                                num -= n;
                                ncopy += n;
                                offset += n;
                                toOffset += n;
                                continue;
                            }
                            break block38;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(String.format("%s[] can not be converted to %s[]", new Object[]{fromElementType, toElementType}));
                }
            }
            if (to.getLength() < count + offset) {
                to.setLength(count + offset);
            }
            return ncopy;
        }

        @Override
        public boolean isCopyStructureCompatible(Structure fromStruct, Structure toStruct) {
            Field[] toFields;
            Field[] fromFields = fromStruct.getFields();
            int length = fromFields.length;
            if (length != (toFields = toStruct.getFields()).length) {
                return false;
            }
            block8: for (int i = 0; i < length; ++i) {
                Type toType;
                Field from = fromFields[i];
                Field to = toFields[i];
                Type fromType = from.getType();
                if (fromType != (toType = to.getType())) {
                    return false;
                }
                switch (fromType) {
                    case scalar: {
                        if (this.isCopyScalarCompatible((Scalar)from, (Scalar)to)) continue block8;
                        return false;
                    }
                    case scalarArray: {
                        if (this.isCopyScalarArrayCompatible((ScalarArray)from, (ScalarArray)to)) continue block8;
                        return false;
                    }
                    case structure: {
                        if (this.isCopyStructureCompatible((Structure)from, (Structure)to)) continue block8;
                        return false;
                    }
                    case structureArray: {
                        if (this.isCopyStructureArrayCompatible((StructureArray)from, (StructureArray)to)) continue block8;
                        return false;
                    }
                    case union: {
                        if (this.isCopyUnionCompatible((Union)from, (Union)to)) continue block8;
                        return false;
                    }
                    case unionArray: {
                        if (this.isCopyUnionArrayCompatible((UnionArray)from, (UnionArray)to)) continue block8;
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public boolean isCopyUnionCompatible(Union from, Union to) {
            return from.equals(to);
        }

        @Override
        public void copyStructure(PVStructure from, PVStructure to) {
            PVField[] toDatas;
            if (to.isImmutable()) {
                if (from.equals(to)) {
                    return;
                }
                throw new IllegalArgumentException("Convert.copyStructure destination is immutable");
            }
            if (from == to) {
                return;
            }
            PVField[] fromDatas = from.getPVFields();
            if (fromDatas.length != (toDatas = to.getPVFields()).length) {
                throw new IllegalArgumentException("Illegal copyStructure");
            }
            if (fromDatas.length == 2) {
                boolean isEnumerated;
                String[] fromNames = from.getStructure().getFieldNames();
                String[] toNames = to.getStructure().getFieldNames();
                boolean bl = isEnumerated = fromNames[0].equals("index") && toNames[0].equals("index");
                if (isEnumerated && fromNames[1].equals("choices") && toNames[0].equals("choices")) {
                    PVScalar pvScalar = (PVScalar)fromDatas[0];
                    PVScalarArray pvArray = (PVScalarArray)fromDatas[1];
                    PVScalarArray toArray = (PVScalarArray)toDatas[1];
                    this.copyScalarArray(pvArray, 0, toArray, 0, pvArray.getLength());
                    PVScalar toScalar = (PVScalar)toDatas[0];
                    this.copyScalar(pvScalar, toScalar);
                    return;
                }
            }
            block8: for (int i = 0; i < fromDatas.length; ++i) {
                Type toType;
                PVField fromData = fromDatas[i];
                PVField toData = toDatas[i];
                Type fromType = fromData.getField().getType();
                if (fromType != (toType = toData.getField().getType())) {
                    throw new IllegalArgumentException("Illegal copyStructure");
                }
                switch (fromType) {
                    case scalar: {
                        this.copyScalar((PVScalar)fromData, (PVScalar)toData);
                        continue block8;
                    }
                    case scalarArray: {
                        PVArray fromArray = (PVScalarArray)fromData;
                        PVArray toArray = (PVScalarArray)toData;
                        int length = this.copyScalarArray((PVScalarArray)fromArray, 0, (PVScalarArray)toArray, 0, fromArray.getLength());
                        if (toArray.getLength() == length) continue block8;
                        toArray.setLength(length);
                        continue block8;
                    }
                    case structure: {
                        this.copyStructure((PVStructure)fromData, (PVStructure)toData);
                        continue block8;
                    }
                    case structureArray: {
                        PVArray fromArray = (PVStructureArray)fromData;
                        PVArray toArray = (PVStructureArray)toData;
                        this.copyStructureArray((PVStructureArray)fromArray, (PVStructureArray)toArray);
                        continue block8;
                    }
                    case union: {
                        this.copyUnion((PVUnion)fromData, (PVUnion)toData);
                        continue block8;
                    }
                    case unionArray: {
                        PVArray fromArray = (PVUnionArray)fromData;
                        PVArray toArray = (PVUnionArray)toData;
                        this.copyUnionArray((PVUnionArray)fromArray, (PVUnionArray)toArray);
                        continue block8;
                    }
                }
            }
        }

        @Override
        public void copyUnion(PVUnion from, PVUnion to) {
            if (to.isImmutable()) {
                if (from.equals(to)) {
                    return;
                }
                throw new IllegalArgumentException("Convert.copyUnion destination is immutable");
            }
            if (from == to) {
                return;
            }
            if (!this.isCopyUnionCompatible(from.getUnion(), to.getUnion())) {
                throw new IllegalArgumentException("Illegal copyUnion");
            }
            PVField fromValue = from.get();
            if (from.getUnion().isVariant()) {
                PVField toValue = null;
                if (fromValue != null) {
                    toValue = pvDataCreate.createPVField(fromValue.getField());
                    this.copy(fromValue, toValue);
                }
                to.set(toValue);
            } else if (fromValue == null) {
                to.select(-1);
            } else {
                PVField toValue = pvDataCreate.createPVField(fromValue.getField());
                this.copy(fromValue, toValue);
                to.set(from.getSelectedIndex(), toValue);
            }
        }

        @Override
        public boolean isCopyStructureArrayCompatible(StructureArray from, StructureArray to) {
            return this.isCopyStructureCompatible(from.getStructure(), to.getStructure());
        }

        @Override
        public boolean isCopyUnionArrayCompatible(UnionArray from, UnionArray to) {
            return this.isCopyUnionCompatible(from.getUnion(), to.getUnion());
        }

        @Override
        public void copyStructureArray(PVStructureArray from, PVStructureArray to) {
            this.copyStructureArray(from, 0, to, 0, from.getLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int copyStructureArray(PVStructureArray from, int fromOffset, PVStructureArray to, int toOffset, int count) {
            int toCapacity;
            if (to.isImmutable()) {
                if (from.equals(to)) {
                    return 0;
                }
                throw new IllegalArgumentException("Convert.copyStructureArray destination is immutable");
            }
            if (!this.isCopyStructureCompatible(from.getStructureArray().getStructure(), to.getStructureArray().getStructure())) {
                throw new IllegalArgumentException("Convert.copyStructureArray from and to are not compatible");
            }
            if (fromOffset + count > from.getLength()) {
                throw new IllegalArgumentException("Convert.copyUnionArray fromOffset+count > from.getLength()");
            }
            if (!to.isCapacityMutable() && (toCapacity = to.getCapacity()) < count + toOffset && (count = toCapacity - toOffset) <= 0) {
                return 0;
            }
            if (to.getCapacity() < count + toOffset) {
                to.setCapacity(count + toOffset);
            }
            PVStructure[] fromArray = null;
            StructureArrayData structureArrayData = ImplementConvert.structureArrayData;
            synchronized (structureArrayData) {
                from.get(0, count + fromOffset, ImplementConvert.structureArrayData);
                fromArray = (PVStructure[])ImplementConvert.structureArrayData.data;
            }
            PVStructure[] toArray = null;
            StructureArrayData structureArrayData2 = ImplementConvert.structureArrayData;
            synchronized (structureArrayData2) {
                to.get(0, count + toOffset, ImplementConvert.structureArrayData);
                toArray = (PVStructure[])ImplementConvert.structureArrayData.data;
            }
            for (int i = 0; i < count; ++i) {
                if (fromArray[i + fromOffset] == null) {
                    toArray[i + toOffset] = null;
                    continue;
                }
                if (toArray[i + toOffset] == null) {
                    Structure structure = to.getStructureArray().getStructure();
                    toArray[i + toOffset] = pvDataCreate.createPVStructure(structure);
                }
                this.copyStructure(fromArray[i + fromOffset], toArray[i + toOffset]);
            }
            if (to.getLength() < count + toOffset) {
                to.setLength(count + toOffset);
            }
            to.postPut();
            return count;
        }

        @Override
        public void copyUnionArray(PVUnionArray from, PVUnionArray to) {
            this.copyUnionArray(from, 0, to, 0, from.getLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int copyUnionArray(PVUnionArray from, int fromOffset, PVUnionArray to, int toOffset, int count) {
            int toCapacity;
            if (to.isImmutable()) {
                if (from.equals(to)) {
                    return 0;
                }
                throw new IllegalArgumentException("Convert.copyUnionArray destination is immutable");
            }
            if (!this.isCopyUnionCompatible(from.getUnionArray().getUnion(), to.getUnionArray().getUnion())) {
                throw new IllegalArgumentException("Convert.copyUnionArray from and to are not compatible");
            }
            if (fromOffset + count > from.getLength()) {
                throw new IllegalArgumentException("Convert.copyUnionArray fromOffset+count > from.getLength()");
            }
            if (!to.isCapacityMutable() && (toCapacity = to.getCapacity()) < count + toOffset && (count = toCapacity - toOffset) <= 0) {
                return 0;
            }
            if (to.getCapacity() < count + toOffset) {
                to.setCapacity(count + toOffset);
            }
            PVUnion[] fromArray = null;
            UnionArrayData unionArrayData = ImplementConvert.unionArrayData;
            synchronized (unionArrayData) {
                from.get(0, count + fromOffset, ImplementConvert.unionArrayData);
                fromArray = (PVUnion[])ImplementConvert.unionArrayData.data;
            }
            PVUnion[] toArray = null;
            UnionArrayData unionArrayData2 = ImplementConvert.unionArrayData;
            synchronized (unionArrayData2) {
                to.get(0, count + toOffset, ImplementConvert.unionArrayData);
                toArray = (PVUnion[])ImplementConvert.unionArrayData.data;
            }
            for (int i = 0; i < count; ++i) {
                if (fromArray[i + fromOffset] == null) {
                    toArray[i + toOffset] = null;
                    continue;
                }
                if (toArray[i + toOffset] == null) {
                    Union union = to.getUnionArray().getUnion();
                    toArray[i + toOffset] = pvDataCreate.createPVUnion(union);
                }
                this.copyUnion(fromArray[i + fromOffset], toArray[i + toOffset]);
            }
            if (to.getLength() < count + toOffset) {
                to.setLength(count + toOffset);
            }
            to.postPut();
            return count;
        }

        @Override
        public byte toByte(PVScalar pv) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("boolean can not be converted to byte");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    return value.get();
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    return (byte)value.get();
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    return (byte)value.get();
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    return (byte)value.get();
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    return value.get();
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    return (byte)value.get();
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    return (byte)value.get();
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    return (byte)value.get();
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    return (byte)value.get();
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    return (byte)value.get();
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    return ImplementConvert.stringToByte(value.get());
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public short toShort(PVScalar pv) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("boolean can not be converted to short");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    return value.get();
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    return value.get();
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    return (short)value.get();
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    return (short)value.get();
                }
                case pvUByte: {
                    PVUByte pvval = (PVUByte)pv;
                    short value = ImplementConvert.widenUnsigned(pvval.get());
                    return value;
                }
                case pvUShort: {
                    PVUShort pvval = (PVUShort)pv;
                    return pvval.get();
                }
                case pvUInt: {
                    PVUInt pvval = (PVUInt)pv;
                    return (short)pvval.get();
                }
                case pvULong: {
                    PVULong pvval = (PVULong)pv;
                    return (short)pvval.get();
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    return (short)value.get();
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    return (short)value.get();
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    return ImplementConvert.stringToShort(value.get());
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public int toInt(PVScalar pv) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("boolean can not be converted to int");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    return value.get();
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    return value.get();
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    return value.get();
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    return (int)value.get();
                }
                case pvUByte: {
                    PVUByte pvval = (PVUByte)pv;
                    short value = ImplementConvert.widenUnsigned(pvval.get());
                    return value;
                }
                case pvUShort: {
                    PVUShort pvval = (PVUShort)pv;
                    int value = ImplementConvert.widenUnsigned(pvval.get());
                    return value;
                }
                case pvUInt: {
                    PVUInt pvval = (PVUInt)pv;
                    return pvval.get();
                }
                case pvULong: {
                    PVULong pvval = (PVULong)pv;
                    return (int)pvval.get();
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    return (int)value.get();
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    return (int)value.get();
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    return ImplementConvert.stringToInt(value.get());
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public long toLong(PVScalar pv) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("boolean can not be converted to long");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    return value.get();
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    return value.get();
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    return value.get();
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    return value.get();
                }
                case pvUByte: {
                    PVUByte pvval = (PVUByte)pv;
                    short value = ImplementConvert.widenUnsigned(pvval.get());
                    return value;
                }
                case pvUShort: {
                    PVUShort pvval = (PVUShort)pv;
                    int value = ImplementConvert.widenUnsigned(pvval.get());
                    return value;
                }
                case pvUInt: {
                    PVUInt pvval = (PVUInt)pv;
                    long value = ImplementConvert.widenUnsigned(pvval.get());
                    return value;
                }
                case pvULong: {
                    PVULong pvval = (PVULong)pv;
                    return pvval.get();
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    return (long)value.get();
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    return (long)value.get();
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    return ImplementConvert.stringToLong(value.get());
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public float toFloat(PVScalar pv) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("boolean can not be converted to float");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    return value.get();
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    return value.get();
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    return value.get();
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    return value.get();
                }
                case pvUByte: {
                    PVUByte pval = (PVUByte)pv;
                    return ImplementConvert.widenUnsigned(pval.get());
                }
                case pvUShort: {
                    PVUShort pval = (PVUShort)pv;
                    return ImplementConvert.widenUnsigned(pval.get());
                }
                case pvUInt: {
                    PVUInt pval = (PVUInt)pv;
                    return ImplementConvert.widenUnsigned(pval.get());
                }
                case pvULong: {
                    PVULong pval = (PVULong)pv;
                    long val = pval.get();
                    return ImplementConvert.ulongToFloat(val);
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    return value.get();
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    return (float)value.get();
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    return ImplementConvert.stringToFloat(value.get());
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public double toDouble(PVScalar pv) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("boolean can not be converted to double");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    return value.get();
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    return value.get();
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    return value.get();
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    return value.get();
                }
                case pvUByte: {
                    PVUByte pval = (PVUByte)pv;
                    return ImplementConvert.widenUnsigned(pval.get());
                }
                case pvUShort: {
                    PVUShort pval = (PVUShort)pv;
                    return ImplementConvert.widenUnsigned(pval.get());
                }
                case pvUInt: {
                    PVUInt pval = (PVUInt)pv;
                    return ImplementConvert.widenUnsigned(pval.get());
                }
                case pvULong: {
                    PVULong pval = (PVULong)pv;
                    long val = pval.get();
                    return ImplementConvert.ulongToDouble(val);
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    return value.get();
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    return value.get();
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    return ImplementConvert.stringToDouble(value.get());
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromByte(PVScalar pv, byte from) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("byte can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put(from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put(from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put(from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte pvval = (PVUByte)pv;
                    pvval.put(from);
                    return;
                }
                case pvUShort: {
                    PVUShort pvval = (PVUShort)pv;
                    pvval.put(from);
                    return;
                }
                case pvUInt: {
                    PVUInt pvval = (PVUInt)pv;
                    pvval.put(from);
                    return;
                }
                case pvULong: {
                    PVULong pvval = (PVULong)pv;
                    pvval.put(from);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(String.valueOf(from));
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromShort(PVScalar pv, short from) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("short can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put(from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put(from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte pvval = (PVUByte)pv;
                    long value = from;
                    pvval.put((byte)value);
                    return;
                }
                case pvUShort: {
                    PVUShort pvval = (PVUShort)pv;
                    long value = from;
                    pvval.put((short)value);
                    return;
                }
                case pvUInt: {
                    PVUInt pvval = (PVUInt)pv;
                    long value = from;
                    pvval.put((int)value);
                    return;
                }
                case pvULong: {
                    PVULong pvval = (PVULong)pv;
                    long value = from;
                    pvval.put(value);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(String.valueOf(from));
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromInt(PVScalar pv, int from) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("int can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put(from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte pvval = (PVUByte)pv;
                    long value = from;
                    pvval.put((byte)value);
                    return;
                }
                case pvUShort: {
                    PVUShort pvval = (PVUShort)pv;
                    long value = from;
                    pvval.put((short)value);
                    return;
                }
                case pvUInt: {
                    PVUInt pvval = (PVUInt)pv;
                    long value = from;
                    pvval.put((int)value);
                    return;
                }
                case pvULong: {
                    PVULong pvval = (PVULong)pv;
                    long value = from;
                    pvval.put(value);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(String.valueOf(from));
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromLong(PVScalar pv, long from) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("long can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put((int)from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte pvval = (PVUByte)pv;
                    long value = from;
                    pvval.put((byte)value);
                    return;
                }
                case pvUShort: {
                    PVUShort pvval = (PVUShort)pv;
                    long value = from;
                    pvval.put((short)value);
                    return;
                }
                case pvUInt: {
                    PVUInt pvval = (PVUInt)pv;
                    long value = from;
                    pvval.put((int)value);
                    return;
                }
                case pvULong: {
                    PVULong pvval = (PVULong)pv;
                    long value = from;
                    pvval.put(value);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(String.valueOf(from));
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromUByte(PVScalar pv, byte xxx) {
            short from = ImplementConvert.widenUnsigned(xxx);
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("byte can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put(from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put(from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    value.put(from);
                    return;
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    value.put(from);
                    return;
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    value.put(from);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    String val = ImplementConvert.longToString(from);
                    value.put(val);
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromUShort(PVScalar pv, short xxx) {
            int from = ImplementConvert.widenUnsigned(xxx);
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("byte can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put(from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    value.put(from);
                    return;
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    value.put(from);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    String val = ImplementConvert.longToString(from);
                    value.put(val);
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromUInt(PVScalar pv, int xxx) {
            long from = ImplementConvert.widenUnsigned(xxx);
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("byte can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put((int)from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    value.put((int)from);
                    return;
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    value.put(from);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    String val = Long.toString(from);
                    value.put(val);
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromULong(PVScalar pv, long from) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("byte can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put((int)from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put(from);
                    return;
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    value.put((int)from);
                    return;
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    value.put(from);
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(ImplementConvert.ulongToFloat(from));
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(ImplementConvert.ulongToDouble(from));
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(ImplementConvert.ulongToString(from));
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromFloat(PVScalar pv, float from) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("float can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put((int)from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put((long)from);
                    return;
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    value.put(ImplementConvert.floatToUByte(from));
                    return;
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    value.put(ImplementConvert.floatToUShort(from));
                    return;
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    value.put(ImplementConvert.floatToUInt(from));
                    return;
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    value.put(ImplementConvert.floatToULong(from));
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put(from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(ImplementConvert.floatToString(from));
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public void fromDouble(PVScalar pv, double from) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    throw new IllegalArgumentException("double can not be converted to boolean");
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    value.put((byte)from);
                    return;
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    value.put((short)from);
                    return;
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    value.put((int)from);
                    return;
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    value.put((long)from);
                    return;
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    value.put(ImplementConvert.doubleToUByte(from));
                    return;
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    value.put(ImplementConvert.doubleToUShort(from));
                    return;
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    value.put(ImplementConvert.doubleToUInt(from));
                    return;
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    value.put(ImplementConvert.doubleToULong(from));
                    return;
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    value.put((float)from);
                    return;
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    value.put(from);
                    return;
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    value.put(ImplementConvert.doubleToString(from));
                    return;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        @Override
        public int toByteArray(PVScalarArray pv, int offset, int len, byte[] to, int toOffset) {
            return this.convertToByteArray(pv, offset, len, to, toOffset);
        }

        @Override
        public int toShortArray(PVScalarArray pv, int offset, int len, short[] to, int toOffset) {
            return this.convertToShortArray(pv, offset, len, to, toOffset);
        }

        @Override
        public int toIntArray(PVScalarArray pv, int offset, int len, int[] to, int toOffset) {
            return this.convertToIntArray(pv, offset, len, to, toOffset);
        }

        @Override
        public int toLongArray(PVScalarArray pv, int offset, int len, long[] to, int toOffset) {
            return this.convertToLongArray(pv, offset, len, to, toOffset);
        }

        @Override
        public int toFloatArray(PVScalarArray pv, int offset, int len, float[] to, int toOffset) {
            return this.convertToFloatArray(pv, offset, len, to, toOffset);
        }

        @Override
        public int toDoubleArray(PVScalarArray pv, int offset, int len, double[] to, int toOffset) {
            return this.convertToDoubleArray(pv, offset, len, to, toOffset);
        }

        @Override
        public int fromByteArray(PVScalarArray pv, int offset, int len, byte[] from, int fromOffset) {
            int num = this.convertFromByteArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromShortArray(PVScalarArray pv, int offset, int len, short[] from, int fromOffset) {
            int num = this.convertFromShortArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromIntArray(PVScalarArray pv, int offset, int len, int[] from, int fromOffset) {
            int num = this.convertFromIntArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromLongArray(PVScalarArray pv, int offset, int len, long[] from, int fromOffset) {
            int num = this.convertFromLongArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromUByteArray(PVScalarArray pv, int offset, int len, byte[] from, int fromOffset) {
            int num = this.convertFromUByteArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromUShortArray(PVScalarArray pv, int offset, int len, short[] from, int fromOffset) {
            int num = this.convertFromUShortArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromUIntArray(PVScalarArray pv, int offset, int len, int[] from, int fromOffset) {
            int num = this.convertFromUIntArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromULongArray(PVScalarArray pv, int offset, int len, long[] from, int fromOffset) {
            int num = this.convertFromULongArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromFloatArray(PVScalarArray pv, int offset, int len, float[] from, int fromOffset) {
            int num = this.convertFromFloatArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public int fromDoubleArray(PVScalarArray pv, int offset, int len, double[] from, int fromOffset) {
            int num = this.convertFromDoubleArray(pv, offset, len, from, fromOffset);
            return num;
        }

        @Override
        public String toString(PVScalar pv) {
            ScalarType type = pv.getScalar().getScalarType();
            switch (type) {
                case pvBoolean: {
                    PVBoolean value = (PVBoolean)pv;
                    boolean val = value.get();
                    return val ? "true" : "false";
                }
                case pvByte: {
                    PVByte value = (PVByte)pv;
                    return ImplementConvert.byteToString(value.get());
                }
                case pvShort: {
                    PVShort value = (PVShort)pv;
                    return ImplementConvert.shortToString(value.get());
                }
                case pvInt: {
                    PVInt value = (PVInt)pv;
                    return ImplementConvert.intToString(value.get());
                }
                case pvLong: {
                    PVLong value = (PVLong)pv;
                    return ImplementConvert.longToString(value.get());
                }
                case pvUByte: {
                    PVUByte value = (PVUByte)pv;
                    return ImplementConvert.ubyteToString(value.get());
                }
                case pvUShort: {
                    PVUShort value = (PVUShort)pv;
                    return ImplementConvert.ushortToString(value.get());
                }
                case pvUInt: {
                    PVUInt value = (PVUInt)pv;
                    return ImplementConvert.uintToString(value.get());
                }
                case pvULong: {
                    PVULong value = (PVULong)pv;
                    return ImplementConvert.ulongToString(value.get());
                }
                case pvFloat: {
                    PVFloat value = (PVFloat)pv;
                    return ImplementConvert.floatToString(value.get());
                }
                case pvDouble: {
                    PVDouble value = (PVDouble)pv;
                    return ImplementConvert.doubleToString(value.get());
                }
                case pvString: {
                    PVString value = (PVString)pv;
                    return value.get();
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromByteArray(PVScalarArray pv, int offset, int len, byte[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from byte[] to BooleanArray not legal");
                }
                case pvByte: {
                    int n;
                    PVByteArray pvdata = (PVByteArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    int n;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        short value;
                        data[0] = value = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        int value;
                        data[0] = value = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        long value;
                        data[0] = value = (long)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = String.valueOf(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromUByteArray(PVScalarArray pv, int offset, int len, byte[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from byte[] to BooleanArray not legal");
                }
                case pvByte: {
                    int n;
                    PVByteArray pvdata = (PVByteArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        short value;
                        data[0] = value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        short value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        short value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    int n;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        short value;
                        data[0] = value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        short value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        short value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        short value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        short value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.ubyteToString(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int convertToByteArray(PVScalarArray pv, int offset, int len, byte[] to, int toOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert BooleanArray to byte[]] not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    while (len > 0) {
                        int num = 0;
                        byte[] dataArray = null;
                        int dataOffset = 0;
                        ByteArrayData byteArrayData = ImplementConvert.byteArrayData;
                        synchronized (byteArrayData) {
                            num = pvdata.get(offset, len, ImplementConvert.byteArrayData);
                            dataArray = (byte[])ImplementConvert.byteArrayData.data;
                            dataOffset = ImplementConvert.byteArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    int num;
                    PVShortArray pvdata = (PVShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    int num;
                    PVIntArray pvdata = (PVIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    int num;
                    PVLongArray pvdata = (PVLongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset2 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset2];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    while (len > 0) {
                        int num = 0;
                        byte[] dataArray = null;
                        int dataOffset = 0;
                        ByteArrayData dataOffset2 = byteArrayData;
                        synchronized (dataOffset2) {
                            num = pvdata.get(offset, len, byteArrayData);
                            dataArray = (byte[])ImplementConvert.byteArrayData.data;
                            dataOffset = ImplementConvert.byteArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    int num;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    int num;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    int num;
                    PVULongArray pvdata = (PVULongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    int num;
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    FloatArrayData data = new FloatArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        float[] dataArray = (float[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    int num;
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    DoubleArrayData data = new DoubleArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        double[] dataArray = (double[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (byte)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvString: {
                    int num;
                    PVStringArray pvdata = (PVStringArray)pv;
                    StringArrayData data = new StringArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        String[] dataArray = (String[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.stringToByte(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromShortArray(PVScalarArray pv, int offset, int len, short[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from short[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    int n;
                    PVShortArray pvdata = (PVShortArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    int n;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        int value;
                        data[0] = value = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        short value = from[fromOffset];
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = String.valueOf(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromUShortArray(PVScalarArray pv, int offset, int len, short[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from short[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    int n;
                    PVShortArray pvdata = (PVShortArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        int value;
                        data[0] = value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        int value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    int n;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        int value;
                        data[0] = value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        int value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        int value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        int value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.ushortToString(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int convertToShortArray(PVScalarArray pv, int offset, int len, short[] to, int toOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert BooleanArray to short[]] not legal");
                }
                case pvByte: {
                    int num;
                    PVByteArray pvdata = (PVByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset2 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset2];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    while (len > 0) {
                        int num = 0;
                        short[] dataArray = null;
                        int dataOffset = 0;
                        ShortArrayData dataOffset2 = shortArrayData;
                        synchronized (dataOffset2) {
                            num = pvdata.get(offset, len, shortArrayData);
                            dataArray = (short[])ImplementConvert.shortArrayData.data;
                            dataOffset = ImplementConvert.shortArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    int num;
                    PVIntArray pvdata = (PVIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (short)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    int num;
                    PVLongArray pvdata = (PVLongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (short)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    int num;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset3 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            byte val = dataArray[i + dataOffset3];
                            short value = val;
                            if (val < 0) {
                                value = (short)(value & 0xFF);
                            }
                            to[i + toOffset] = value;
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    while (len > 0) {
                        int num = 0;
                        short[] dataArray = null;
                        int dataOffset = 0;
                        ShortArrayData dataOffset3 = shortArrayData;
                        synchronized (dataOffset3) {
                            num = pvdata.get(offset, len, shortArrayData);
                            dataArray = (short[])ImplementConvert.shortArrayData.data;
                            dataOffset = ImplementConvert.shortArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    int num;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (short)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    int num;
                    PVULongArray pvdata = (PVULongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (short)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    int num;
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    FloatArrayData data = new FloatArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        float[] dataArray = (float[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (short)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    int num;
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    DoubleArrayData data = new DoubleArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        double[] dataArray = (double[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (short)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvString: {
                    int num;
                    PVStringArray pvdata = (PVStringArray)pv;
                    StringArrayData data = new StringArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        String[] dataArray = (String[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.stringToShort(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromIntArray(PVScalarArray pv, int offset, int len, int[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from int[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    int n;
                    PVIntArray pvdata = (PVIntArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    int n;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        long value;
                        data[0] = value = (long)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = String.valueOf(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromUIntArray(PVScalarArray pv, int offset, int len, int[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from int[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    int n;
                    PVIntArray pvdata = (PVIntArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        long value;
                        data[0] = value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    int n;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        long value;
                        data[0] = value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        long value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        long value = ImplementConvert.widenUnsigned(from[fromOffset]);
                        data[0] = value;
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.uintToString(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int convertToIntArray(PVScalarArray pv, int offset, int len, int[] to, int toOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert BooleanArray to int[]] not legal");
                }
                case pvByte: {
                    int num;
                    PVByteArray pvdata = (PVByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    int num;
                    PVShortArray pvdata = (PVShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset2 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset2];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    while (len > 0) {
                        int num = 0;
                        int[] dataArray = null;
                        int dataOffset = 0;
                        IntArrayData dataOffset2 = intArrayData;
                        synchronized (dataOffset2) {
                            num = pvdata.get(offset, len, intArrayData);
                            dataArray = (int[])ImplementConvert.intArrayData.data;
                            dataOffset = ImplementConvert.intArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    int num;
                    PVLongArray pvdata = (PVLongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (int)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    int num;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            byte val = dataArray[i + dataOffset];
                            short value = val;
                            if (val < 0) {
                                value = (short)(value & 0xFF);
                            }
                            to[i + toOffset] = value;
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    int num;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset3 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            int val;
                            int value = val = dataArray[i + dataOffset3];
                            if (val < 0) {
                                value &= 0xFFFF;
                            }
                            to[i + toOffset] = value;
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    while (len > 0) {
                        int num = 0;
                        int[] dataArray = null;
                        int dataOffset = 0;
                        IntArrayData dataOffset3 = intArrayData;
                        synchronized (dataOffset3) {
                            num = pvdata.get(offset, len, intArrayData);
                            dataArray = (int[])ImplementConvert.intArrayData.data;
                            dataOffset = ImplementConvert.intArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    int num;
                    PVULongArray pvdata = (PVULongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (int)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    int num;
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    FloatArrayData data = new FloatArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        float[] dataArray = (float[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (int)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    int num;
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    DoubleArrayData data = new DoubleArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        double[] dataArray = (double[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (int)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvString: {
                    int num;
                    PVStringArray pvdata = (PVStringArray)pv;
                    StringArrayData data = new StringArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        String[] dataArray = (String[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.stringToInt(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromLongArray(PVScalarArray pv, int offset, int len, long[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from long[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = (int)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    int n;
                    PVLongArray pvdata = (PVLongArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = (int)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    int n;
                    PVULongArray pvdata = (PVULongArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = String.valueOf(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromULongArray(PVScalarArray pv, int offset, int len, long[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from long[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = (int)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    int n;
                    PVLongArray pvdata = (PVLongArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = (int)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    int n;
                    PVULongArray pvdata = (PVULongArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        float value;
                        data[0] = value = ImplementConvert.ulongToFloat(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        double value;
                        data[0] = value = ImplementConvert.ulongToDouble(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.ulongToString(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int convertToLongArray(PVScalarArray pv, int offset, int len, long[] to, int toOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert BooleanArray to long[]] not legal");
                }
                case pvByte: {
                    int num;
                    PVByteArray pvdata = (PVByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    int num;
                    PVShortArray pvdata = (PVShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    int num;
                    PVIntArray pvdata = (PVIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset2 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset2];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    while (len > 0) {
                        int num = 0;
                        long[] dataArray = null;
                        int dataOffset = 0;
                        LongArrayData dataOffset2 = longArrayData;
                        synchronized (dataOffset2) {
                            num = pvdata.get(offset, len, longArrayData);
                            dataArray = (long[])ImplementConvert.longArrayData.data;
                            dataOffset = ImplementConvert.longArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    int num;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            byte val = dataArray[i + dataOffset];
                            short value = val;
                            if (val < 0) {
                                value = (short)(value & 0xFF);
                            }
                            to[i + toOffset] = value;
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    int num;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            int val;
                            int value = val = dataArray[i + dataOffset];
                            if (val < 0) {
                                value &= 0xFFFF;
                            }
                            to[i + toOffset] = value;
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    int num;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset3 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            int val = dataArray[i + dataOffset3];
                            long value = val;
                            if (val < 0) {
                                value &= 0xFFFFFFFFL;
                            }
                            to[i + toOffset] = value;
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    while (len > 0) {
                        int num = 0;
                        long[] dataArray = null;
                        int dataOffset = 0;
                        LongArrayData dataOffset3 = longArrayData;
                        synchronized (dataOffset3) {
                            num = pvdata.get(offset, len, longArrayData);
                            dataArray = (long[])ImplementConvert.longArrayData.data;
                            dataOffset = ImplementConvert.longArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    int num;
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    FloatArrayData data = new FloatArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        float[] dataArray = (float[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (long)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    int num;
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    DoubleArrayData data = new DoubleArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        double[] dataArray = (double[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (long)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvString: {
                    int num;
                    PVStringArray pvdata = (PVStringArray)pv;
                    StringArrayData data = new StringArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        String[] dataArray = (String[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.stringToLong(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromFloatArray(PVScalarArray pv, int offset, int len, float[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from float[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = (int)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        data[0] = (long)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.floatToUByte(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.floatToUShort(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.floatToUInt(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.floatToULong(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    int n;
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        data[0] = from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.doubleToString(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int convertToFloatArray(PVScalarArray pv, int offset, int len, float[] to, int toOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert BooleanArray to float[]] not legal");
                }
                case pvByte: {
                    int num;
                    PVByteArray pvdata = (PVByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    int num;
                    PVShortArray pvdata = (PVShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    int num;
                    PVIntArray pvdata = (PVIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    int num;
                    PVLongArray pvdata = (PVLongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    int num;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.widenUnsigned(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    int num;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.widenUnsigned(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    int num;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.widenUnsigned(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    int num;
                    PVULongArray pvdata = (PVULongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset2 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.ulongToFloat(dataArray[i + dataOffset2]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    while (len > 0) {
                        int num = 0;
                        float[] dataArray = null;
                        int dataOffset = 0;
                        FloatArrayData dataOffset2 = floatArrayData;
                        synchronized (dataOffset2) {
                            num = pvdata.get(offset, len, floatArrayData);
                            dataArray = (float[])ImplementConvert.floatArrayData.data;
                            dataOffset = ImplementConvert.floatArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    int num;
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    DoubleArrayData data = new DoubleArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        double[] dataArray = (double[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = (float)dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvString: {
                    int num;
                    PVStringArray pvdata = (PVStringArray)pv;
                    StringArrayData data = new StringArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        String[] dataArray = (String[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = Float.valueOf(dataArray[i + dataOffset]).floatValue();
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private int convertFromDoubleArray(PVScalarArray pv, int offset, int len, double[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert from double[] to BooleanArray not legal");
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = (byte)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = (short)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = (int)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        data[0] = (long)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.doubleToUByte(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.doubleToUShort(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.doubleToUInt(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.doubleToULong(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        data[0] = (float)from[fromOffset];
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    int n;
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    String[] data = new String[1];
                    while (len > 0) {
                        data[0] = ImplementConvert.doubleToString(from[fromOffset]);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int convertToDoubleArray(PVScalarArray pv, int offset, int len, double[] to, int toOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    throw new IllegalArgumentException("convert BooleanArray to double[]] not legal");
                }
                case pvByte: {
                    int num;
                    PVByteArray pvdata = (PVByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    int num;
                    PVShortArray pvdata = (PVShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    int num;
                    PVIntArray pvdata = (PVIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    int num;
                    PVLongArray pvdata = (PVLongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    int num;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        byte[] dataArray = (byte[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.widenUnsigned(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    int num;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        short[] dataArray = (short[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.widenUnsigned(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    int num;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        int[] dataArray = (int[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.widenUnsigned(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    int num;
                    PVULongArray pvdata = (PVULongArray)pv;
                    LongArrayData data = new LongArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        long[] dataArray = (long[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.ulongToDouble(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    int num;
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    FloatArrayData data = new FloatArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        float[] dataArray = (float[])data.data;
                        int dataOffset2 = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = dataArray[i + dataOffset2];
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    while (len > 0) {
                        int num = 0;
                        double[] dataArray = null;
                        int dataOffset = 0;
                        DoubleArrayData dataOffset2 = doubleArrayData;
                        synchronized (dataOffset2) {
                            num = pvdata.get(offset, len, doubleArrayData);
                            dataArray = (double[])ImplementConvert.doubleArrayData.data;
                            dataOffset = ImplementConvert.doubleArrayData.offset;
                        }
                        if (num <= 0) break;
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
                case pvString: {
                    int num;
                    PVStringArray pvdata = (PVStringArray)pv;
                    StringArrayData data = new StringArrayData();
                    while (len > 0 && (num = pvdata.get(offset, len, data)) != 0) {
                        String[] dataArray = (String[])data.data;
                        int dataOffset = data.offset;
                        for (int i = 0; i < num; ++i) {
                            to[i + toOffset] = ImplementConvert.stringToFloat(dataArray[i + dataOffset]);
                        }
                        len -= num;
                        offset += num;
                        toOffset += num;
                        ntransfered += num;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        private String removeWhiteSpace(String start) {
            int length = start.length();
            if (length < 1) {
                return start;
            }
            if (!Character.isWhitespace(start.charAt(0)) && !Character.isWhitespace(start.charAt(length - 1))) {
                return start;
            }
            StringBuilder builder = new StringBuilder(start);
            int lastWhite = -1;
            int i = 0;
            while (i < length && Character.isWhitespace(start.charAt(i))) {
                lastWhite = i++;
            }
            if (lastWhite >= 0) {
                builder.delete(0, lastWhite + 1);
                length -= lastWhite + 1;
            }
            int firstWhite = builder.length();
            int i2 = firstWhite - 1;
            while (i2 >= 0 && Character.isWhitespace(builder.charAt(i2))) {
                firstWhite = i2--;
            }
            if (firstWhite < length) {
                builder.setLength(firstWhite);
            }
            return builder.toString();
        }

        private int convertFromStringArray(PVScalarArray pv, int offset, int len, String[] from, int fromOffset) {
            ScalarType elemType = pv.getScalarArray().getElementType();
            int ntransfered = 0;
            switch (elemType) {
                case pvBoolean: {
                    PVBooleanArray pvdata = (PVBooleanArray)pv;
                    boolean[] data = new boolean[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = Boolean.parseBoolean(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToByte(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToShort(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToInt(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToLong(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    byte[] data = new byte[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToUByte(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    short[] data = new short[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToUShort(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    int[] data = new int[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToInt(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    long[] data = new long[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = ImplementConvert.stringToULong(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    float[] data = new float[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = Float.valueOf(fromString).floatValue();
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    double[] data = new double[1];
                    while (len > 0) {
                        String fromString = this.removeWhiteSpace(from[fromOffset]);
                        data[0] = Double.valueOf(fromString);
                        if (pvdata.put(offset, 1, data, 0) == 0) {
                            return ntransfered;
                        }
                        --len;
                        ++ntransfered;
                        ++offset;
                        ++fromOffset;
                    }
                    return ntransfered;
                }
                case pvString: {
                    int n;
                    PVStringArray pvdata = (PVStringArray)pv;
                    while (len > 0 && (n = pvdata.put(offset, len, from, fromOffset)) != 0) {
                        len -= n;
                        offset += n;
                        fromOffset += n;
                        ntransfered += n;
                    }
                    return ntransfered;
                }
            }
            throw new IllegalStateException("Logic error. Should never get here");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int convertToStringArray(PVScalarArray pv, int offset, int len, String[] to, int toOffset) {
            ScalarType elementType = pv.getScalarArray().getElementType();
            int ncopy = pv.getLength();
            if (ncopy > len) {
                ncopy = len;
            }
            int num = ncopy;
            block2 : switch (elementType) {
                case pvBoolean: {
                    PVBooleanArray pvdata = (PVBooleanArray)pv;
                    BooleanArrayData data = new BooleanArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? Boolean.toString(((boolean[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvByte: {
                    PVByteArray pvdata = (PVByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.byteToString(((byte[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvShort: {
                    PVShortArray pvdata = (PVShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.shortToString(((short[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvInt: {
                    PVIntArray pvdata = (PVIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.intToString(((int[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvLong: {
                    PVLongArray pvdata = (PVLongArray)pv;
                    LongArrayData data = new LongArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.longToString(((long[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvUByte: {
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    ByteArrayData data = new ByteArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.ubyteToString(((byte[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvUShort: {
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    ShortArrayData data = new ShortArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.ushortToString(((short[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvUInt: {
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    IntArrayData data = new IntArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.uintToString(((int[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvULong: {
                    PVULongArray pvdata = (PVULongArray)pv;
                    LongArrayData data = new LongArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.ulongToString(((long[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvFloat: {
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    FloatArrayData data = new FloatArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.floatToString(((float[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvDouble: {
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    DoubleArrayData data = new DoubleArrayData();
                    for (int i = 0; i < num; ++i) {
                        to[toOffset + i] = pvdata.get(offset + i, 1, data) == 1 ? ImplementConvert.doubleToString(((double[])data.data)[data.offset]) : "bad pv";
                    }
                    break;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    while (num > 0) {
                        int numnow = 0;
                        String[] dataArray = null;
                        int dataOffset = 0;
                        StringArrayData stringArrayData = ImplementConvert.stringArrayData;
                        synchronized (stringArrayData) {
                            numnow = pvdata.get(offset, num, ImplementConvert.stringArrayData);
                            dataArray = (String[])ImplementConvert.stringArrayData.data;
                            dataOffset = ImplementConvert.stringArrayData.offset;
                        }
                        if (numnow <= 0) {
                            for (int i = 0; i < num; ++i) {
                                to[toOffset + i] = "bad pv";
                            }
                            break block2;
                        }
                        System.arraycopy(dataArray, dataOffset, to, toOffset, num);
                        num -= numnow;
                        offset += numnow;
                        toOffset += numnow;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal ScalarType. Must be scalar but it is " + elementType.toString());
                }
            }
            return ncopy;
        }

        @Override
        public void newLine(StringBuilder builder, int indentLevel) {
            builder.append(String.format("%n", new Object[0]));
            for (int i = 0; i < indentLevel; ++i) {
                builder.append(indentString);
            }
        }

        private void convertToString(StringBuilder builder, PVField pv, int indentLevel) {
            Type type = pv.getField().getType();
            if (type == Type.scalarArray) {
                this.convertArray(builder, (PVScalarArray)pv, indentLevel);
                return;
            }
            if (type == Type.structure) {
                this.convertStructure(builder, (PVStructure)pv, indentLevel);
                return;
            }
            if (type == Type.structureArray) {
                this.convertStructureArray(builder, (PVStructureArray)pv, indentLevel);
                return;
            }
            if (type == Type.union) {
                this.convertUnion(builder, (PVUnion)pv, indentLevel);
                return;
            }
            if (type == Type.unionArray) {
                this.convertUnionArray(builder, (PVUnionArray)pv, indentLevel);
                return;
            }
            PVScalar pvScalar = (PVScalar)pv;
            Scalar scalar = pvScalar.getScalar();
            ScalarType scalarType = scalar.getScalarType();
            builder.append(scalar.getID() + " " + pv.getFieldName());
            builder.append(" ");
            switch (scalarType) {
                case pvBoolean: {
                    PVBoolean data = (PVBoolean)pv;
                    boolean value = data.get();
                    if (value) {
                        builder.append("true");
                        return;
                    }
                    builder.append("false");
                    return;
                }
                case pvByte: {
                    PVByte data = (PVByte)pv;
                    builder.append(data.get());
                    return;
                }
                case pvShort: {
                    PVShort data = (PVShort)pv;
                    builder.append(data.get());
                    return;
                }
                case pvInt: {
                    PVInt data = (PVInt)pv;
                    builder.append(data.get());
                    return;
                }
                case pvLong: {
                    PVLong data = (PVLong)pv;
                    builder.append(data.get());
                    return;
                }
                case pvUByte: {
                    PVUByte data = (PVUByte)pv;
                    byte val = data.get();
                    short value = ImplementConvert.widenUnsigned(val);
                    builder.append(value);
                    return;
                }
                case pvUShort: {
                    PVUShort data = (PVUShort)pv;
                    short val = data.get();
                    int value = ImplementConvert.widenUnsigned(val);
                    builder.append(value);
                    return;
                }
                case pvUInt: {
                    PVUInt data = (PVUInt)pv;
                    int val = data.get();
                    long value = ImplementConvert.widenUnsigned(val);
                    builder.append(value);
                    return;
                }
                case pvULong: {
                    PVULong data = (PVULong)pv;
                    long val = data.get();
                    builder.append(ImplementConvert.ulongToString(val));
                    return;
                }
                case pvFloat: {
                    PVFloat data = (PVFloat)pv;
                    builder.append(ImplementConvert.floatToString(data.get()));
                    return;
                }
                case pvDouble: {
                    PVDouble data = (PVDouble)pv;
                    builder.append(ImplementConvert.doubleToString(data.get()));
                    return;
                }
                case pvString: {
                    PVString data = (PVString)pv;
                    builder.append(data.get());
                    return;
                }
            }
            builder.append("unknown ScalarType");
        }

        private void convertStructure(StringBuilder buffer, PVStructure data, int indentLevel) {
            String id = data.getStructure().getID();
            if (!id.isEmpty()) {
                buffer.append(id).append(' ');
            }
            buffer.append(data.getFieldName());
            PVField[] fieldsData = data.getPVFields();
            if (fieldsData != null) {
                int length = fieldsData.length;
                for (int i = 0; i < length; ++i) {
                    this.newLine(buffer, indentLevel + 1);
                    PVField fieldField = fieldsData[i];
                    fieldField.toString(buffer, indentLevel + 1);
                }
            }
        }

        private void convertUnion(StringBuilder buffer, PVUnion data, int indentLevel) {
            String id = data.getUnion().getID();
            if (!id.isEmpty()) {
                buffer.append(id).append(' ');
            }
            buffer.append(data.getFieldName());
            this.newLine(buffer, indentLevel + 1);
            PVField fieldField = data.get();
            if (fieldField == null) {
                buffer.append("(no data)");
            } else {
                fieldField.toString(buffer, indentLevel + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void convertArray(StringBuilder builder, PVScalarArray pv, int indentLevel) {
            ScalarArray array = pv.getScalarArray();
            ScalarType type = array.getElementType();
            builder.append(array.getID() + " " + pv.getFieldName() + " ");
            switch (type) {
                case pvBoolean: {
                    int num;
                    PVBooleanArray pvdata = (PVBooleanArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        boolean[] data = null;
                        int fromOffset = 0;
                        BooleanArrayData booleanArrayData = ImplementConvert.booleanArrayData;
                        synchronized (booleanArrayData) {
                            num = pvdata.get(offset, len, ImplementConvert.booleanArrayData);
                            data = (boolean[])ImplementConvert.booleanArrayData.data;
                            fromOffset = ImplementConvert.booleanArrayData.offset;
                        }
                        for (int i = 0; i < num; ++i) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            builder.append(data[i + fromOffset] ? "true" : "false");
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvByte: {
                    int num;
                    PVByteArray pvdata = (PVByteArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        byte[] data = null;
                        int fromOffset = 0;
                        ByteArrayData i = byteArrayData;
                        synchronized (i) {
                            num = pvdata.get(offset, len, byteArrayData);
                            data = (byte[])ImplementConvert.byteArrayData.data;
                            fromOffset = ImplementConvert.byteArrayData.offset;
                        }
                        for (int i2 = 0; i2 < num; ++i2) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            builder.append(data[i2 + fromOffset]);
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvShort: {
                    int num;
                    PVShortArray pvdata = (PVShortArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        short[] data = null;
                        int fromOffset = 0;
                        ShortArrayData i2 = shortArrayData;
                        synchronized (i2) {
                            num = pvdata.get(offset, len, shortArrayData);
                            data = (short[])ImplementConvert.shortArrayData.data;
                            fromOffset = ImplementConvert.shortArrayData.offset;
                        }
                        for (int i = 0; i < num; ++i) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            builder.append(data[i + fromOffset]);
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvInt: {
                    int num;
                    PVIntArray pvdata = (PVIntArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        int[] data = null;
                        int fromOffset = 0;
                        IntArrayData i = intArrayData;
                        synchronized (i) {
                            num = pvdata.get(offset, len, intArrayData);
                            data = (int[])ImplementConvert.intArrayData.data;
                            fromOffset = ImplementConvert.intArrayData.offset;
                        }
                        for (int i3 = 0; i3 < num; ++i3) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            builder.append(data[i3 + fromOffset]);
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvLong: {
                    int num;
                    PVLongArray pvdata = (PVLongArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        long[] data = null;
                        int fromOffset = 0;
                        LongArrayData i3 = longArrayData;
                        synchronized (i3) {
                            num = pvdata.get(offset, len, longArrayData);
                            data = (long[])ImplementConvert.longArrayData.data;
                            fromOffset = ImplementConvert.longArrayData.offset;
                        }
                        for (int i = 0; i < num; ++i) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            builder.append(data[i + fromOffset]);
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvUByte: {
                    int num;
                    PVUByteArray pvdata = (PVUByteArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        byte[] data = null;
                        int fromOffset = 0;
                        ByteArrayData i = byteArrayData;
                        synchronized (i) {
                            num = pvdata.get(offset, len, byteArrayData);
                            data = (byte[])ImplementConvert.byteArrayData.data;
                            fromOffset = ImplementConvert.byteArrayData.offset;
                        }
                        for (int i4 = 0; i4 < num; ++i4) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            byte val = data[i4 + fromOffset];
                            builder.append(ImplementConvert.widenUnsigned(val));
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvUShort: {
                    int num;
                    PVUShortArray pvdata = (PVUShortArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        short[] data = null;
                        int fromOffset = 0;
                        ShortArrayData i4 = shortArrayData;
                        synchronized (i4) {
                            num = pvdata.get(offset, len, shortArrayData);
                            data = (short[])ImplementConvert.shortArrayData.data;
                            fromOffset = ImplementConvert.shortArrayData.offset;
                        }
                        for (int i = 0; i < num; ++i) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            short val = data[i + fromOffset];
                            builder.append(ImplementConvert.widenUnsigned(val));
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvUInt: {
                    int num;
                    PVUIntArray pvdata = (PVUIntArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        int[] data = null;
                        int fromOffset = 0;
                        IntArrayData i = intArrayData;
                        synchronized (i) {
                            num = pvdata.get(offset, len, intArrayData);
                            data = (int[])ImplementConvert.intArrayData.data;
                            fromOffset = ImplementConvert.intArrayData.offset;
                        }
                        for (int i5 = 0; i5 < num; ++i5) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            int val = data[i5 + fromOffset];
                            builder.append(ImplementConvert.widenUnsigned(val));
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvULong: {
                    int num;
                    PVULongArray pvdata = (PVULongArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        long[] data = null;
                        int fromOffset = 0;
                        LongArrayData i5 = longArrayData;
                        synchronized (i5) {
                            num = pvdata.get(offset, len, longArrayData);
                            data = (long[])ImplementConvert.longArrayData.data;
                            fromOffset = ImplementConvert.longArrayData.offset;
                        }
                        for (int i = 0; i < num; ++i) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            long val = data[i + fromOffset];
                            builder.append(ImplementConvert.ulongToString(val));
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvFloat: {
                    int num;
                    PVFloatArray pvdata = (PVFloatArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        float[] data = null;
                        int fromOffset = 0;
                        FloatArrayData i = floatArrayData;
                        synchronized (i) {
                            num = pvdata.get(offset, len, floatArrayData);
                            data = (float[])ImplementConvert.floatArrayData.data;
                            fromOffset = ImplementConvert.floatArrayData.offset;
                        }
                        for (int i6 = 0; i6 < num; ++i6) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            float val = data[i6 + fromOffset];
                            builder.append(ImplementConvert.floatToString(val));
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvDouble: {
                    int num;
                    PVDoubleArray pvdata = (PVDoubleArray)pv;
                    builder.append("[");
                    int offset = 0;
                    boolean firstElement = true;
                    for (int len = pvdata.getLength(); len > 0; len -= num) {
                        num = 0;
                        double[] data = null;
                        int fromOffset = 0;
                        DoubleArrayData i6 = doubleArrayData;
                        synchronized (i6) {
                            num = pvdata.get(offset, len, doubleArrayData);
                            data = (double[])ImplementConvert.doubleArrayData.data;
                            fromOffset = ImplementConvert.doubleArrayData.offset;
                        }
                        for (int i = 0; i < num; ++i) {
                            if (!firstElement) {
                                builder.append(',');
                            } else {
                                firstElement = false;
                            }
                            double val = data[i + fromOffset];
                            builder.append(ImplementConvert.doubleToString(val));
                        }
                    }
                    builder.append("]");
                    break;
                }
                case pvString: {
                    PVStringArray pvdata = (PVStringArray)pv;
                    StringArrayData data = new StringArrayData();
                    builder.append("[");
                    for (int i = 0; i < pvdata.getLength(); ++i) {
                        if (i != 0) {
                            builder.append(",");
                        }
                        int num = pvdata.get(i, 1, data);
                        String[] value = (String[])data.data;
                        if (num == 1 && value[data.offset] != null) {
                            builder.append(value[data.offset]);
                            continue;
                        }
                        builder.append("null");
                    }
                    builder.append("]");
                    break;
                }
                default: {
                    builder.append(" array element is unknown ScalarType");
                }
            }
            if (pv.isImmutable()) {
                builder.append(" immutable ");
            }
        }

        private void convertStructureArray(StringBuilder builder, PVStructureArray pvdata, int indentLevel) {
            builder.append(pvdata.getStructureArray().getID() + " " + pvdata.getFieldName() + " ");
            int length = pvdata.getLength();
            if (length <= 0) {
                return;
            }
            StructureArrayData data = new StructureArrayData();
            pvdata.get(0, pvdata.getLength(), data);
            for (int i = 0; i < pvdata.getLength(); ++i) {
                this.newLine(builder, indentLevel + 1);
                PVStructure pvStructure = ((PVStructure[])data.data)[i];
                if (pvStructure == null) {
                    builder.append("null");
                    continue;
                }
                pvStructure.toString(builder, indentLevel + 1);
            }
        }

        private void convertUnionArray(StringBuilder builder, PVUnionArray pvdata, int indentLevel) {
            builder.append(pvdata.getUnionArray().getID() + " " + pvdata.getFieldName() + " ");
            int length = pvdata.getLength();
            if (length <= 0) {
                return;
            }
            UnionArrayData data = new UnionArrayData();
            pvdata.get(0, pvdata.getLength(), data);
            for (int i = 0; i < pvdata.getLength(); ++i) {
                this.newLine(builder, indentLevel + 1);
                PVUnion pvUnion = ((PVUnion[])data.data)[i];
                if (pvUnion == null) {
                    builder.append("null");
                    continue;
                }
                pvUnion.toString(builder, indentLevel + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int copyArrayDataReference(PVScalarArray from, PVArray to) {
            ScalarType scalarType = from.getScalarArray().getElementType();
            switch (scalarType) {
                case pvBoolean: {
                    PVBooleanArray pvfrom = (PVBooleanArray)from;
                    PVBooleanArray pvto = (PVBooleanArray)to;
                    boolean[] booleanArray = null;
                    BooleanArrayData booleanArrayData = ImplementConvert.booleanArrayData;
                    synchronized (booleanArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.booleanArrayData);
                        booleanArray = (boolean[])ImplementConvert.booleanArrayData.data;
                    }
                    pvto.shareData(booleanArray);
                    break;
                }
                case pvByte: {
                    PVByteArray pvfrom = (PVByteArray)from;
                    PVByteArray pvto = (PVByteArray)to;
                    byte[] byteArray = null;
                    ByteArrayData byteArrayData = ImplementConvert.byteArrayData;
                    synchronized (byteArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.byteArrayData);
                        byteArray = (byte[])ImplementConvert.byteArrayData.data;
                    }
                    pvto.shareData(byteArray);
                    break;
                }
                case pvShort: {
                    PVShortArray pvfrom = (PVShortArray)from;
                    PVShortArray pvto = (PVShortArray)to;
                    short[] shortArray = null;
                    ShortArrayData shortArrayData = ImplementConvert.shortArrayData;
                    synchronized (shortArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.shortArrayData);
                        shortArray = (short[])ImplementConvert.shortArrayData.data;
                    }
                    pvto.shareData(shortArray);
                    break;
                }
                case pvInt: {
                    PVIntArray pvfrom = (PVIntArray)from;
                    PVIntArray pvto = (PVIntArray)to;
                    int[] intArray = null;
                    IntArrayData intArrayData = ImplementConvert.intArrayData;
                    synchronized (intArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.intArrayData);
                        intArray = (int[])ImplementConvert.intArrayData.data;
                    }
                    pvto.shareData(intArray);
                    break;
                }
                case pvLong: {
                    PVLongArray pvfrom = (PVLongArray)from;
                    PVLongArray pvto = (PVLongArray)to;
                    long[] longArray = null;
                    LongArrayData longArrayData = ImplementConvert.longArrayData;
                    synchronized (longArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.longArrayData);
                        longArray = (long[])ImplementConvert.longArrayData.data;
                    }
                    pvto.shareData(longArray);
                    break;
                }
                case pvUByte: {
                    PVUByteArray pvfrom = (PVUByteArray)from;
                    PVUByteArray pvto = (PVUByteArray)to;
                    byte[] byteArray = null;
                    ByteArrayData byteArrayData = ImplementConvert.byteArrayData;
                    synchronized (byteArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.byteArrayData);
                        byteArray = (byte[])ImplementConvert.byteArrayData.data;
                    }
                    pvto.shareData(byteArray);
                    break;
                }
                case pvUShort: {
                    PVUShortArray pvfrom = (PVUShortArray)from;
                    PVUShortArray pvto = (PVUShortArray)to;
                    short[] shortArray = null;
                    ShortArrayData shortArrayData = ImplementConvert.shortArrayData;
                    synchronized (shortArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.shortArrayData);
                        shortArray = (short[])ImplementConvert.shortArrayData.data;
                    }
                    pvto.shareData(shortArray);
                    break;
                }
                case pvUInt: {
                    PVUIntArray pvfrom = (PVUIntArray)from;
                    PVUIntArray pvto = (PVUIntArray)to;
                    int[] intArray = null;
                    IntArrayData intArrayData = ImplementConvert.intArrayData;
                    synchronized (intArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.intArrayData);
                        intArray = (int[])ImplementConvert.intArrayData.data;
                    }
                    pvto.shareData(intArray);
                    break;
                }
                case pvULong: {
                    PVULongArray pvfrom = (PVULongArray)from;
                    PVULongArray pvto = (PVULongArray)to;
                    long[] longArray = null;
                    LongArrayData longArrayData = ImplementConvert.longArrayData;
                    synchronized (longArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.longArrayData);
                        longArray = (long[])ImplementConvert.longArrayData.data;
                    }
                    pvto.shareData(longArray);
                    break;
                }
                case pvFloat: {
                    PVFloatArray pvfrom = (PVFloatArray)from;
                    PVFloatArray pvto = (PVFloatArray)to;
                    float[] floatArray = null;
                    FloatArrayData floatArrayData = ImplementConvert.floatArrayData;
                    synchronized (floatArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.floatArrayData);
                        floatArray = (float[])ImplementConvert.floatArrayData.data;
                    }
                    pvto.shareData(floatArray);
                    break;
                }
                case pvDouble: {
                    PVDoubleArray pvfrom = (PVDoubleArray)from;
                    PVDoubleArray pvto = (PVDoubleArray)to;
                    double[] doubleArray = null;
                    DoubleArrayData doubleArrayData = ImplementConvert.doubleArrayData;
                    synchronized (doubleArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.doubleArrayData);
                        doubleArray = (double[])ImplementConvert.doubleArrayData.data;
                    }
                    pvto.shareData(doubleArray);
                    break;
                }
                case pvString: {
                    PVStringArray pvfrom = (PVStringArray)from;
                    PVStringArray pvto = (PVStringArray)to;
                    String[] stringArray = null;
                    StringArrayData stringArrayData = ImplementConvert.stringArrayData;
                    synchronized (stringArrayData) {
                        pvfrom.get(0, pvfrom.getLength(), ImplementConvert.stringArrayData);
                        stringArray = (String[])ImplementConvert.stringArrayData.data;
                    }
                    pvto.shareData(stringArray);
                    break;
                }
            }
            to.setImmutable();
            return from.getLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int copyNumericArray(PVScalarArray from, int offset, PVScalarArray to, int toOffset, int len) {
            ScalarType fromElementType = from.getScalarArray().getElementType();
            int ncopy = 0;
            block20 : switch (fromElementType) {
                case pvBoolean: {
                    throw new NumberFormatException("copyNumericArray not valid for element type pvBoolean");
                }
                case pvString: {
                    throw new NumberFormatException("copyNumericArray not valid for element type pvString");
                }
                case pvByte: {
                    PVByteArray pvfrom = (PVByteArray)from;
                    while (len > 0) {
                        int n;
                        int num = 0;
                        byte[] data = null;
                        int dataOffset = 0;
                        ByteArrayData byteArrayData = ImplementConvert.byteArrayData;
                        synchronized (byteArrayData) {
                            num = pvfrom.get(offset, len, ImplementConvert.byteArrayData);
                            data = (byte[])ImplementConvert.byteArrayData.data;
                            dataOffset = ImplementConvert.byteArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromByteArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvShort: {
                    PVShortArray pvfrom = (PVShortArray)from;
                    while (len > 0) {
                        int num = 0;
                        short[] data = null;
                        int dataOffset = 0;
                        ShortArrayData n = shortArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, shortArrayData);
                            data = (short[])ImplementConvert.shortArrayData.data;
                            dataOffset = ImplementConvert.shortArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromShortArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvInt: {
                    PVIntArray pvfrom = (PVIntArray)from;
                    while (len > 0) {
                        int num = 0;
                        int[] data = null;
                        int dataOffset = 0;
                        IntArrayData n = intArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, intArrayData);
                            data = (int[])ImplementConvert.intArrayData.data;
                            dataOffset = ImplementConvert.intArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromIntArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvLong: {
                    PVLongArray pvfrom = (PVLongArray)from;
                    while (len > 0) {
                        int num = 0;
                        long[] data = null;
                        int dataOffset = 0;
                        LongArrayData n = longArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, longArrayData);
                            data = (long[])ImplementConvert.longArrayData.data;
                            dataOffset = ImplementConvert.longArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromLongArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvUByte: {
                    PVUByteArray pvfrom = (PVUByteArray)from;
                    while (len > 0) {
                        int num = 0;
                        byte[] data = null;
                        int dataOffset = 0;
                        ByteArrayData n = byteArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, byteArrayData);
                            data = (byte[])ImplementConvert.byteArrayData.data;
                            dataOffset = ImplementConvert.byteArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromUByteArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvUShort: {
                    PVUShortArray pvfrom = (PVUShortArray)from;
                    while (len > 0) {
                        int num = 0;
                        short[] data = null;
                        int dataOffset = 0;
                        ShortArrayData n = shortArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, shortArrayData);
                            data = (short[])ImplementConvert.shortArrayData.data;
                            dataOffset = ImplementConvert.shortArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromUShortArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvUInt: {
                    PVUIntArray pvfrom = (PVUIntArray)from;
                    while (len > 0) {
                        int num = 0;
                        int[] data = null;
                        int dataOffset = 0;
                        IntArrayData n = intArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, intArrayData);
                            data = (int[])ImplementConvert.intArrayData.data;
                            dataOffset = ImplementConvert.intArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromUIntArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvULong: {
                    PVULongArray pvfrom = (PVULongArray)from;
                    while (len > 0) {
                        int num = 0;
                        long[] data = null;
                        int dataOffset = 0;
                        LongArrayData n = longArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, longArrayData);
                            data = (long[])ImplementConvert.longArrayData.data;
                            dataOffset = ImplementConvert.longArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.convertFromULongArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvFloat: {
                    PVFloatArray pvfrom = (PVFloatArray)from;
                    while (len > 0) {
                        int num = 0;
                        float[] data = null;
                        int dataOffset = 0;
                        FloatArrayData n = floatArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, floatArrayData);
                            data = (float[])ImplementConvert.floatArrayData.data;
                            dataOffset = ImplementConvert.floatArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.fromFloatArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
                case pvDouble: {
                    PVDoubleArray pvfrom = (PVDoubleArray)from;
                    while (len > 0) {
                        int num = 0;
                        double[] data = null;
                        int dataOffset = 0;
                        DoubleArrayData n = doubleArrayData;
                        synchronized (n) {
                            num = pvfrom.get(offset, len, doubleArrayData);
                            data = (double[])ImplementConvert.doubleArrayData.data;
                            dataOffset = ImplementConvert.doubleArrayData.offset;
                        }
                        if (num <= 0) break block20;
                        while (num > 0 && (n = this.fromDoubleArray(to, toOffset, num, data, dataOffset)) > 0) {
                            len -= n;
                            num -= n;
                            ncopy += n;
                            offset += n;
                            toOffset += n;
                        }
                    }
                    break;
                }
            }
            return ncopy;
        }

        private static short widenUnsigned(byte rawValue) {
            short wide = rawValue;
            wide = (short)(wide & 0xFF);
            return wide;
        }

        private static int widenUnsigned(short rawValue) {
            int wide = rawValue;
            return wide &= 0xFFFF;
        }

        private static long widenUnsigned(int rawValue) {
            long wide = rawValue;
            return wide &= 0xFFFFFFFFL;
        }

        private static BigInteger widenUnsigned(long rawValue) {
            BigInteger wide = BigInteger.valueOf(rawValue);
            if (rawValue < 0L) {
                wide = wide.add(twoToTheSixtyFour);
            }
            return wide;
        }

        private static float ulongToFloat(long rawValue) {
            float val = rawValue;
            if (rawValue < 0L) {
                val = (float)((double)val + twoToTheSixtyFourReal);
            }
            return val;
        }

        private static double ulongToDouble(long rawValue) {
            double val = rawValue;
            if (rawValue < 0L) {
                val += twoToTheSixtyFourReal;
            }
            return val;
        }

        private static String byteToString(byte from) {
            return String.valueOf(from);
        }

        private static String shortToString(short from) {
            return String.valueOf(from);
        }

        private static String intToString(int from) {
            return String.valueOf(from);
        }

        private static String longToString(long from) {
            return String.valueOf(from);
        }

        private static String ubyteToString(byte from) {
            return String.valueOf(ImplementConvert.widenUnsigned(from));
        }

        private static String ushortToString(short from) {
            return String.valueOf(ImplementConvert.widenUnsigned(from));
        }

        private static String uintToString(int from) {
            return String.valueOf(ImplementConvert.widenUnsigned(from));
        }

        private static String ulongToString(long from) {
            if (from < 0L) {
                return ImplementConvert.widenUnsigned(from).toString();
            }
            return String.valueOf(from);
        }

        private static byte stringToByte(String from) {
            return (byte)ImplementConvert.convertToLong(from);
        }

        private static short stringToShort(String from) {
            return (short)ImplementConvert.convertToLong(from);
        }

        private static int stringToInt(String from) {
            return (int)ImplementConvert.convertToLong(from);
        }

        private static long stringToLong(String from) {
            return ImplementConvert.convertToLong(from);
        }

        private static byte stringToUByte(String from) {
            return (byte)ImplementConvert.convertToLong(from);
        }

        private static short stringToUShort(String from) {
            return (short)ImplementConvert.convertToLong(from);
        }

        private static int stringToUInt(String from) {
            return (int)ImplementConvert.convertToLong(from);
        }

        private static long stringToULong(String from) {
            return ImplementConvert.convertToLong(from);
        }

        private static float stringToFloat(String from) {
            return Float.valueOf(from).floatValue();
        }

        private static double stringToDouble(String from) {
            return Double.valueOf(from);
        }

        private static String floatToString(float from) {
            return String.valueOf(from);
        }

        private static String doubleToString(double from) {
            return String.valueOf(from);
        }

        private static long convertToLong(String from) {
            try {
                return Long.decode(from);
            }
            catch (NumberFormatException e) {
                try {
                    BigInteger big = new BigInteger(from);
                    return big.longValue();
                }
                catch (NumberFormatException e2) {
                    try {
                        BigInteger big = null;
                        String str = from;
                        boolean negative = false;
                        if (from.startsWith("-", 0)) {
                            negative = true;
                            str = from.substring(1);
                        }
                        if (str.startsWith("0x", 0) || str.startsWith("0X", 0)) {
                            str = str.substring(2);
                            big = new BigInteger(str, 16);
                        } else if (str.startsWith("#", 0)) {
                            str = str.substring(1);
                            big = new BigInteger(str, 16);
                        } else if (str.startsWith("o", 0)) {
                            str = str.substring(1);
                            big = new BigInteger(str, 8);
                        }
                        if (big != null) {
                            if (negative) {
                                big = big.negate();
                            }
                            return big.longValue();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    throw new NumberFormatException("For input string: " + from);
                }
            }
        }

        static byte floatToUByte(float f) {
            return (byte)ImplementConvert.floatToUInt(f);
        }

        static short floatToUShort(float f) {
            return (short)ImplementConvert.floatToUInt(f);
        }

        static int floatToUInt(float f) {
            if (f == Float.NaN || f == Float.NEGATIVE_INFINITY || f <= 0.0f) {
                return 0;
            }
            if (f == Float.POSITIVE_INFINITY || (double)f >= twoToTheThirtyTwoReal) {
                return -1;
            }
            if ((double)f >= twoToTheThirtyTwoReal / 2.0) {
                f = (float)((double)f - twoToTheThirtyTwoReal);
            }
            return (int)f;
        }

        static long floatToULong(float f) {
            if (f == Float.NaN || f == Float.NEGATIVE_INFINITY || f <= 0.0f) {
                return 0L;
            }
            if (f == Float.POSITIVE_INFINITY || (double)f >= twoToTheSixtyFourReal) {
                return -1L;
            }
            if ((double)f >= twoToTheSixtyFourReal / 2.0) {
                f = (float)((double)f - twoToTheSixtyFourReal);
            }
            return (long)f;
        }

        static byte doubleToUByte(double f) {
            return (byte)ImplementConvert.doubleToUInt(f);
        }

        static short doubleToUShort(double f) {
            return (short)ImplementConvert.doubleToUInt(f);
        }

        static int doubleToUInt(double f) {
            if (f == Double.NaN || f == Double.NEGATIVE_INFINITY || f <= 0.0) {
                return 0;
            }
            if (f == Double.POSITIVE_INFINITY || f >= twoToTheThirtyTwoReal) {
                return -1;
            }
            if (f >= twoToTheThirtyTwoReal / 2.0) {
                f -= twoToTheThirtyTwoReal;
            }
            return (int)f;
        }

        static long doubleToULong(double d) {
            if (d == Double.NaN || d == Double.NEGATIVE_INFINITY || d <= 0.0) {
                return 0L;
            }
            if (d == Double.POSITIVE_INFINITY || d >= twoToTheSixtyFourReal) {
                return -1L;
            }
            if (d >= twoToTheSixtyFourReal / 2.0) {
                d -= twoToTheSixtyFourReal;
            }
            return (long)d;
        }
    }
}

