/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import org.epics.pvdata.factory.PVDataFactory;
import org.epics.pvdata.factory.StandardFieldFactory;
import org.epics.pvdata.pv.PVDataCreate;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StandardField;
import org.epics.pvdata.pv.StandardPVField;
import org.epics.pvdata.pv.Structure;

public final class StandardPVFieldFactory {
    private static StandardPVFieldImpl impl = null;
    private static PVDataCreate pvDataCreate = PVDataFactory.getPVDataCreate();
    private static StandardField standardField = StandardFieldFactory.getStandardField();

    public static synchronized StandardPVField getStandardPVField() {
        if (impl == null) {
            impl = new StandardPVFieldImpl();
        }
        return impl;
    }

    private static final class StandardPVFieldImpl
    implements StandardPVField {
        StandardPVFieldImpl() {
        }

        @Override
        public PVStructure scalar(ScalarType scalarType, String properties) {
            Structure field = standardField.scalar(scalarType, properties);
            PVStructure pvStructure = pvDataCreate.createPVStructure(field);
            return pvStructure;
        }

        @Override
        public PVStructure scalarArray(ScalarType elementType, String properties) {
            Structure field = standardField.scalarArray(elementType, properties);
            PVStructure pvStructure = pvDataCreate.createPVStructure(field);
            return pvStructure;
        }

        @Override
        public PVStructure structureArray(Structure structure, String properties) {
            Structure field = standardField.structureArray(structure, properties);
            PVStructure pvStructure = pvDataCreate.createPVStructure(field);
            return pvStructure;
        }

        @Override
        public PVStructure enumerated(String[] choices) {
            Structure field = standardField.enumerated();
            PVStructure pvStructure = pvDataCreate.createPVStructure(field);
            PVScalarArray pvScalarArray = pvStructure.getScalarArrayField("choices", ScalarType.pvString);
            if (pvScalarArray == null) {
                throw new IllegalStateException("logic error");
            }
            PVStringArray pvChoices = (PVStringArray)pvScalarArray;
            pvChoices.put(0, choices.length, choices, 0);
            pvChoices.setImmutable();
            return pvStructure;
        }

        @Override
        public PVStructure enumerated(String[] choices, String properties) {
            Structure field = standardField.enumerated(properties);
            PVStructure pvStructure = pvDataCreate.createPVStructure(field);
            PVScalarArray pvScalarArray = pvStructure.getScalarArrayField("value.choices", ScalarType.pvString);
            if (pvScalarArray == null) {
                throw new IllegalStateException("logic error");
            }
            PVStringArray pvChoices = (PVStringArray)pvScalarArray;
            pvChoices.put(0, choices.length, choices, 0);
            pvChoices.setImmutable();
            return pvStructure;
        }
    }
}

