/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.factory;

import java.nio.ByteBuffer;
import org.epics.pvdata.misc.SerializeHelper;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.SerializableControl;
import org.epics.pvdata.pv.Status;
import org.epics.pvdata.pv.StatusCreate;

public final class StatusFactory {
    private static final StatusCreateImpl statusCreate = new StatusCreateImpl();
    public static String NEW_LINE = System.getProperty("line.separator");

    private StatusFactory() {
    }

    public static StatusCreate getStatusCreate() {
        return statusCreate;
    }

    private static final class StatusImpl
    implements Status {
        private Status.StatusType type;
        private String message;
        private String stackDump;

        StatusImpl(Status.StatusType type, String message, String stackDump) {
            this.type = type;
            this.message = message;
            this.stackDump = stackDump;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getStackDump() {
            return this.stackDump;
        }

        @Override
        public Status.StatusType getType() {
            return this.type;
        }

        @Override
        public boolean isOK() {
            return this.type == Status.StatusType.OK;
        }

        @Override
        public boolean isSuccess() {
            return this.type == Status.StatusType.OK || this.type == Status.StatusType.WARNING;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(30);
            buff.append("StatusImpl [type=").append((Object)this.type);
            if (this.message != null) {
                buff.append(", message=").append(this.message);
            }
            if (this.stackDump != null) {
                buff.append(", stackDump=").append(NEW_LINE).append(this.stackDump);
            }
            buff.append(']');
            return buff.toString();
        }

        @Override
        public void deserialize(ByteBuffer buffer, DeserializableControl control) {
            throw new RuntimeException("use StatusCreate.deserialize()");
        }

        @Override
        public void serialize(ByteBuffer buffer, SerializableControl flusher) {
            flusher.ensureBuffer(1);
            if (this == StatusFactory.getStatusCreate().getStatusOK()) {
                buffer.put((byte)-1);
            } else {
                buffer.put((byte)this.type.ordinal());
                SerializeHelper.serializeString(this.message, buffer, flusher);
                SerializeHelper.serializeString(this.stackDump, buffer, flusher);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.stackDump == null ? 0 : this.stackDump.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatusImpl other = (StatusImpl)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            if (this.stackDump == null ? other.stackDump != null : !this.stackDump.equals(other.stackDump)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }

    private static final class StatusCreateImpl
    implements StatusCreate {
        private static final StatusImpl okStatus = new StatusImpl(Status.StatusType.OK, null, null);

        private StatusCreateImpl() {
        }

        @Override
        public Status getStatusOK() {
            return okStatus;
        }

        @Override
        public Status createStatus(Status.StatusType type, String message, Throwable cause) {
            String stackDump = null;
            if (cause != null) {
                StringBuffer dump = new StringBuffer(256);
                dump.append(cause.toString()).append(NEW_LINE);
                StackTraceElement[] trace = cause.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    dump.append("\tat ").append(trace[i]).append(NEW_LINE);
                }
                Throwable ourCause = cause.getCause();
                if (ourCause != null) {
                    this.printStackTraceAsCause(dump, cause, ourCause);
                }
                stackDump = dump.toString();
            }
            return new StatusImpl(type, message, stackDump);
        }

        @Override
        public Status deserializeStatus(ByteBuffer buffer, DeserializableControl control) {
            control.ensureData(1);
            byte typeCode = buffer.get();
            if (typeCode == -1) {
                return okStatus;
            }
            String message = SerializeHelper.deserializeString(buffer, control);
            String stackDump = SerializeHelper.deserializeString(buffer, control);
            return new StatusImpl(Status.StatusType.values()[typeCode], message, stackDump);
        }

        private void printStackTraceAsCause(StringBuffer s, Throwable parent, Throwable cause) {
            Throwable ourCause;
            StackTraceElement[] trace = parent.getStackTrace();
            StackTraceElement[] causedTrace = cause.getStackTrace();
            int m = trace.length - 1;
            for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            s.append("Caused by: ").append(cause).append(NEW_LINE);
            for (int i = 0; i <= m; ++i) {
                s.append("\tat ").append(trace[i]).append(NEW_LINE);
            }
            if (framesInCommon != 0) {
                s.append("\t... ").append(framesInCommon).append(" more").append(NEW_LINE);
            }
            if ((ourCause = cause.getCause()) != null) {
                this.printStackTraceAsCause(s, cause, ourCause);
            }
        }
    }
}

