/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvdata.misc.Executor;
import org.epics.pvdata.misc.ExecutorNode;
import org.epics.pvdata.misc.LinkedList;
import org.epics.pvdata.misc.LinkedListCreate;
import org.epics.pvdata.misc.LinkedListNode;
import org.epics.pvdata.misc.RunnableReady;
import org.epics.pvdata.misc.ThreadCreate;
import org.epics.pvdata.misc.ThreadCreateFactory;
import org.epics.pvdata.misc.ThreadPriority;
import org.epics.pvdata.misc.ThreadReady;

public class ExecutorFactory {
    private static ThreadCreate threadCreate = ThreadCreateFactory.getThreadCreate();
    private static LinkedListCreate<ExecutorNodeImpl> linkedListCreate = new LinkedListCreate();

    public static Executor create(String threadName, ThreadPriority priority) {
        return new ExecutorInstance(threadName, priority);
    }

    private static class ExecutorNodeImpl
    implements ExecutorNode {
        private LinkedListNode<ExecutorNodeImpl> listNode;
        private Runnable command;

        private ExecutorNodeImpl(Runnable command) {
            this.command = command;
            this.listNode = linkedListCreate.createNode(this);
        }
    }

    private static class ThreadInstance
    implements RunnableReady {
        private LinkedList<ExecutorNodeImpl> runList = ExecutorFactory.access$600().create();
        private ReentrantLock lock = new ReentrantLock();
        private Condition moreWork = this.lock.newCondition();
        private volatile boolean alive = true;

        private ThreadInstance(String name, int priority) {
            threadCreate.create(name, priority, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(ThreadReady threadReady) {
            boolean firstTime = true;
            try {
                while (this.alive) {
                    Runnable runnable = null;
                    this.lock.lock();
                    try {
                        if (firstTime) {
                            firstTime = false;
                            threadReady.ready();
                        }
                        while (this.alive && this.runList.isEmpty()) {
                            this.moreWork.await();
                        }
                        if (!this.runList.isEmpty()) {
                            LinkedListNode<ExecutorNodeImpl> listNode = this.runList.removeHead();
                            ExecutorNodeImpl impl = listNode.getObject();
                            runnable = impl.command;
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                    if (runnable == null) continue;
                    runnable.run();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void add(LinkedListNode<ExecutorNodeImpl> listNode) {
            this.lock.lock();
            try {
                if (!this.alive || listNode.isOnList()) {
                    return;
                }
                boolean isEmpty = this.runList.isEmpty();
                this.runList.addTail(listNode);
                if (isEmpty) {
                    this.moreWork.signal();
                }
                return;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void stop() {
            this.lock.lock();
            try {
                this.alive = false;
                this.moreWork.signal();
                return;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class ExecutorInstance
    implements Executor {
        private ThreadInstance thread;

        private ExecutorInstance(String threadName, ThreadPriority priority) {
            this.thread = new ThreadInstance(threadName, priority.getJavaPriority());
        }

        @Override
        public ExecutorNode createNode(Runnable command) {
            return new ExecutorNodeImpl(command);
        }

        @Override
        public void execute(ExecutorNode executorNode) {
            ExecutorNodeImpl impl = (ExecutorNodeImpl)executorNode;
            this.thread.add(impl.listNode);
        }

        @Override
        public void stop() {
            this.thread.stop();
        }
    }
}

