/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import org.epics.pvdata.misc.LinkedList;
import org.epics.pvdata.misc.LinkedListArray;
import org.epics.pvdata.misc.LinkedListNode;

public class LinkedListCreate<T> {
    public LinkedList<T> create() {
        return new LinkedListImpl();
    }

    public LinkedListNode<T> createNode(T object) {
        return new LinkedListNodeImpl<T>(object);
    }

    public LinkedListArray<T> createArray() {
        return new LinkedListArrayImpl();
    }

    private static class LinkedListArrayImpl<T>
    implements LinkedListArray<T> {
        private LinkedListNode<T>[] listNodes = null;
        private int length = 0;

        private LinkedListArrayImpl() {
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public LinkedListNode<T>[] getNodes() {
            return this.listNodes;
        }

        @Override
        public void setNodes(LinkedList<T> linkedList) {
            int lengthNow = linkedList.getLength();
            if (this.listNodes == null || lengthNow > this.listNodes.length) {
                this.listNodes = new LinkedListNode[lengthNow];
            }
            LinkedListNode<T> node = linkedList.getHead();
            int index = 0;
            while (node != null) {
                this.listNodes[index++] = node;
                node = linkedList.getNext(node);
            }
            for (int i = index; i < this.listNodes.length; ++i) {
                this.listNodes[i] = null;
            }
            this.length = lengthNow;
        }

        @Override
        public void clear() {
            this.length = 0;
            this.listNodes = null;
        }
    }

    private static class LinkedListNodeImpl<T>
    implements LinkedListNode<T> {
        private T object = null;
        private LinkedListNodeImpl<T> before = null;
        private LinkedListNodeImpl<T> after = null;

        public LinkedListNodeImpl(T object) {
            this.object = object;
        }

        private LinkedListNodeImpl(boolean isHead) {
            this.before = this.after = this;
        }

        @Override
        public T getObject() {
            return this.object;
        }

        @Override
        public boolean isOnList() {
            return this.before != null || this.after != null;
        }
    }

    private static class LinkedListImpl<T>
    implements LinkedList<T> {
        private LinkedListNodeImpl<T> head = new LinkedListNodeImpl(true);
        private int length = 0;

        private LinkedListImpl() {
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public void addHead(LinkedListNode<T> temp) {
            LinkedListNodeImpl node = (LinkedListNodeImpl)temp;
            if (node.before != null || node.after != null) {
                throw new IllegalStateException("already on list");
            }
            node.after = ((LinkedListNodeImpl)this.head).after;
            node.before = (LinkedListNodeImpl)this.head;
            ((LinkedListNodeImpl)this.head).after.before = node;
            ((LinkedListNodeImpl)this.head).after = node;
            ++this.length;
        }

        @Override
        public void addTail(LinkedListNode<T> temp) {
            LinkedListNodeImpl node = (LinkedListNodeImpl)temp;
            if (node.before != null || node.after != null) {
                throw new IllegalStateException("already on list");
            }
            node.before = ((LinkedListNodeImpl)this.head).before;
            node.after = (LinkedListNodeImpl)this.head;
            ((LinkedListNodeImpl)this.head).before.after = node;
            ((LinkedListNodeImpl)this.head).before = node;
            ++this.length;
        }

        @Override
        public LinkedListNode<T> getHead() {
            if (((LinkedListNodeImpl)this.head).after == this.head) {
                return null;
            }
            return ((LinkedListNodeImpl)this.head).after;
        }

        @Override
        public LinkedListNode<T> getNext(LinkedListNode<T> temp) {
            LinkedListNodeImpl node = (LinkedListNodeImpl)temp;
            if (node.after == this.head) {
                return null;
            }
            return node.after;
        }

        @Override
        public LinkedListNode<T> getPrev(LinkedListNode<T> temp) {
            LinkedListNodeImpl node = (LinkedListNodeImpl)temp;
            if (node.before == this.head) {
                return null;
            }
            return node.before;
        }

        @Override
        public LinkedListNode<T> getTail() {
            if (((LinkedListNodeImpl)this.head).after == this.head) {
                return null;
            }
            return ((LinkedListNodeImpl)this.head).before;
        }

        @Override
        public void insertAfter(LinkedListNode<T> node, LinkedListNode<T> addNode) {
            LinkedListNodeImpl existingNode = (LinkedListNodeImpl)node;
            LinkedListNodeImpl newNode = (LinkedListNodeImpl)addNode;
            if (existingNode.after == null || existingNode.before == null) {
                throw new IllegalStateException("listNode is not  on list");
            }
            if (newNode.before != null || newNode.after != null) {
                throw new IllegalStateException("addNode is already on list");
            }
            newNode.after = existingNode.after;
            newNode.before = existingNode;
            existingNode.after.before = newNode;
            existingNode.after = newNode;
            ++this.length;
        }

        @Override
        public void insertBefore(LinkedListNode<T> node, LinkedListNode<T> addNode) {
            LinkedListNodeImpl existingNode = (LinkedListNodeImpl)node;
            LinkedListNodeImpl newNode = (LinkedListNodeImpl)addNode;
            if (existingNode.after == null || existingNode.before == null) {
                throw new IllegalStateException("listNode is not  on list");
            }
            if (newNode.before != null || newNode.after != null) {
                throw new IllegalStateException("addNode is already on list");
            }
            newNode.after = existingNode;
            newNode.before = existingNode.before;
            existingNode.before.after = newNode;
            existingNode.before = newNode;
            ++this.length;
        }

        @Override
        public void remove(LinkedListNode<T> temp) {
            LinkedListNodeImpl node = (LinkedListNodeImpl)temp;
            if (node.before == null || node.after == null) {
                throw new IllegalStateException("not on list");
            }
            LinkedListNodeImpl prev = node.before;
            LinkedListNodeImpl next = node.after;
            node.after = (node.before = null);
            prev.after = next;
            next.before = prev;
            --this.length;
        }

        @Override
        public LinkedListNode<T> removeHead() {
            if (((LinkedListNodeImpl)this.head).after == this.head) {
                return null;
            }
            LinkedListNodeImpl node = ((LinkedListNodeImpl)this.head).after;
            this.remove((T)((LinkedListNodeImpl)this.head).after);
            return node;
        }

        @Override
        public LinkedListNode<T> removeTail() {
            if (((LinkedListNodeImpl)this.head).after == this.head) {
                return null;
            }
            LinkedListNodeImpl node = ((LinkedListNodeImpl)this.head).before;
            this.remove((T)((LinkedListNodeImpl)this.head).before);
            return node;
        }

        @Override
        public void remove(T object) {
            LinkedListNode<T> node = this.getHead();
            while (node != null) {
                if (node.getObject() == object) {
                    this.remove((T)node);
                    return;
                }
                node = this.getNext(node);
            }
        }

        @Override
        public boolean isEmpty() {
            return ((LinkedListNodeImpl)this.head).after == this.head;
        }

        @Override
        public boolean contains(T object) {
            LinkedListNode<T> node = this.getHead();
            while (node != null) {
                if (node.getObject() == object) {
                    return true;
                }
                node = this.getNext(node);
            }
            return false;
        }
    }
}

