/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import java.nio.ByteBuffer;
import org.epics.pvdata.pv.DeserializableControl;
import org.epics.pvdata.pv.SerializableControl;

public final class SerializeHelper {
    public static final void writeSize(int s, ByteBuffer buffer, SerializableControl flusher) {
        flusher.ensureBuffer(9);
        SerializeHelper.writeSize(s, buffer);
    }

    private static final void writeSize(int s, ByteBuffer buffer) {
        if (s == -1) {
            buffer.put((byte)-1);
        } else if (s < 254) {
            buffer.put((byte)s);
        } else {
            buffer.put((byte)-2).putInt(s);
        }
    }

    public static final int readSize(ByteBuffer buffer, DeserializableControl control) {
        control.ensureData(1);
        int b = buffer.get();
        if (b == -1) {
            return -1;
        }
        if (b == -2) {
            control.ensureData(4);
            int s = buffer.getInt();
            if (s < 0) {
                throw new RuntimeException("negative array size");
            }
            return s;
        }
        return b < 0 ? b + 256 : b;
    }

    public static final int readSize(ByteBuffer buffer) {
        int b = buffer.get();
        if (b == -1) {
            return -1;
        }
        if (b == -2) {
            int s = buffer.getInt();
            if (s < 0) {
                throw new RuntimeException("negative array size");
            }
            return s;
        }
        return b < 0 ? b + 256 : b;
    }

    public static final void serializeString(String value, ByteBuffer buffer, SerializableControl flusher) {
        if (value == null) {
            SerializeHelper.writeSize(-1, buffer, flusher);
        } else {
            int len = value.length();
            SerializeHelper.writeSize(len, buffer, flusher);
            int i = 0;
            while (true) {
                int maxToWrite = Math.min(len - i, buffer.remaining());
                buffer.put(value.getBytes(), i, maxToWrite);
                if ((i += maxToWrite) >= len) break;
                flusher.flushSerializeBuffer();
            }
        }
    }

    public static final void serializeString(String value, ByteBuffer buffer) {
        if (value == null) {
            SerializeHelper.writeSize(-1, buffer);
        } else {
            int len = value.length();
            SerializeHelper.writeSize(len, buffer);
            buffer.put(value.getBytes());
        }
    }

    public static final void serializeSubstring(String value, int offset, int count, ByteBuffer buffer, SerializableControl flusher) {
        if (value == null) {
            SerializeHelper.writeSize(-1, buffer, flusher);
        } else {
            SerializeHelper.writeSize(count, buffer, flusher);
            int i = 0;
            while (true) {
                int maxToWrite = Math.min(count - i, buffer.remaining());
                buffer.put(value.getBytes(), i + offset, maxToWrite);
                if ((i += maxToWrite) >= count) break;
                flusher.flushSerializeBuffer();
            }
        }
    }

    public static final String deserializeString(ByteBuffer buffer, DeserializableControl control) {
        int size = SerializeHelper.readSize(buffer, control);
        if (size >= 0) {
            byte[] bytes = new byte[size];
            int i = 0;
            while (true) {
                int toRead = Math.min(size - i, buffer.remaining());
                buffer.get(bytes, i, toRead);
                if ((i += toRead) >= size) break;
                control.ensureData(1);
            }
            return new String(bytes);
        }
        return null;
    }

    public static final String deserializeString(ByteBuffer buffer) {
        int size = SerializeHelper.readSize(buffer);
        if (size >= 0) {
            byte[] bytes = new byte[size];
            buffer.get(bytes, 0, size);
            return new String(bytes);
        }
        return null;
    }
}

