/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.epics.pvdata.misc.RunnableReady;
import org.epics.pvdata.misc.ThreadCreate;
import org.epics.pvdata.misc.ThreadReady;

public class ThreadCreateFactory {
    private static ThreadCreateImpl threadCreate = new ThreadCreateImpl();

    public static ThreadCreate getThreadCreate() {
        return threadCreate;
    }

    private static class ThreadCreateImpl
    implements ThreadCreate {
        private List<Thread> threadList = new LinkedList<Thread>();

        private ThreadCreateImpl() {
        }

        @Override
        public Thread create(String name, int priority, RunnableReady runnableReady) {
            RunnableImpl runnableImpl = new RunnableImpl(name, priority, runnableReady);
            return runnableImpl.start();
        }

        @Override
        public synchronized Thread[] getThreads() {
            int length = this.threadList.size();
            Thread[] threads = new Thread[length];
            ListIterator<Thread> iter = this.threadList.listIterator();
            for (int i = 0; i < length; ++i) {
                threads[i] = iter.next();
            }
            return threads;
        }

        private synchronized void addThread(Thread thread) {
            if (this.threadList.contains(thread)) {
                throw new IllegalStateException("addThread but already on list");
            }
            this.threadList.add(thread);
        }

        private synchronized void removeThread(Thread thread) {
            this.threadList.remove(thread);
        }

        private static class RunnableImpl
        implements Runnable,
        ThreadReady {
            private RunnableReady runnable;
            private Thread thread;
            private ReentrantLock lock = new ReentrantLock();
            private Condition waitForReady = this.lock.newCondition();
            private volatile boolean isReady = false;

            private RunnableImpl(String name, int priority, RunnableReady runnable) {
                this.runnable = runnable;
                this.thread = new Thread((Runnable)this, name);
                this.thread.setPriority(priority);
            }

            private Thread start() {
                this.thread.start();
                this.lock.lock();
                try {
                    if (!this.isReady) {
                        this.waitForReady.await(10L, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException e) {
                    System.err.println(e.getMessage() + " thread " + this.thread.getName() + " did not call ready");
                }
                finally {
                    this.lock.unlock();
                }
                return this.thread;
            }

            @Override
            public void run() {
                threadCreate.addThread(this.thread);
                this.runnable.run(this);
                threadCreate.removeThread(this.thread);
            }

            @Override
            public void ready() {
                this.lock.lock();
                try {
                    this.isReady = true;
                    this.waitForReady.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

