/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import org.epics.pvdata.misc.TimeFunction;
import org.epics.pvdata.misc.TimeFunctionRequester;

public class TimeFunctionFactory {
    public static TimeFunction create(TimeFunctionRequester requester) {
        return new TimeFunctionImpl(requester);
    }

    private static class TimeFunctionImpl
    implements TimeFunction {
        private TimeFunctionRequester requester;

        private TimeFunctionImpl(TimeFunctionRequester requester) {
            this.requester = requester;
        }

        @Override
        public double timeCall() {
            double diff;
            double perCall = 0.0;
            long ntimes = 1L;
            while (true) {
                long startTime = System.nanoTime();
                for (long i = 0L; i < ntimes; ++i) {
                    this.requester.function();
                }
                long endTime = System.nanoTime();
                diff = (double)(endTime - startTime) / 1.0E9;
                if (diff >= 1.0) break;
                ntimes *= 2L;
            }
            perCall = diff / (double)ntimes;
            return perCall;
        }
    }
}

