/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.misc;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.epics.pvdata.misc.RunnableReady;
import org.epics.pvdata.misc.ThreadCreate;
import org.epics.pvdata.misc.ThreadCreateFactory;
import org.epics.pvdata.misc.ThreadPriority;
import org.epics.pvdata.misc.ThreadReady;
import org.epics.pvdata.misc.Timer;

public class TimerFactory {
    private static final ThreadCreate threadCreate = ThreadCreateFactory.getThreadCreate();

    public static Timer create(String threadName, ThreadPriority priority) {
        return new TimerInstance(threadName, priority);
    }

    public static Timer.TimerNode createNode(Timer.TimerCallback timerCallback) {
        return new TimerNodeImpl(timerCallback);
    }

    private static class TimerNodeImpl
    implements Timer.TimerNode {
        private TimerInstance timerInstance = null;
        private Timer.TimerCallback timerCallback;
        private long timeToRun = 0L;
        private long period = 0L;
        private volatile boolean isQueued = false;
        private volatile boolean isCanceled = false;

        private TimerNodeImpl(Timer.TimerCallback timerCallback) {
            this.timerCallback = timerCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            this.isCanceled = true;
            TimerInstance timerInstance = this.timerInstance;
            if (timerInstance != null) {
                PriorityQueue priorityQueue = timerInstance.queue;
                synchronized (priorityQueue) {
                    timerInstance.queue.remove(this);
                    this.isQueued = false;
                }
            }
        }

        @Override
        public boolean isScheduled() {
            return this.isQueued;
        }
    }

    private static class TimerInstance
    implements Timer,
    Comparator<TimerNodeImpl> {
        private PriorityQueue<TimerNodeImpl> queue = new PriorityQueue<TimerNodeImpl>(16, this);
        private ThreadInstance thread;
        private volatile boolean isStopped = false;

        private TimerInstance(String threadName, ThreadPriority priority) {
            this.thread = new ThreadInstance(threadName, priority.getJavaPriority());
        }

        @Override
        public int compare(TimerNodeImpl arg0, TimerNodeImpl arg1) {
            long b;
            long a = arg0.timeToRun;
            return a < (b = arg1.timeToRun) ? -1 : (a == b ? 0 : 1);
        }

        @Override
        public void scheduleAfterDelay(Timer.TimerNode timerNode, double delay) {
            this.schedulePeriodic(timerNode, delay, -0.1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void schedulePeriodic(Timer.TimerNode timerNode, double delayDouble, double periodDouble) {
            long delay = (long)(delayDouble * 1000.0);
            long period = (long)(periodDouble * 1000.0);
            TimerNodeImpl timerNodeImpl = (TimerNodeImpl)timerNode;
            if (timerNodeImpl.isQueued) {
                throw new IllegalStateException("already scheduled");
            }
            if (this.isStopped) {
                timerNodeImpl.timerCallback.timerStopped();
                return;
            }
            timerNodeImpl.isCanceled = false;
            if (delay < 0L) {
                delay = 0L;
            }
            timerNodeImpl.timeToRun = System.currentTimeMillis() + delay;
            if (period < 0L) {
                period = 0L;
            }
            timerNodeImpl.period = period;
            boolean isFirst = false;
            PriorityQueue<TimerNodeImpl> priorityQueue = this.queue;
            synchronized (priorityQueue) {
                if (!timerNodeImpl.isCanceled) {
                    timerNodeImpl.isQueued = true;
                    timerNodeImpl.timerInstance = this;
                    this.queue.add(timerNodeImpl);
                    TimerNodeImpl first = this.queue.peek();
                    if (first == timerNodeImpl) {
                        isFirst = true;
                    }
                }
            }
            if (isFirst) {
                this.thread.wakeUp();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            this.isStopped = true;
            this.thread.stop();
            Timer.TimerCallback timerCallback = null;
            while (true) {
                PriorityQueue<TimerNodeImpl> priorityQueue = this.queue;
                synchronized (priorityQueue) {
                    TimerNodeImpl timerNode = this.queue.poll();
                    if (timerNode == null) {
                        return;
                    }
                    timerCallback = timerNode.timerCallback;
                }
                timerCallback.timerStopped();
            }
        }

        private class ThreadInstance
        implements RunnableReady {
            private volatile boolean alive = true;
            private boolean wokenUp = false;

            private ThreadInstance(String name, int priority) {
                threadCreate.create(name, priority, this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(ThreadReady threadReady) {
                threadReady.ready();
                while (this.alive) {
                    try {
                        long currentTime = System.currentTimeMillis();
                        long timeToRun = currentTime + 1000000L;
                        long period = 0L;
                        TimerNodeImpl nodeToCall = null;
                        PriorityQueue priorityQueue = TimerInstance.this.queue;
                        synchronized (priorityQueue) {
                            TimerNodeImpl timerNode = (TimerNodeImpl)TimerInstance.this.queue.peek();
                            if (timerNode != null && (timeToRun = timerNode.timeToRun) <= currentTime) {
                                if (!timerNode.isCanceled) {
                                    nodeToCall = timerNode;
                                }
                                TimerInstance.this.queue.poll();
                                period = timerNode.period;
                                if (period > 0L && !timerNode.isCanceled) {
                                    timerNode.timeToRun = currentTime + period;
                                    TimerInstance.this.queue.add(timerNode);
                                } else {
                                    timerNode.isQueued = false;
                                    timerNode.timerInstance = null;
                                }
                                timerNode = (TimerNodeImpl)TimerInstance.this.queue.peek();
                                timeToRun = timerNode != null ? timerNode.timeToRun : currentTime + 1000000L;
                            }
                        }
                        if (nodeToCall != null) {
                            nodeToCall.timerCallback.callback();
                        }
                        long delay = timeToRun - currentTime;
                        if (!this.alive || delay <= 0L) continue;
                        ThreadInstance threadInstance = this;
                        synchronized (threadInstance) {
                            if (!this.wokenUp) {
                                this.wait(delay);
                            }
                            this.wokenUp = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void wakeUp() {
                ThreadInstance threadInstance = this;
                synchronized (threadInstance) {
                    this.wokenUp = true;
                    this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void stop() {
                ThreadInstance threadInstance = this;
                synchronized (threadInstance) {
                    this.alive = false;
                    this.wokenUp = true;
                    this.notifyAll();
                }
            }
        }
    }
}

