/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.Alarm;
import org.epics.pvdata.property.AlarmSeverity;
import org.epics.pvdata.property.AlarmStatus;
import org.epics.pvdata.property.PVAlarm;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Type;

public final class PVAlarmFactory
implements PVAlarm {
    private PVInt pvSeverity = null;
    private PVInt pvStatus = null;
    private PVString pvMessage = null;
    private static final String noAlarmFound = "No alarm structure was located";
    private static final String notAttached = "Not attached to an alarm structure";

    public static PVAlarm create() {
        return new PVAlarmFactory();
    }

    @Override
    public boolean attach(PVField pvField) {
        if (pvField.getField().getType() != Type.structure) {
            throw new IllegalArgumentException(noAlarmFound);
        }
        PVStructure pvStructure = (PVStructure)pvField;
        boolean again = true;
        while (true) {
            PVField xxx;
            if ((xxx = pvStructure.getSubField("severity")) != null) {
                xxx = pvStructure.getSubField("status");
            }
            if (xxx != null) {
                xxx = pvStructure.getSubField("message");
            }
            if (xxx != null) {
                this.pvSeverity = pvStructure.getIntField("severity");
                this.pvStatus = pvStructure.getIntField("status");
                this.pvMessage = pvStructure.getStringField("message");
            }
            if (this.pvSeverity != null && this.pvStatus != null && this.pvMessage != null) {
                return true;
            }
            if (!again || (pvStructure = pvStructure.getParent()) == null) break;
            again = false;
        }
        this.pvSeverity = null;
        this.pvStatus = null;
        this.pvMessage = null;
        return false;
    }

    @Override
    public void detach() {
        this.pvSeverity = null;
        this.pvMessage = null;
    }

    @Override
    public boolean isAttached() {
        return this.pvSeverity != null && this.pvMessage != null;
    }

    @Override
    public void get(Alarm alarm) {
        if (this.pvSeverity == null || this.pvMessage == null) {
            throw new IllegalStateException(notAttached);
        }
        alarm.setSeverity(AlarmSeverity.getSeverity(this.pvSeverity.get()));
        alarm.setStatus(AlarmStatus.getStatus(this.pvStatus.get()));
        alarm.setMessage(this.pvMessage.get());
    }

    @Override
    public boolean set(Alarm alarm) {
        if (this.pvSeverity == null || this.pvMessage == null) {
            throw new IllegalStateException(notAttached);
        }
        if (this.pvSeverity.isImmutable() || this.pvMessage.isImmutable()) {
            return false;
        }
        Alarm current = new Alarm();
        this.get(current);
        boolean returnValue = false;
        if (current.getSeverity() != alarm.getSeverity()) {
            this.pvSeverity.put(alarm.getSeverity().ordinal());
            returnValue = true;
        }
        if (current.getStatus() != alarm.getStatus()) {
            this.pvStatus.put(alarm.getStatus().ordinal());
            returnValue = true;
        }
        if (!current.getMessage().equals(alarm.getMessage())) {
            this.pvMessage.put(alarm.getMessage());
            returnValue = true;
        }
        return returnValue;
    }
}

