/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.Control;
import org.epics.pvdata.property.PVControl;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Type;

public final class PVControlFactory
implements PVControl {
    private PVDouble pvLow = null;
    private PVDouble pvHigh = null;
    private PVDouble pvMinStep = null;
    private static final String noControlFound = "No control structure was located";
    private static final String notAttached = "Not attached to an control structure";

    public static PVControl create() {
        return new PVControlFactory();
    }

    @Override
    public boolean attach(PVField pvField) {
        if (pvField.getField().getType() != Type.structure) {
            throw new IllegalArgumentException(noControlFound);
        }
        PVStructure pvStructure = (PVStructure)pvField;
        PVDouble pvDouble = pvStructure.getDoubleField("limitLow");
        if (pvDouble == null) {
            throw new IllegalArgumentException(noControlFound);
        }
        this.pvLow = pvDouble;
        pvDouble = pvStructure.getDoubleField("limitHigh");
        if (pvDouble == null) {
            throw new IllegalArgumentException(noControlFound);
        }
        this.pvHigh = pvDouble;
        pvDouble = pvStructure.getDoubleField("minStep");
        if (pvDouble == null) {
            throw new IllegalArgumentException(noControlFound);
        }
        this.pvMinStep = pvDouble;
        return true;
    }

    @Override
    public void detach() {
        this.pvLow = null;
        this.pvHigh = null;
        this.pvMinStep = null;
    }

    @Override
    public boolean isAttached() {
        return this.pvLow != null && this.pvHigh != null && this.pvMinStep != null;
    }

    @Override
    public void get(Control control) {
        if (this.pvLow == null || this.pvHigh == null || this.pvMinStep == null) {
            throw new IllegalStateException(notAttached);
        }
        control.setLow(this.pvLow.get());
        control.setHigh(this.pvHigh.get());
        control.setMinStep(this.pvMinStep.get());
    }

    @Override
    public boolean set(Control control) {
        if (this.pvLow == null || this.pvHigh == null || this.pvMinStep == null) {
            throw new IllegalStateException(notAttached);
        }
        if (this.pvLow.isImmutable() || this.pvHigh.isImmutable()) {
            return false;
        }
        Control current = new Control();
        this.get(current);
        boolean returnValue = false;
        if (current.getLow() != control.getLow()) {
            this.pvLow.put(control.getLow());
            returnValue = true;
        }
        if (current.getHigh() != control.getHigh()) {
            this.pvHigh.put(control.getHigh());
            returnValue = true;
        }
        if (current.getMinStep() != control.getMinStep()) {
            this.pvMinStep.put(control.getMinStep());
            returnValue = true;
        }
        return returnValue;
    }
}

