/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.Display;
import org.epics.pvdata.property.PVDisplay;
import org.epics.pvdata.pv.PVDouble;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVString;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.Type;

public final class PVDisplayFactory
implements PVDisplay {
    private PVString pvDescription = null;
    private PVString pvFormat = null;
    private PVString pvUnits = null;
    private PVDouble pvLow = null;
    private PVDouble pvHigh = null;
    private static final String noDisplayFound = "No display structure was located";
    private static final String notAttached = "Not attached to an display structure";

    public static PVDisplay create() {
        return new PVDisplayFactory();
    }

    @Override
    public boolean attach(PVField pvField) {
        if (pvField.getField().getType() != Type.structure) {
            throw new IllegalArgumentException(noDisplayFound);
        }
        PVStructure pvStructure = (PVStructure)pvField;
        this.pvDescription = pvStructure.getStringField("description");
        if (this.pvDescription == null) {
            throw new IllegalArgumentException(noDisplayFound);
        }
        this.pvFormat = pvStructure.getStringField("format");
        if (this.pvFormat == null) {
            throw new IllegalArgumentException(noDisplayFound);
        }
        this.pvUnits = pvStructure.getStringField("units");
        if (this.pvUnits == null) {
            throw new IllegalArgumentException(noDisplayFound);
        }
        this.pvLow = pvStructure.getDoubleField("limitLow");
        if (this.pvLow == null) {
            throw new IllegalArgumentException(noDisplayFound);
        }
        this.pvHigh = pvStructure.getDoubleField("limitHigh");
        if (this.pvHigh == null) {
            throw new IllegalArgumentException(noDisplayFound);
        }
        return true;
    }

    @Override
    public void detach() {
        this.pvDescription = null;
        this.pvFormat = null;
        this.pvUnits = null;
        this.pvLow = null;
        this.pvHigh = null;
    }

    @Override
    public boolean isAttached() {
        return this.pvDescription != null && this.pvFormat != null && this.pvUnits != null && this.pvLow != null && this.pvHigh != null;
    }

    @Override
    public void get(Display display) {
        if (this.pvDescription == null || this.pvFormat == null || this.pvUnits == null || this.pvLow == null || this.pvHigh == null) {
            throw new IllegalStateException(notAttached);
        }
        display.setDescription(this.pvDescription.get());
        display.setFormat(this.pvFormat.get());
        display.setUnits(this.pvUnits.get());
        display.setLow(this.pvLow.get());
        display.setHigh(this.pvHigh.get());
    }

    @Override
    public boolean set(Display display) {
        if (this.pvDescription == null || this.pvFormat == null || this.pvUnits == null || this.pvLow == null || this.pvHigh == null) {
            throw new IllegalStateException(notAttached);
        }
        if (this.pvDescription.isImmutable() || this.pvFormat.isImmutable() || this.pvUnits.isImmutable()) {
            return false;
        }
        if (this.pvLow.isImmutable() || this.pvHigh.isImmutable()) {
            return false;
        }
        Display current = new Display();
        this.get(current);
        boolean returnValue = false;
        if (!current.getDescription().equals(display.getDescription())) {
            this.pvDescription.put(display.getDescription());
            returnValue = true;
        }
        if (!current.getFormat().equals(display.getFormat())) {
            this.pvFormat.put(display.getFormat());
            returnValue = true;
        }
        if (!current.getUnits().equals(display.getUnits())) {
            this.pvUnits.put(display.getUnits());
            returnValue = true;
        }
        if (current.getLow() != display.getLow()) {
            this.pvLow.put(display.getLow());
            returnValue = true;
        }
        if (current.getHigh() != display.getHigh()) {
            this.pvHigh.put(display.getHigh());
            returnValue = true;
        }
        return returnValue;
    }
}

