/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.PVEnumerated;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVInt;
import org.epics.pvdata.pv.PVScalarArray;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.PVStructure;
import org.epics.pvdata.pv.ScalarType;
import org.epics.pvdata.pv.StringArrayData;
import org.epics.pvdata.pv.Type;

public final class PVEnumeratedFactory
implements PVEnumerated {
    private PVInt pvIndex = null;
    private PVStringArray pvChoices = null;
    private StringArrayData data = new StringArrayData();
    private static final String notStructure = "field is not a structure";
    private static final String notEnumerated = "field is not an enumerated structure";
    private static final String notAttached = "Not attached to an enumerated structure";

    public static PVEnumerated create() {
        return new PVEnumeratedFactory();
    }

    @Override
    public boolean attach(PVField pvField) {
        if (pvField.getField().getType() != Type.structure) {
            throw new IllegalArgumentException(notStructure);
        }
        PVStructure pvStructure = (PVStructure)pvField;
        PVInt pvInt = pvStructure.getIntField("index");
        if (pvInt == null) {
            throw new IllegalArgumentException(notEnumerated);
        }
        PVScalarArray pvScalarArray = pvStructure.getScalarArrayField("choices", ScalarType.pvString);
        if (pvScalarArray == null) {
            throw new IllegalArgumentException(notEnumerated);
        }
        this.pvIndex = pvInt;
        this.pvChoices = (PVStringArray)pvScalarArray;
        return true;
    }

    @Override
    public void detach() {
        this.pvIndex = null;
        this.pvChoices = null;
    }

    @Override
    public boolean isAttached() {
        return this.pvIndex != null && this.pvChoices != null;
    }

    @Override
    public boolean choicesMutable() {
        if (this.pvIndex == null || this.pvChoices == null) {
            throw new IllegalStateException(notAttached);
        }
        return this.pvChoices.isImmutable();
    }

    @Override
    public String getChoice() {
        if (this.pvIndex == null || this.pvChoices == null) {
            throw new IllegalStateException(notAttached);
        }
        int index = this.pvIndex.get();
        this.pvChoices.get(0, this.pvChoices.getLength(), this.data);
        if (((String[])this.data.data).length <= index) {
            return String.format("PVEnumerated.getChoice index out of bounds pvChoices %s%n", this.pvChoices);
        }
        return ((String[])this.data.data)[index];
    }

    @Override
    public String[] getChoices() {
        if (this.pvIndex == null || this.pvChoices == null) {
            throw new IllegalStateException(notAttached);
        }
        this.pvChoices.get(0, this.pvChoices.getLength(), this.data);
        return (String[])this.data.data;
    }

    @Override
    public int getIndex() {
        if (this.pvIndex == null || this.pvChoices == null) {
            throw new IllegalStateException(notAttached);
        }
        return this.pvIndex.get();
    }

    @Override
    public boolean setChoices(String[] choices) {
        if (this.pvIndex == null || this.pvChoices == null) {
            throw new IllegalStateException(notAttached);
        }
        if (this.pvChoices.isImmutable()) {
            return false;
        }
        this.pvChoices.put(0, choices.length, choices, 0);
        return true;
    }

    @Override
    public boolean setIndex(int index) {
        if (this.pvIndex == null || this.pvChoices == null) {
            throw new IllegalStateException(notAttached);
        }
        if (this.pvIndex.isImmutable()) {
            return false;
        }
        this.pvIndex.put(index);
        return true;
    }
}

