/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.property;

import org.epics.pvdata.property.PVProperty;
import org.epics.pvdata.pv.PVField;
import org.epics.pvdata.pv.PVStructure;

public class PVPropertyFactory {
    private static PVPropertyImpl pvProperty = new PVPropertyImpl();

    private PVPropertyFactory() {
    }

    public static PVProperty getPVProperty() {
        return pvProperty;
    }

    private static final class PVPropertyImpl
    implements PVProperty {
        private PVPropertyImpl() {
        }

        private static boolean isValueField(PVField pvField) {
            PVStructure parent = pvField.getParent();
            if (parent == null) {
                return false;
            }
            PVField[] pvFields = parent.getPVFields();
            String[] fieldNames = parent.getStructure().getFieldNames();
            for (int i = 0; i < fieldNames.length; ++i) {
                if (pvFields[i] != pvField || !fieldNames[i].equals("value")) continue;
                return true;
            }
            return false;
        }

        @Override
        public PVField findProperty(PVField pvField, String fieldName) {
            if (!PVPropertyImpl.isValueField(pvField)) {
                return null;
            }
            PVField pvFound = pvField.getParent().getSubField(fieldName);
            if (pvFound != null) {
                return pvFound;
            }
            if (fieldName.equals("timeStamp")) {
                return this.findPropertyViaParent(pvField, fieldName);
            }
            return null;
        }

        @Override
        public PVField findPropertyViaParent(PVField pvf, String propertyName) {
            PVField currentPVField = pvf;
            for (PVStructure parentPVStructure = currentPVField.getParent(); parentPVStructure != null; parentPVStructure = parentPVStructure.getParent()) {
                PVField pvField = parentPVStructure.getSubField(propertyName);
                if (pvField == null) continue;
                return pvField;
            }
            return null;
        }

        @Override
        public String[] getPropertyNames(PVField pv) {
            PVField pvField = pv;
            if (!PVPropertyImpl.isValueField(pvField)) {
                return null;
            }
            PVStructure pvStructure = pvField.getParent();
            PVField[] pvFields = pvStructure.getPVFields();
            String[] fieldNames = pvStructure.getStructure().getFieldNames();
            int size = 0;
            boolean addTimeStamp = true;
            PVField pvTimeStamp = null;
            for (int i = 0; i < pvFields.length; ++i) {
                if (fieldNames[i].equals("timeStamp")) {
                    pvTimeStamp = pvFields[i];
                    addTimeStamp = false;
                }
                if (fieldNames[i].equals("value")) continue;
                ++size;
            }
            if (addTimeStamp && (pvTimeStamp = this.findPropertyViaParent(pv, "timeStamp")) != null) {
                ++size;
            }
            if (size == 0) {
                return null;
            }
            String[] propertyNames = new String[size];
            int index = 0;
            if (pvTimeStamp != null) {
                propertyNames[index++] = "timeStamp";
            }
            for (int i = 0; i < pvFields.length; ++i) {
                if (fieldNames[i].equals("timeStamp") || fieldNames[i].equals("value")) continue;
                propertyNames[index++] = fieldNames[i];
            }
            return propertyNames;
        }
    }
}

