/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.pv;

public enum ScalarType {
    pvBoolean,
    pvByte,
    pvShort,
    pvInt,
    pvLong,
    pvUByte,
    pvUShort,
    pvUInt,
    pvULong,
    pvFloat,
    pvDouble,
    pvString;


    public boolean isInteger() {
        return this.ordinal() >= pvByte.ordinal() && this.ordinal() <= pvULong.ordinal();
    }

    public boolean isUInteger() {
        return this.ordinal() >= pvUByte.ordinal() && this.ordinal() <= pvULong.ordinal();
    }

    public boolean isNumeric() {
        return this.ordinal() >= pvByte.ordinal() && this.ordinal() <= pvDouble.ordinal();
    }

    public boolean isPrimitive() {
        if (this.isNumeric()) {
            return true;
        }
        return this.ordinal() == pvBoolean.ordinal();
    }

    public static ScalarType getScalarType(String type) {
        if (type.equals("boolean")) {
            return pvBoolean;
        }
        if (type.equals("byte")) {
            return pvByte;
        }
        if (type.equals("short")) {
            return pvShort;
        }
        if (type.equals("int")) {
            return pvInt;
        }
        if (type.equals("long")) {
            return pvLong;
        }
        if (type.equals("ubyte")) {
            return pvUByte;
        }
        if (type.equals("ushort")) {
            return pvUShort;
        }
        if (type.equals("uint")) {
            return pvUInt;
        }
        if (type.equals("ulong")) {
            return pvULong;
        }
        if (type.equals("float")) {
            return pvFloat;
        }
        if (type.equals("double")) {
            return pvDouble;
        }
        if (type.equals("string")) {
            return pvString;
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case pvBoolean: {
                return "boolean";
            }
            case pvByte: {
                return "byte";
            }
            case pvShort: {
                return "short";
            }
            case pvInt: {
                return "int";
            }
            case pvLong: {
                return "long";
            }
            case pvUByte: {
                return "ubyte";
            }
            case pvUShort: {
                return "ushort";
            }
            case pvUInt: {
                return "uint";
            }
            case pvULong: {
                return "ulong";
            }
            case pvFloat: {
                return "float";
            }
            case pvDouble: {
                return "double";
            }
            case pvString: {
                return "string";
            }
        }
        throw new IllegalArgumentException("Unknown scalarType");
    }
}

