/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvdata.util.pvDataHelper;

import java.util.Vector;
import org.epics.pvdata.pv.BooleanArrayData;
import org.epics.pvdata.pv.ByteArrayData;
import org.epics.pvdata.pv.DoubleArrayData;
import org.epics.pvdata.pv.LongArrayData;
import org.epics.pvdata.pv.PVBooleanArray;
import org.epics.pvdata.pv.PVByteArray;
import org.epics.pvdata.pv.PVDoubleArray;
import org.epics.pvdata.pv.PVLongArray;
import org.epics.pvdata.pv.PVStringArray;
import org.epics.pvdata.pv.StringArrayData;

public class GetHelper {
    public static Vector<Double> getDoubleVector(PVDoubleArray pv) {
        int num;
        int len = pv.getLength();
        Vector<Double> ret = new Vector<Double>();
        DoubleArrayData data = new DoubleArrayData();
        for (int offset = 0; offset < len; offset += num) {
            num = pv.get(offset, len - offset, data);
            for (int i = 0; i < num; ++i) {
                ret.add(new Double(((double[])data.data)[offset + i]));
            }
        }
        return ret;
    }

    public static Vector<Long> getLongVector(PVLongArray pv) {
        int num;
        int len = pv.getLength();
        Vector<Long> ret = new Vector<Long>();
        LongArrayData data = new LongArrayData();
        for (int offset = 0; offset < len; offset += num) {
            num = pv.get(offset, len - offset, data);
            for (int i = 0; i < num; ++i) {
                ret.add(new Long(((long[])data.data)[offset + i]));
            }
        }
        return ret;
    }

    public static Vector<Byte> getByteVector(PVByteArray pv) {
        int num;
        int len = pv.getLength();
        Vector<Byte> ret = new Vector<Byte>();
        ByteArrayData data = new ByteArrayData();
        for (int offset = 0; offset < len; offset += num) {
            num = pv.get(offset, len - offset, data);
            for (int i = 0; i < num; ++i) {
                ret.add(new Byte(((byte[])data.data)[offset + i]));
            }
        }
        return ret;
    }

    public static Vector<String> getStringVector(PVStringArray pv) {
        int num;
        int len = pv.getLength();
        Vector<String> ret = new Vector<String>();
        StringArrayData data = new StringArrayData();
        for (int offset = 0; offset < len; offset += num) {
            num = pv.get(offset, len - offset, data);
            for (int i = 0; i < num; ++i) {
                if (((String[])data.data)[offset + i] == null) {
                    ret.add(new String(""));
                    continue;
                }
                ret.add(new String(((String[])data.data)[offset + i]));
            }
        }
        return ret;
    }

    public static Vector<Boolean> getBooleanVector(PVBooleanArray pv) {
        int num;
        int len = pv.getLength();
        Vector<Boolean> ret = new Vector<Boolean>();
        BooleanArrayData data = new BooleanArrayData();
        for (int offset = 0; offset < len; offset += num) {
            num = pv.get(offset, len - offset, data);
            for (int i = 0; i < num; ++i) {
                ret.add(new Boolean(((boolean[])data.data)[offset + i]));
            }
        }
        return ret;
    }
}

