/**
 * Copyright information and license terms for this software can be
 * found in the file LICENSE.TXT included with the distribution.
 */
package org.epics.util.array;

/**
 * An iterator of {@code long}s.
 *
 */
public interface IteratorLong extends IteratorNumber {

    @Override
    public default float nextFloat() {
        return (float) nextLong();
    }

    @Override
    public default double nextDouble() {
        return (double) nextLong();
    }

    @Override
    public default byte nextByte() {
        return (byte) nextLong();
    }

    @Override
    public default short nextShort() {
        return (short) nextLong();
    }

    @Override
    public default int nextInt() {
        return (int) nextLong();
    }

}
