/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.ArrayByte;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ArrayFloat;
import org.epics.util.array.ArrayInteger;
import org.epics.util.array.ArrayLong;
import org.epics.util.array.ArrayShort;
import org.epics.util.array.ArrayUByte;
import org.epics.util.array.ArrayUInteger;
import org.epics.util.array.ArrayULong;
import org.epics.util.array.ArrayUShort;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.IteratorNumber;
import org.epics.util.array.ListByte;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListFloat;
import org.epics.util.array.ListInteger;
import org.epics.util.array.ListLong;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListShort;

public class CollectionNumbers {
    private CollectionNumbers() {
    }

    public static ListNumber toList(Object values) {
        if (values instanceof double[]) {
            return CollectionNumbers.toListDouble((double[])values);
        }
        if (values instanceof float[]) {
            return CollectionNumbers.toListFloat((float[])values);
        }
        if (values instanceof long[]) {
            return CollectionNumbers.toListLong((long[])values);
        }
        if (values instanceof int[]) {
            return CollectionNumbers.toListInt((int[])values);
        }
        if (values instanceof short[]) {
            return CollectionNumbers.toListShort((short[])values);
        }
        if (values instanceof byte[]) {
            return CollectionNumbers.toListByte((byte[])values);
        }
        throw new IllegalArgumentException(values + " is not a an array of primitive numbers");
    }

    public static ArrayDouble toListDouble(double ... values) {
        return new ArrayDouble(values, 0, values.length, false);
    }

    public static ArrayFloat toListFloat(float ... values) {
        return new ArrayFloat(values, 0, values.length, false);
    }

    public static ArrayLong toListLong(long ... values) {
        return new ArrayLong(values, 0, values.length, false);
    }

    public static ArrayULong toListULong(long ... values) {
        return new ArrayULong(values, 0, values.length, false);
    }

    public static ArrayInteger toListInt(int ... values) {
        return new ArrayInteger(values, 0, values.length, false);
    }

    public static ArrayUInteger toListUInt(int ... values) {
        return new ArrayUInteger(values, 0, values.length, false);
    }

    public static ArrayShort toListShort(short ... values) {
        return new ArrayShort(values, 0, values.length, false);
    }

    public static ArrayUShort toListUShort(short ... values) {
        return new ArrayUShort(values, 0, values.length, false);
    }

    public static ArrayByte toListByte(byte ... values) {
        return new ArrayByte(values, 0, values.length, false);
    }

    public static ArrayUByte toListUByte(byte ... values) {
        return new ArrayUByte(values, 0, values.length, false);
    }

    public static ListNumber unmodifiableList(ListNumber list) {
        if (list instanceof ListDouble) {
            return CollectionNumbers.unmodifiableList((ListDouble)list);
        }
        if (list instanceof ListFloat) {
            return CollectionNumbers.unmodifiableList((ListFloat)list);
        }
        if (list instanceof ListLong) {
            return CollectionNumbers.unmodifiableList((ListLong)list);
        }
        if (list instanceof ListInteger) {
            return CollectionNumbers.unmodifiableList((ListInteger)list);
        }
        if (list instanceof ListShort) {
            return CollectionNumbers.unmodifiableList((ListShort)list);
        }
        if (list instanceof ListByte) {
            return CollectionNumbers.unmodifiableList((ListByte)list);
        }
        throw new IllegalArgumentException(list + " does not implement a particular ListXxx type");
    }

    public static ListDouble unmodifiableList(final ListDouble list) {
        if (list instanceof ArrayDouble) {
            return CollectionNumbers.unmodifiableList((ArrayDouble)list);
        }
        return new ListDouble(){

            @Override
            public double getDouble(int index) {
                return list.getDouble(index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static ListFloat unmodifiableList(final ListFloat list) {
        if (list instanceof ArrayFloat) {
            return CollectionNumbers.unmodifiableList((ArrayFloat)list);
        }
        return new ListFloat(){

            @Override
            public float getFloat(int index) {
                return list.getFloat(index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static ListLong unmodifiableList(final ListLong list) {
        if (list instanceof ArrayLong) {
            return CollectionNumbers.unmodifiableList((ArrayLong)list);
        }
        return new ListLong(){

            @Override
            public long getLong(int index) {
                return list.getLong(index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static ListInteger unmodifiableList(final ListInteger list) {
        if (list instanceof ArrayInteger) {
            return CollectionNumbers.unmodifiableList((ArrayInteger)list);
        }
        return new ListInteger(){

            @Override
            public int getInt(int index) {
                return list.getInt(index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static ListShort unmodifiableList(final ListShort list) {
        if (list instanceof ArrayShort) {
            return CollectionNumbers.unmodifiableList((ArrayShort)list);
        }
        return new ListShort(){

            @Override
            public short getShort(int index) {
                return list.getShort(index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static ListByte unmodifiableList(final ListByte list) {
        if (list instanceof ArrayByte) {
            return CollectionNumbers.unmodifiableList((ArrayByte)list);
        }
        return new ListByte(){

            @Override
            public byte getByte(int index) {
                return list.getByte(index);
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static ArrayDouble unmodifiableList(ArrayDouble list) {
        return new ArrayDouble(list.wrappedArray(), list.startIndex(), list.size(), true);
    }

    public static ArrayFloat unmodifiableList(ArrayFloat list) {
        return new ArrayFloat(list.wrappedArray(), list.startIndex(), list.size(), true);
    }

    public static ArrayLong unmodifiableList(ArrayLong list) {
        return new ArrayLong(list.wrappedArray(), list.startIndex(), list.size(), true);
    }

    public static ArrayInteger unmodifiableList(ArrayInteger list) {
        return new ArrayInteger(list.wrappedArray(), list.startIndex(), list.size(), true);
    }

    public static ArrayShort unmodifiableList(ArrayShort list) {
        return new ArrayShort(list.wrappedArray(), list.startIndex(), list.size(), true);
    }

    public static ArrayByte unmodifiableList(ArrayByte list) {
        return new ArrayByte(list.wrappedArray(), list.startIndex(), list.size(), true);
    }

    public static ArrayDouble unmodifiableListDouble(double ... values) {
        return new ArrayDouble(values, 0, values.length, true);
    }

    public static ArrayFloat unmodifiableListFloat(float ... values) {
        return new ArrayFloat(values, 0, values.length, true);
    }

    public static ArrayLong unmodifiableListLong(long ... values) {
        return new ArrayLong(values, 0, values.length, true);
    }

    public static ArrayULong unmodifiableListULong(long ... values) {
        return new ArrayULong(values, 0, values.length, true);
    }

    public static ArrayInteger unmodifiableListInt(int ... values) {
        return new ArrayInteger(values, 0, values.length, true);
    }

    public static ArrayUInteger unmodifiableListUInt(int ... values) {
        return new ArrayUInteger(values, 0, values.length, true);
    }

    public static ArrayShort unmodifiableListShort(short ... values) {
        return new ArrayShort(values, 0, values.length, true);
    }

    public static ArrayUShort unmodifiableListUShort(short ... values) {
        return new ArrayUShort(values, 0, values.length, true);
    }

    public static ArrayByte unmodifiableListByte(byte ... values) {
        return new ArrayByte(values, 0, values.length, true);
    }

    public static ArrayUByte unmodifiableListUByte(byte ... values) {
        return new ArrayUByte(values, 0, values.length, true);
    }

    static <T> T defaultToArray(CollectionNumber coll, T array) {
        if (array instanceof double[]) {
            double[] doubleArray = ((double[])array).length < coll.size() ? new double[coll.size()] : (double[])array;
            CollectionNumbers.arrayCopy(coll, doubleArray, 0);
            return (T)doubleArray;
        }
        if (array instanceof float[]) {
            float[] floatArray = ((float[])array).length < coll.size() ? new float[coll.size()] : (float[])array;
            CollectionNumbers.arrayCopy(coll, floatArray, 0);
            return (T)floatArray;
        }
        if (array instanceof long[]) {
            long[] longArray = ((long[])array).length < coll.size() ? new long[coll.size()] : (long[])array;
            CollectionNumbers.arrayCopy(coll, longArray, 0);
            return (T)longArray;
        }
        if (array instanceof int[]) {
            int[] intArray = ((int[])array).length < coll.size() ? new int[coll.size()] : (int[])array;
            CollectionNumbers.arrayCopy(coll, intArray, 0);
            return (T)intArray;
        }
        if (array instanceof short[]) {
            short[] shortArray = ((short[])array).length < coll.size() ? new short[coll.size()] : (short[])array;
            CollectionNumbers.arrayCopy(coll, shortArray, 0);
            return (T)shortArray;
        }
        if (array instanceof byte[]) {
            byte[] byteArray = ((byte[])array).length < coll.size() ? new byte[coll.size()] : (byte[])array;
            CollectionNumbers.arrayCopy(coll, byteArray, 0);
            return (T)byteArray;
        }
        if (array == null) {
            throw new NullPointerException();
        }
        throw new ArrayStoreException("Argument must be an array of primitive numbers");
    }

    public static void arrayCopy(CollectionNumber src, double[] dest, int destPos) {
        if (destPos + src.size() > dest.length) {
            throw new IndexOutOfBoundsException("Length of target array too small");
        }
        IteratorNumber iter = src.iterator();
        int index = destPos;
        while (iter.hasNext()) {
            dest[index] = iter.nextDouble();
            ++index;
        }
    }

    public static void arrayCopy(CollectionNumber src, float[] dest, int destPos) {
        if (destPos + src.size() > dest.length) {
            throw new IndexOutOfBoundsException("Length of target array too small");
        }
        IteratorNumber iter = src.iterator();
        int index = destPos;
        while (iter.hasNext()) {
            dest[index] = iter.nextFloat();
            ++index;
        }
    }

    public static void arrayCopy(CollectionNumber src, long[] dest, int destPos) {
        if (destPos + src.size() > dest.length) {
            throw new IndexOutOfBoundsException("Length of target array too small");
        }
        IteratorNumber iter = src.iterator();
        int index = destPos;
        while (iter.hasNext()) {
            dest[index] = iter.nextLong();
            ++index;
        }
    }

    public static void arrayCopy(CollectionNumber src, int[] dest, int destPos) {
        if (destPos + src.size() > dest.length) {
            throw new IndexOutOfBoundsException("Length of target array too small");
        }
        IteratorNumber iter = src.iterator();
        int index = destPos;
        while (iter.hasNext()) {
            dest[index] = iter.nextInt();
            ++index;
        }
    }

    public static void arrayCopy(CollectionNumber src, short[] dest, int destPos) {
        if (destPos + src.size() > dest.length) {
            throw new IndexOutOfBoundsException("Length of target array too small");
        }
        IteratorNumber iter = src.iterator();
        int index = destPos;
        while (iter.hasNext()) {
            dest[index] = iter.nextShort();
            ++index;
        }
    }

    public static void arrayCopy(CollectionNumber src, byte[] dest, int destPos) {
        if (destPos + src.size() > dest.length) {
            throw new IndexOutOfBoundsException("Length of target array too small");
        }
        IteratorNumber iter = src.iterator();
        int index = destPos;
        while (iter.hasNext()) {
            dest[index] = iter.nextByte();
            ++index;
        }
    }
}

