/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListByte;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListFloat;
import org.epics.util.array.ListInteger;
import org.epics.util.array.ListLong;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListShort;
import org.epics.util.array.ListView;
import org.epics.util.array.SortedListView;

public class ListNumbers {
    public static SortedListView sortedView(ListNumber values) {
        SortedListView view = new SortedListView(values);
        if (values.size() <= 1) {
            return view;
        }
        double value = values.getDouble(0);
        for (int i = 1; i < values.size(); ++i) {
            double newValue = values.getDouble(i);
            if (value > newValue) {
                SortedListView.quicksort(view);
                return view;
            }
            value = newValue;
        }
        return view;
    }

    public static SortedListView sortedView(ListNumber values, ListInteger indexes) {
        SortedListView view = new SortedListView(values, indexes);
        return view;
    }

    public static int binarySearchValueOrLower(ListNumber values, double value) {
        int index;
        if (value <= values.getDouble(0)) {
            return 0;
        }
        if (value >= values.getDouble(values.size() - 1)) {
            return values.size() - 1;
        }
        for (index = ListNumbers.binarySearch(0, values.size() - 1, values, value); index != 0 && value == values.getDouble(index - 1); --index) {
        }
        return index;
    }

    public static int binarySearchValueOrHigher(ListNumber values, double value) {
        int index;
        if (value <= values.getDouble(0)) {
            return 0;
        }
        if (value >= values.getDouble(values.size() - 1)) {
            return values.size() - 1;
        }
        for (index = ListNumbers.binarySearch(0, values.size() - 1, values, value); index != values.size() - 1 && value > values.getDouble(index); ++index) {
        }
        while (index != values.size() - 1 && value == values.getDouble(index + 1)) {
            ++index;
        }
        return index;
    }

    private static int binarySearch(int low, int high, ListNumber values, double value) {
        while (low <= high) {
            long keyBits;
            int mid = low + high >>> 1;
            double midVal = values.getDouble(mid);
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(value))) {
                return mid;
            }
            if (midBits < keyBits) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return low - 1;
    }

    public static ListNumber linearListFromRange(double minValue, double maxValue, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive (was " + size + " )");
        }
        return new LinearListDoubleFromRange(size, minValue, maxValue);
    }

    public static ListNumber linearList(double initialValue, double increment, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive (was " + size + " )");
        }
        return new LinearListDouble(size, initialValue, increment);
    }

    public static boolean isLinear(ListNumber listNumber) {
        if (listNumber instanceof LinearListDouble || listNumber instanceof LinearListDoubleFromRange) {
            return true;
        }
        ListDouble diff = ListMath.subtract(listNumber, ListNumbers.linearListFromRange(listNumber.getDouble(0), listNumber.getDouble(listNumber.size() - 1), listNumber.size()));
        for (int i = 0; i < diff.size(); ++i) {
            if (!(Math.abs(diff.getDouble(i)) > Math.ulp(listNumber.getDouble(i)))) continue;
            return false;
        }
        return true;
    }

    public static ListNumber listView(ListNumber list, ListInteger indexes) {
        if (list instanceof ListDouble) {
            return new ListView.Double((ListDouble)list, indexes);
        }
        if (list instanceof ListFloat) {
            return new ListView.Float((ListFloat)list, indexes);
        }
        if (list instanceof ListLong) {
            return new ListView.Long((ListLong)list, indexes);
        }
        if (list instanceof ListInteger) {
            return new ListView.Int((ListInteger)list, indexes);
        }
        if (list instanceof ListShort) {
            return new ListView.Short((ListShort)list, indexes);
        }
        if (list instanceof ListByte) {
            return new ListView.Byte((ListByte)list, indexes);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    public static ListDouble concatenate(final ListNumber ... lists) {
        if (lists.length == 0) {
            return CollectionNumbers.unmodifiableListDouble(new double[0]);
        }
        return new ListDouble(){

            @Override
            public int size() {
                int size = 0;
                for (ListNumber list : lists) {
                    size += list.size();
                }
                return size;
            }

            @Override
            public double getDouble(int index) {
                if (index < 0 || index >= this.size()) {
                    throw new IndexOutOfBoundsException("Index out of bounds: " + index + ", size: " + this.size());
                }
                int currentListStart = 0;
                for (ListNumber list : lists) {
                    int currentListEnd = currentListStart + list.size();
                    if (index < currentListEnd) {
                        return list.getDouble(index - currentListStart);
                    }
                    currentListStart = currentListEnd;
                }
                throw new RuntimeException("Reached unreachable code - please contact developers");
            }

            @Override
            public void setDouble(int index, double value) {
                if (index < 0 || index >= this.size()) {
                    throw new IndexOutOfBoundsException("Index out of bounds: " + index + ", size: " + this.size());
                }
                int currentListStart = 0;
                for (ListNumber list : lists) {
                    int currentListEnd = currentListStart + list.size();
                    if (index < currentListEnd) {
                        list.setDouble(index - currentListStart, value);
                        return;
                    }
                    currentListStart = currentListEnd;
                }
                throw new RuntimeException("Reached unreachable code - please contact developers");
            }
        };
    }

    private static class LinearListDouble
    extends ListDouble {
        private final int size;
        private final double initialValue;
        private final double increment;

        public LinearListDouble(int size, double initialValue, double increment) {
            this.size = size;
            this.initialValue = initialValue;
            this.increment = increment;
        }

        @Override
        public double getDouble(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return this.initialValue + (double)index * this.increment;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static class LinearListDoubleFromRange
    extends ListDouble {
        private final int size;
        private final double minValue;
        private final double maxValue;

        public LinearListDoubleFromRange(int size, double minValue, double maxValue) {
            this.size = size;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public double getDouble(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return this.minValue + (double)index * (this.maxValue - this.minValue) / (double)(this.size - 1);
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

