/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListInteger;
import org.epics.util.array.ListNumber;

public class SortedListView
extends ListDouble {
    private ListNumber values;
    private ListInteger indexes;
    private int[] indexArray;

    SortedListView(ListNumber values) {
        this.values = values;
        this.indexArray = new int[values.size()];
        for (int i = 0; i < this.indexArray.length; ++i) {
            this.indexArray[i] = i;
        }
        this.indexes = CollectionNumbers.unmodifiableListInt(this.indexArray);
    }

    SortedListView(ListNumber values, ListInteger indexes) {
        this.values = values;
        this.indexes = indexes;
        this.indexArray = null;
    }

    @Override
    public double getDouble(int index) {
        return this.values.getDouble(this.indexes.getInt(index));
    }

    @Override
    public int size() {
        return this.values.size();
    }

    void exhange(int i, int j) {
        int b = this.indexArray[i];
        this.indexArray[i] = this.indexArray[j];
        this.indexArray[j] = b;
    }

    public ListInteger getIndexes() {
        return this.indexes;
    }

    static void quicksort(SortedListView list) {
        SortedListView.quicksort(list, 0, list.size() - 1);
    }

    private static void quicksort(SortedListView list, int left, int right) {
        if (right <= left) {
            return;
        }
        int i = SortedListView.partition(list, left, right);
        SortedListView.quicksort(list, left, i - 1);
        SortedListView.quicksort(list, i + 1, right);
    }

    private static int partition(SortedListView list, int left, int right) {
        int i = left - 1;
        int j = right;
        while (true) {
            if (SortedListView.less(list.getDouble(++i), list.getDouble(right))) {
                continue;
            }
            while (SortedListView.less(list.getDouble(right), list.getDouble(--j)) && j != left) {
            }
            if (i >= j) break;
            list.exhange(i, j);
        }
        list.exhange(i, right);
        return i;
    }

    private static boolean less(double x, double y) {
        return x < y;
    }
}

