/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.stats;

public final class Range {
    private static final Range UNDEFINED = new Range(Double.NaN, Double.NaN, false);
    private final double min;
    private final double max;
    private final boolean reversed;

    Range(double min, double max, boolean reversed) {
        this.min = min;
        this.max = max;
        this.reversed = reversed;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public boolean isFinite() {
        return this.min != this.max && !Double.isNaN(this.min) && !Double.isInfinite(this.min) && !Double.isNaN(this.max) && !Double.isInfinite(this.max);
    }

    public double normalize(double value) {
        return (value - this.getMinimum()) / (this.getMaximum() - this.getMinimum());
    }

    public double rescale(double value) {
        return this.getMinimum() + value * (this.getMaximum() - this.getMinimum());
    }

    public boolean contains(double value) {
        return value >= this.getMinimum() && value <= this.getMaximum();
    }

    public boolean contains(Range range) {
        return this.getMinimum() <= range.getMinimum() && this.getMaximum() >= range.getMaximum();
    }

    public Range combine(Range other) {
        if (this == UNDEFINED) {
            return other;
        }
        if (other == UNDEFINED) {
            return this;
        }
        if (this.getMinimum() <= other.getMinimum()) {
            if (this.getMaximum() >= other.getMaximum()) {
                return this;
            }
            return Range.of(this.getMinimum(), other.getMaximum());
        }
        if (this.getMaximum() >= other.getMaximum()) {
            return Range.of(other.getMinimum(), this.getMaximum());
        }
        return other;
    }

    public Range shrink(double factor) {
        if (this == UNDEFINED) {
            return UNDEFINED;
        }
        double center = (this.min + this.max) / 2.0;
        double width = this.max - this.min;
        return Range.of(center - width * factor / 2.0, center + width * factor / 2.0);
    }

    public static Range undefined() {
        return UNDEFINED;
    }

    public String toString() {
        if (!this.isReversed()) {
            return "[" + this.getMinimum() + " - " + this.getMaximum() + "]";
        }
        return "[" + this.getMaximum() + " - " + this.getMinimum() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return this.getMinimum() == other.getMinimum() && this.getMaximum() == other.getMaximum() && this.isReversed() == other.isReversed();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.min) ^ Double.doubleToLongBits(this.min) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.max) ^ Double.doubleToLongBits(this.max) >>> 32);
        hash = 97 * hash + (this.reversed ? 1 : 0);
        return hash;
    }

    public static Range of(double minValue, double maxValue) {
        if (Double.isNaN(minValue) || Double.isNaN(maxValue)) {
            return UNDEFINED;
        }
        if (minValue > maxValue) {
            return new Range(maxValue, minValue, true);
        }
        return new Range(minValue, maxValue, false);
    }
}

