/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.io.Serializable;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.IteratorDouble;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;

public final class ArrayDouble
extends ListDouble
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] array;
    private final int startIndex;
    private final int size;
    private final boolean checkBoundaries;
    private final boolean readOnly;

    public ArrayDouble(CollectionNumber coll) {
        this(coll.toArray(new double[coll.size()]), 0, coll.size(), false);
    }

    ArrayDouble(double[] array, int startIndex, int size, boolean readOnly) {
        if (startIndex < 0 || startIndex + size > array.length) {
            throw new IndexOutOfBoundsException("Start index: " + startIndex + ", Size: " + size + ", Array length: " + array.length);
        }
        this.array = array;
        this.readOnly = readOnly;
        this.startIndex = startIndex;
        this.size = size;
        this.checkBoundaries = startIndex != 0 || size != array.length;
    }

    @Override
    public final IteratorDouble iterator() {
        return new IteratorDouble(){
            private int index;
            {
                this.index = ArrayDouble.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < ArrayDouble.this.startIndex + ArrayDouble.this.size;
            }

            @Override
            public double nextDouble() {
                return ArrayDouble.this.array[this.index++];
            }
        };
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public double getDouble(int index) {
        if (this.checkBoundaries && (index < 0 || index >= this.size)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.array[this.startIndex + index];
    }

    @Override
    public void setDouble(int index, double value) {
        if (!this.readOnly) {
            if (this.checkBoundaries && (index < 0 || index >= this.size)) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        } else {
            throw new UnsupportedOperationException("Read only list.");
        }
        this.array[this.startIndex + index] = value;
    }

    @Override
    public ArrayDouble subList(int fromIndex, int toIndex) {
        return new ArrayDouble(this.array, fromIndex + this.startIndex, toIndex - fromIndex, this.readOnly);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (list instanceof ArrayDouble) {
            if (this.readOnly) {
                throw new UnsupportedOperationException("Read only list.");
            }
            ArrayDouble other = (ArrayDouble)list;
            System.arraycopy(other.array, other.startIndex, this.array, this.startIndex + index, other.size);
        } else {
            super.setAll(index, list);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayDouble) {
            ArrayDouble other = (ArrayDouble)obj;
            if (this.array == other.array && this.startIndex == other.startIndex && this.size == other.size) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public <T> T toArray(T array) {
        if (array instanceof double[]) {
            double[] doubleArray = ((double[])array).length < this.size() ? new double[this.size()] : (double[])array;
            System.arraycopy(this.array, this.startIndex, doubleArray, 0, this.size);
            return (T)doubleArray;
        }
        return super.toArray(array);
    }

    double[] wrappedArray() {
        return this.array;
    }

    int startIndex() {
        return this.startIndex;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    public static ArrayDouble of(double ... values) {
        return CollectionNumbers.unmodifiableListDouble(values);
    }
}

