/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.io.Serializable;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.IteratorFloat;
import org.epics.util.array.ListFloat;
import org.epics.util.array.ListNumber;

public final class ArrayFloat
extends ListFloat
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final float[] array;
    private final int startIndex;
    private final int size;
    private final boolean checkBoundaries;
    private final boolean readOnly;

    public ArrayFloat(ListNumber coll) {
        this(coll.toArray(new float[coll.size()]), 0, coll.size(), false);
    }

    ArrayFloat(float[] array, int startIndex, int size, boolean readOnly) {
        if (startIndex < 0 || startIndex + size > array.length) {
            throw new IndexOutOfBoundsException("Start index: " + startIndex + ", Size: " + size + ", Array length: " + array.length);
        }
        this.array = array;
        this.readOnly = readOnly;
        this.startIndex = startIndex;
        this.size = size;
        this.checkBoundaries = startIndex != 0 || size != array.length;
    }

    @Override
    public final IteratorFloat iterator() {
        return new IteratorFloat(){
            private int index;
            {
                this.index = ArrayFloat.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < ArrayFloat.this.startIndex + ArrayFloat.this.size;
            }

            @Override
            public float nextFloat() {
                return ArrayFloat.this.array[this.index++];
            }
        };
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public float getFloat(int index) {
        if (this.checkBoundaries && (index < 0 || index >= this.size)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.array[this.startIndex + index];
    }

    @Override
    public void setFloat(int index, float value) {
        if (!this.readOnly) {
            if (this.checkBoundaries && (index < 0 || index >= this.size)) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        } else {
            throw new UnsupportedOperationException("Read only list.");
        }
        this.array[this.startIndex + index] = value;
    }

    @Override
    public ArrayFloat subList(int fromIndex, int toIndex) {
        return new ArrayFloat(this.array, fromIndex + this.startIndex, toIndex - fromIndex, this.readOnly);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (list instanceof ArrayFloat) {
            if (this.readOnly) {
                throw new UnsupportedOperationException("Read only list.");
            }
            ArrayFloat other = (ArrayFloat)list;
            System.arraycopy(other.array, other.startIndex, this.array, this.startIndex + index, other.size);
        } else {
            super.setAll(index, list);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayFloat) {
            ArrayFloat other = (ArrayFloat)obj;
            if (this.array == other.array && this.startIndex == other.startIndex && this.size == other.size) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public <T> T toArray(T array) {
        if (array instanceof float[]) {
            float[] floatArray = ((float[])array).length < this.size() ? new float[this.size()] : (float[])array;
            System.arraycopy(this.array, this.startIndex, floatArray, 0, this.size);
            return (T)floatArray;
        }
        return super.toArray(array);
    }

    float[] wrappedArray() {
        return this.array;
    }

    int startIndex() {
        return this.startIndex;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    public static ArrayFloat of(float ... values) {
        return CollectionNumbers.unmodifiableListFloat(values);
    }
}

