/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.io.Serializable;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.IteratorUInteger;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListUInteger;

public final class ArrayUInteger
extends ListUInteger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] array;
    private final int startIndex;
    private final int size;
    private final boolean checkBoundaries;
    private final boolean readOnly;

    public ArrayUInteger(CollectionNumber coll) {
        this(coll.toArray(new int[coll.size()]), 0, coll.size(), false);
    }

    ArrayUInteger(int[] array, int startIndex, int size, boolean readOnly) {
        if (startIndex < 0 || startIndex + size > array.length) {
            throw new IndexOutOfBoundsException("Start index: " + startIndex + ", Size: " + size + ", Array length: " + array.length);
        }
        this.array = array;
        this.readOnly = readOnly;
        this.startIndex = startIndex;
        this.size = size;
        this.checkBoundaries = startIndex != 0 || size != array.length;
    }

    @Override
    public final IteratorUInteger iterator() {
        return new IteratorUInteger(){
            private int index;
            {
                this.index = ArrayUInteger.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < ArrayUInteger.this.startIndex + ArrayUInteger.this.size;
            }

            @Override
            public int nextInt() {
                return ArrayUInteger.this.array[this.index++];
            }
        };
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public int getInt(int index) {
        if (this.checkBoundaries && (index < 0 || index >= this.size)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.array[this.startIndex + index];
    }

    @Override
    public void setInt(int index, int value) {
        if (!this.readOnly) {
            if (this.checkBoundaries && (index < 0 || index >= this.size)) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        } else {
            throw new UnsupportedOperationException("Read only list.");
        }
        this.array[this.startIndex + index] = value;
    }

    @Override
    public ArrayUInteger subList(int fromIndex, int toIndex) {
        return new ArrayUInteger(this.array, fromIndex + this.startIndex, toIndex - fromIndex, this.readOnly);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (list instanceof ArrayUInteger) {
            if (this.readOnly) {
                throw new UnsupportedOperationException("Read only list.");
            }
            ArrayUInteger other = (ArrayUInteger)list;
            System.arraycopy(other.array, other.startIndex, this.array, this.startIndex + index, other.size);
        } else {
            super.setAll(index, list);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayUInteger) {
            ArrayUInteger other = (ArrayUInteger)obj;
            if (this.array == other.array && this.startIndex == other.startIndex && this.size == other.size) {
                return true;
            }
        }
        return super.equals(obj);
    }

    int[] wrappedArray() {
        return this.array;
    }

    int startIndex() {
        return this.startIndex;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    public static ArrayUInteger of(int ... values) {
        return CollectionNumbers.unmodifiableListUInt(values);
    }
}

