/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import java.io.Serializable;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.IteratorUShort;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListUShort;

public final class ArrayUShort
extends ListUShort
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final short[] array;
    private final int startIndex;
    private final int size;
    private final boolean checkBoundaries;
    private final boolean readOnly;

    public ArrayUShort(CollectionNumber coll) {
        this(coll.toArray(new short[coll.size()]), 0, coll.size(), false);
    }

    ArrayUShort(short[] array, int startIndex, int size, boolean readOnly) {
        if (startIndex < 0 || startIndex + size > array.length) {
            throw new IndexOutOfBoundsException("Start index: " + startIndex + ", Size: " + size + ", Array length: " + array.length);
        }
        this.array = array;
        this.readOnly = readOnly;
        this.startIndex = startIndex;
        this.size = size;
        this.checkBoundaries = startIndex != 0 || size != array.length;
    }

    @Override
    public final IteratorUShort iterator() {
        return new IteratorUShort(){
            private int index;
            {
                this.index = ArrayUShort.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < ArrayUShort.this.startIndex + ArrayUShort.this.size;
            }

            @Override
            public short nextShort() {
                return ArrayUShort.this.array[this.index++];
            }
        };
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public short getShort(int index) {
        if (this.checkBoundaries && (index < 0 || index >= this.size)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.array[this.startIndex + index];
    }

    @Override
    public void setShort(int index, short value) {
        if (!this.readOnly) {
            if (this.checkBoundaries && (index < 0 || index >= this.size)) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        } else {
            throw new UnsupportedOperationException("Read only list.");
        }
        this.array[this.startIndex + index] = value;
    }

    @Override
    public ArrayUShort subList(int fromIndex, int toIndex) {
        return new ArrayUShort(this.array, fromIndex + this.startIndex, toIndex - fromIndex, this.readOnly);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (list instanceof ArrayUShort) {
            if (this.readOnly) {
                throw new UnsupportedOperationException("Read only list.");
            }
            ArrayUShort other = (ArrayUShort)list;
            System.arraycopy(other.array, other.startIndex, this.array, this.startIndex + index, other.size);
        } else {
            super.setAll(index, list);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArrayUShort) {
            ArrayUShort other = (ArrayUShort)obj;
            if (this.array == other.array && this.startIndex == other.startIndex && this.size == other.size) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public <T> T toArray(T array) {
        if (array instanceof short[]) {
            short[] shortArray = ((short[])array).length < this.size() ? new short[this.size()] : (short[])array;
            System.arraycopy(this.array, this.startIndex, shortArray, 0, this.size);
            return (T)shortArray;
        }
        return super.toArray(array);
    }

    short[] wrappedArray() {
        return this.array;
    }

    int startIndex() {
        return this.startIndex;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    public static ArrayUShort of(short ... values) {
        return CollectionNumbers.unmodifiableListUShort(values);
    }
}

