/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionByte;
import org.epics.util.array.IteratorByte;
import org.epics.util.array.ListNumber;

public abstract class ListByte
implements ListNumber,
CollectionByte {
    @Override
    public IteratorByte iterator() {
        return new IteratorByte(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ListByte.this.size();
            }

            @Override
            public byte nextByte() {
                return ListByte.this.getByte(this.index++);
            }
        };
    }

    @Override
    public double getDouble(int index) {
        return this.getByte(index);
    }

    @Override
    public float getFloat(int index) {
        return this.getByte(index);
    }

    @Override
    public long getLong(int index) {
        return this.getByte(index);
    }

    @Override
    public int getInt(int index) {
        return this.getByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.getByte(index);
    }

    @Override
    public void setDouble(int index, double value) {
        this.setByte(index, (byte)value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setByte(index, (byte)value);
    }

    @Override
    public void setLong(int index, long value) {
        this.setByte(index, (byte)value);
    }

    @Override
    public void setInt(int index, int value) {
        this.setByte(index, (byte)value);
    }

    @Override
    public void setShort(int index, short value) {
        this.setByte(index, (byte)value);
    }

    @Override
    public void setByte(int index, byte value) {
        throw new UnsupportedOperationException("Read only list.");
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (index + list.size() > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Elements: " + list.size() + ", Size: " + this.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.setByte(index + i, list.getByte(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListByte) {
            ListByte other = (ListByte)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getByte(i) == other.getByte(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + this.getShort(i);
        }
        return result;
    }

    public String toString() {
        int i;
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (i = 0; i < this.size() - 1; ++i) {
            builder.append(this.getByte(i)).append(", ");
        }
        builder.append(this.getByte(i)).append("]");
        return builder.toString();
    }

    @Override
    public ListByte subList(final int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + ", size: " + this.size());
        }
        final int size = toIndex - fromIndex;
        return new ListByte(){

            @Override
            public byte getByte(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return ListByte.this.getByte(fromIndex + index);
            }

            @Override
            public void setByte(int index, byte value) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                ListByte.this.setByte(fromIndex + index, value);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

