/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionUInteger;
import org.epics.util.array.IteratorUInteger;
import org.epics.util.array.ListNumber;
import org.epics.util.number.UnsignedConversions;

public abstract class ListUInteger
implements ListNumber,
CollectionUInteger {
    @Override
    public IteratorUInteger iterator() {
        return new IteratorUInteger(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ListUInteger.this.size();
            }

            @Override
            public int nextInt() {
                return ListUInteger.this.getInt(this.index++);
            }
        };
    }

    @Override
    public double getDouble(int index) {
        return UnsignedConversions.toDouble(this.getInt(index));
    }

    @Override
    public float getFloat(int index) {
        return UnsignedConversions.toFloat(this.getInt(index));
    }

    @Override
    public long getLong(int index) {
        return UnsignedConversions.toLong(this.getInt(index));
    }

    @Override
    public short getShort(int index) {
        return (short)this.getInt(index);
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.getInt(index);
    }

    @Override
    public void setDouble(int index, double value) {
        this.setInt(index, (int)value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setInt(index, (int)value);
    }

    @Override
    public void setLong(int index, long value) {
        this.setInt(index, (int)value);
    }

    @Override
    public void setInt(int index, int value) {
        throw new UnsupportedOperationException("Read only list.");
    }

    @Override
    public void setShort(int index, short value) {
        this.setInt(index, value);
    }

    @Override
    public void setByte(int index, byte value) {
        this.setInt(index, value);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (index + list.size() > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Elements: " + list.size() + ", Size: " + this.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.setInt(index + i, list.getInt(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListUInteger) {
            ListUInteger other = (ListUInteger)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getInt(i) == other.getInt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + this.getInt(i);
        }
        return result;
    }

    public String toString() {
        int i;
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (i = 0; i < this.size() - 1; ++i) {
            builder.append(this.getLong(i)).append(", ");
        }
        builder.append(this.getLong(i)).append("]");
        return builder.toString();
    }

    @Override
    public ListUInteger subList(final int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + ", size: " + this.size());
        }
        final int size = toIndex - fromIndex;
        return new ListUInteger(){

            @Override
            public int getInt(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return ListUInteger.this.getInt(fromIndex + index);
            }

            @Override
            public void setInt(int index, int value) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                ListUInteger.this.setInt(fromIndex + index, value);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

