/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.array;

import org.epics.util.array.CollectionUShort;
import org.epics.util.array.IteratorUShort;
import org.epics.util.array.ListNumber;
import org.epics.util.number.UnsignedConversions;

public abstract class ListUShort
implements ListNumber,
CollectionUShort {
    @Override
    public IteratorUShort iterator() {
        return new IteratorUShort(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < ListUShort.this.size();
            }

            @Override
            public short nextShort() {
                return ListUShort.this.getShort(this.index++);
            }
        };
    }

    @Override
    public double getDouble(int index) {
        return UnsignedConversions.toDouble(this.getShort(index));
    }

    @Override
    public float getFloat(int index) {
        return UnsignedConversions.toFloat(this.getShort(index));
    }

    @Override
    public long getLong(int index) {
        return UnsignedConversions.toLong(this.getShort(index));
    }

    @Override
    public int getInt(int index) {
        return UnsignedConversions.toInt(this.getShort(index));
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.getShort(index);
    }

    @Override
    public void setDouble(int index, double value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setFloat(int index, float value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setLong(int index, long value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setInt(int index, int value) {
        this.setShort(index, (short)value);
    }

    @Override
    public void setShort(int index, short value) {
        throw new UnsupportedOperationException("Read only list.");
    }

    @Override
    public void setByte(int index, byte value) {
        this.setShort(index, value);
    }

    @Override
    public void setAll(int index, ListNumber list) {
        if (index + list.size() > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Elements: " + list.size() + ", Size: " + this.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.setShort(index + i, list.getShort(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ListUShort) {
            ListUShort other = (ListUShort)obj;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getShort(i) == other.getShort(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size(); ++i) {
            result = 31 * result + this.getShort(i);
        }
        return result;
    }

    public String toString() {
        int i;
        if (this.size() == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (i = 0; i < this.size() - 1; ++i) {
            builder.append(this.getInt(i)).append(", ");
        }
        builder.append(this.getInt(i)).append("]");
        return builder.toString();
    }

    @Override
    public ListUShort subList(final int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + ", size: " + this.size());
        }
        final int size = toIndex - fromIndex;
        return new ListUShort(){

            @Override
            public short getShort(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                return ListUShort.this.getShort(fromIndex + index);
            }

            @Override
            public void setShort(int index, short value) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
                }
                ListUShort.this.setShort(fromIndex + index, value);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }
}

