/*
 * Decompiled with CFR 0.152.
 */
package org.epics.util.number;

import org.epics.util.number.UnsignedConversions;

public final class UInteger
extends Number {
    private final int unsignedValue;

    public UInteger(int unsignedValue) {
        this.unsignedValue = unsignedValue;
    }

    @Override
    public int intValue() {
        return this.unsignedValue;
    }

    @Override
    public long longValue() {
        return UnsignedConversions.toLong(this.unsignedValue);
    }

    @Override
    public float floatValue() {
        return UnsignedConversions.toFloat(this.unsignedValue);
    }

    @Override
    public double doubleValue() {
        return UnsignedConversions.toDouble(this.unsignedValue);
    }

    public static UInteger valueOf(int unsignedValue) {
        return new UInteger(unsignedValue);
    }

    public static String toString(int unsignedValue) {
        return Integer.toUnsignedString(unsignedValue, 10);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UInteger) {
            return this.unsignedValue == ((UInteger)obj).unsignedValue;
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.unsignedValue);
    }

    public String toString() {
        return UInteger.toString(this.unsignedValue);
    }
}

